/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RelationValueVerifier
extends Verifier {
    private RelationValue relationValue;
    private Map<String, List<String>> relationValueMaps;
    private List<String> validValues;

    public RelationValueVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        return ResourceConfigLoader.getStringFromExportMsgWithParams("verify.params.relation.desc", this.relationValue.getLocation().toString(), this.relationValue.getValue(), String.join((CharSequence)",", this.validValues));
    }

    @Override
    protected boolean isValueValid() {
        String relation = this.relationValue.getValue();
        if (StringUtils.isEmpty((CharSequence)relation)) {
            return true;
        }
        this.validValues = this.relationValueMaps.getOrDefault(relation, Collections.emptyList());
        return this.validValues.contains(this.value);
    }

    @Override
    public void setParam(String param) {
        this.relationValueMaps = Arrays.stream(param.split(";")).map(relValue -> relValue.split(":")).filter(relValues -> ((String[])relValues).length >= 2).collect(Collectors.toMap(relValues -> relValues[0], relValues -> Arrays.asList(relValues[1].split(","))));
    }

    @Override
    public void setRelationValues(List<RelationValue> relationValues) {
        this.relationValue = relationValues.get(0);
    }
}

