/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class StorageCte0MandatoryVerifier
extends Verifier {
    private RelationValue relationControllerIdValue;
    private boolean isCheckManageIp;
    private String resourceKey;

    public StorageCte0MandatoryVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        if (StringUtils.isNotEmpty((CharSequence)this.resourceKey)) {
            return this.getResourceByKey("verify.params.storage.cte0.mandatory.all.invalid");
        }
        return this.getResourceByKeyWithParams("verify.params.storage.cte0.mandatory.value.invalid", this.getResourceByKey(this.resourceKey));
    }

    @Override
    public boolean doVerify() {
        return this.isValueValid();
    }

    @Override
    protected boolean isValueValid() {
        String ctrlId = this.relationControllerIdValue.getValue();
        if (this.isCheckManageIp && Arrays.asList("CTE0-A", "CTE0-B").contains(ctrlId)) {
            return StringUtils.isNotEmpty((CharSequence)this.value);
        }
        if (!this.isCheckManageIp && Objects.equals("CTE0-A", ctrlId)) {
            return StringUtils.isNotEmpty((CharSequence)this.value);
        }
        return true;
    }

    @Override
    public void setRelationValues(List<RelationValue> relationValues) {
        this.relationControllerIdValue = relationValues.get(0);
    }

    @Override
    public void setParam(String param) {
        super.setParam(param);
        String[] split = param.split(" desc:");
        if (split.length > 1) {
            this.resourceKey = split[1];
        }
        this.isCheckManageIp = Boolean.parseBoolean(split[0]);
    }
}

