/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.VerticalCellVerifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;

public class StorageManageIpRequiredVerifier
extends VerticalCellVerifier {
    private List<String> invalidCtrlIds = new LinkedList<String>();

    public StorageManageIpRequiredVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        return this.getResourceByKeyWithParams("verify.params.storage.mgmt.ip.required.invalid", String.join((CharSequence)",", this.invalidCtrlIds));
    }

    @Override
    protected boolean isValueValid() {
        List values = this.relationValues.stream().map(RelationValue::getValue).collect(Collectors.toList());
        values.add(this.value);
        this.invalidCtrlIds = IntStream.range(0, values.size() / 4).map(idx -> idx * 4).mapToObj(idx -> this.checkValueInvalidCtrlId((String)values.get(idx), (String)values.get(idx + 2), (String)values.get(idx + 1), idx)).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        return CollectionUtils.isEmpty(this.invalidCtrlIds);
    }

    private String checkValueInvalidCtrlId(String manageIpA, String manageIpB, String value, int idx) {
        int ctrlIdValue = idx / 4;
        if (StringUtils.isEmpty((CharSequence)value)) {
            if (StringUtils.isNotEmpty((CharSequence)manageIpA)) {
                return "CTE" + ctrlIdValue + "-A";
            }
            if (StringUtils.isNotEmpty((CharSequence)manageIpB)) {
                return "CTE" + ctrlIdValue + "-B";
            }
        }
        return "";
    }
}

