/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class StoragePortPhysicPortVerifier
extends Verifier {
    private RelationValue relationBoundNameValue;
    private RelationValue relationControllerIdValue;
    private String controllerPrefixName;
    private boolean bondMode = false;
    private List<String> invalidPort;

    public StoragePortPhysicPortVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        if (CollectionUtils.isNotEmpty(this.invalidPort)) {
            return this.getResourceByKeyWithParams("deploy.params.physci.storage.port.value.invalid", String.join((CharSequence)",", this.invalidPort));
        }
        if (this.bondMode) {
            return this.getResourceByKey("deploy.params.physci.storage.port.bond.value.invalid");
        }
        return this.getResourceByKey("deploy.params.physci.port.not.bond.value.invalid");
    }

    @Override
    protected boolean isValueValid() {
        this.checkValue();
        String bondName = this.relationBoundNameValue.getValue();
        if (StringUtils.isEmpty((CharSequence)bondName)) {
            return !this.value.contains(",") && this.checkPortContainValue();
        }
        this.bondMode = true;
        return this.value.contains(",") && this.checkPortContainValue();
    }

    private boolean checkPortContainValue() {
        return Arrays.stream(this.value.split(",")).allMatch(port -> port.contains(this.controllerPrefixName));
    }

    private void checkValue() {
        this.controllerPrefixName = this.getControllerPrefixName();
        this.invalidPort = Arrays.stream(this.value.split(",")).filter(port -> !port.contains(this.controllerPrefixName)).collect(Collectors.toList());
    }

    private String getControllerPrefixName() {
        return Optional.ofNullable(this.relationControllerIdValue.getValue()).map(id -> id.replace('-', '.')).orElse("");
    }

    @Override
    public void setRelationValues(List<RelationValue> relationValues) {
        this.relationBoundNameValue = relationValues.get(0);
        this.relationControllerIdValue = relationValues.get(1);
    }
}

