/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.AreaConfigTool;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeZoneVerifier
extends Verifier {
    private static final Logger log = LoggerFactory.getLogger(TimeZoneVerifier.class);
    private RelationValue relationValue;
    private boolean foundTimezone = true;
    private String timezone;

    public TimeZoneVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        if (!this.foundTimezone) {
            return this.getResourceByKeyWithParams("deploy.params.timezone.not.found", this.relationValue.getLocation().toString());
        }
        return this.getResourceByKeyWithParams("deploy.params.relation.tips", this.relationValue.getLocation().toString(), this.relationValue.getValue(), this.getShowParam());
    }

    @Override
    public boolean isValueValid() {
        String area = this.relationValue.getValue();
        this.timezone = AreaConfigTool.getInstance().getTimezoneWithArea(area);
        if (StringUtils.isEmpty((CharSequence)this.timezone)) {
            log.warn("get area {} timezone failed", (Object)area);
            this.foundTimezone = false;
            return true;
        }
        return Arrays.asList(this.timezone.split(",")).contains(this.value);
    }

    @Override
    protected String getInputParam() {
        return this.timezone;
    }

    @Override
    public void setRelationValues(List<RelationValue> relationValues) {
        this.relationValue = relationValues.get(0);
    }
}

