/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageType;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.service.verifier.MsgShow;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.List;

public abstract class Verifier
implements MsgShow {
    protected final String value;
    protected final Location currentLocation;

    @Override
    public String getLocation() {
        return this.currentLocation.toString();
    }

    public boolean doVerify() {
        if (StringUtils.isEmpty((CharSequence)this.value)) {
            return true;
        }
        return this.isValueValid();
    }

    protected abstract boolean isValueValid();

    public void setParam(String param) {
    }

    protected String getInputParam() {
        return "";
    }

    public void setRelationValues(List<RelationValue> relationValues) {
    }

    protected String getShowParam() {
        String showParam = this.getInputParam();
        if (showParam.contains("|")) {
            String[] split = showParam.split("\\|");
            showParam = LanguageUtils.getCurrentLanguage() == LanguageType.EN ? split[1] : split[0];
        }
        return showParam;
    }

    protected String getResourceByKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return ResourceConfigLoader.getStringFromExportMsg("deploy.params.not.support");
        }
        return ResourceConfigLoader.getStringFromExportMsg(key);
    }

    protected String getResourceByKeyWithParams(String key, Object ... param) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return ResourceConfigLoader.getStringFromExportMsg("deploy.params.not.support");
        }
        return ResourceConfigLoader.getStringFromExportMsgWithParams(key, param);
    }

    public Verifier(String value, Location currentLocation) {
        this.value = value;
        this.currentLocation = currentLocation;
    }

    public Location getCurrentLocation() {
        return this.currentLocation;
    }
}

