/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier.data;

import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.utils.ExcelUtil;
import java.util.Objects;

public class Location {
    private String sheetName;
    private int sheetIndex;
    private int column;
    private int row;

    public String toString() {
        return ResourceConfigLoader.getStringFromExportMsgWithParams("deploy.params.location", this.sheetName, this.row + 1, ExcelUtil.columnNumToCharacter(this.column + 1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.sheetIndex == location.sheetIndex && this.column == location.column && this.row == location.row;
    }

    public int hashCode() {
        return Objects.hash(this.sheetIndex, this.column, this.row);
    }

    Location(String sheetName, int sheetIndex, int column, int row) {
        this.sheetName = sheetName;
        this.sheetIndex = sheetIndex;
        this.column = column;
        this.row = row;
    }

    public static LocationBuilder builder() {
        return new LocationBuilder();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public static class LocationBuilder {
        private String sheetName;
        private int sheetIndex;
        private int column;
        private int row;

        LocationBuilder() {
        }

        public LocationBuilder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public LocationBuilder sheetIndex(int sheetIndex) {
            this.sheetIndex = sheetIndex;
            return this;
        }

        public LocationBuilder column(int column) {
            this.column = column;
            return this;
        }

        public LocationBuilder row(int row) {
            this.row = row;
            return this;
        }

        public Location build() {
            return new Location(this.sheetName, this.sheetIndex, this.column, this.row);
        }

        public String toString() {
            return "Location.LocationBuilder(sheetName=" + this.sheetName + ", sheetIndex=" + this.sheetIndex + ", column=" + this.column + ", row=" + this.row + ")";
        }
    }
}

