/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier.data;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifierDesc {
    private static final Logger log = LoggerFactory.getLogger(VerifierDesc.class);
    private static final String PACKAGE_PATH = "com.huawei.yinglong.virtualization.deploy.service.verifier.";
    private String param;
    private List<Location> relationLocations;
    private String type;
    private String supportScenes;

    public Optional<Verifier> createVerifyObj(String data, Location curLocation, List<RelationValue> relationValues) {
        try {
            Class<?> aClass = Class.forName(PACKAGE_PATH + this.type);
            Constructor<?> constructor = aClass.getConstructor(String.class, Location.class);
            Object verifier = constructor.newInstance(data, curLocation);
            if (StringUtils.isNotEmpty((CharSequence)this.param)) {
                this.setVerifierParam(aClass, verifier, this.param);
            }
            if (CollectionUtils.isNotEmpty(relationValues)) {
                this.setVerifierRelationValue(aClass, verifier, relationValues);
            }
            return Optional.of((Verifier)verifier);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("{} verifier class not found", (Object)this.type, (Object)e);
            return Optional.empty();
        }
    }

    private void setVerifierRelationValue(Class<?> aClass, Object verifier, List<RelationValue> relationValues) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method setRelationValues = aClass.getMethod("setRelationValues", List.class);
        setRelationValues.invoke(verifier, relationValues);
    }

    private void setVerifierParam(Class<?> aClass, Object verifier, String param) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method setParam = aClass.getMethod("setParam", String.class);
        setParam.invoke(verifier, param);
    }

    public List<Location> getRelationLocations() {
        return this.relationLocations.stream().map(this::copyLocation).collect(Collectors.toList());
    }

    private Location copyLocation(Location relation) {
        return Location.builder().sheetName(relation.getSheetName()).sheetIndex(relation.getSheetIndex()).row(relation.getRow()).column(relation.getColumn()).build();
    }

    VerifierDesc(String param, List<Location> relationLocations, String type, String supportScenes) {
        this.param = param;
        this.relationLocations = relationLocations;
        this.type = type;
        this.supportScenes = supportScenes;
    }

    public static VerifierDescBuilder builder() {
        return new VerifierDescBuilder();
    }

    public String getSupportScenes() {
        return this.supportScenes;
    }

    public static class VerifierDescBuilder {
        private String param;
        private List<Location> relationLocations;
        private String type;
        private String supportScenes;

        VerifierDescBuilder() {
        }

        public VerifierDescBuilder param(String param) {
            this.param = param;
            return this;
        }

        public VerifierDescBuilder relationLocations(List<Location> relationLocations) {
            this.relationLocations = relationLocations;
            return this;
        }

        public VerifierDescBuilder type(String type) {
            this.type = type;
            return this;
        }

        public VerifierDescBuilder supportScenes(String supportScenes) {
            this.supportScenes = supportScenes;
            return this;
        }

        public VerifierDesc build() {
            return new VerifierDesc(this.param, this.relationLocations, this.type, this.supportScenes);
        }

        public String toString() {
            return "VerifierDesc.VerifierDescBuilder(param=" + this.param + ", relationLocations=" + this.relationLocations + ", type=" + this.type + ", supportScenes=" + this.supportScenes + ")";
        }
    }
}

