/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier.util;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.valid.PasswordCommonValidUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class PasswordVerifyUtil {
    private static final Map<Location, Predicate<String>> PASSWORD_VERIFY_FUNC = new HashMap<Location, Predicate<String>>();

    public static Predicate<String> getPasswordVerifyByLocation(Location location) {
        if (location.getSheetIndex() == 0) {
            return PASSWORD_VERIFY_FUNC.getOrDefault(location, PasswordVerifyUtil::verifyByDefault);
        }
        Location copyLocation = Location.builder().sheetIndex(location.getSheetIndex()).row(1).column(location.getColumn()).build();
        return PASSWORD_VERIFY_FUNC.getOrDefault(copyLocation, PasswordVerifyUtil::verifyByDefault);
    }

    public static Location buildLocation(int sheetIndex, int row, int col) {
        return Location.builder().sheetIndex(sheetIndex).row(row).column(col).build();
    }

    public static boolean verifyByDefault(String value) {
        return PasswordCommonValidUtils.validLengthPassword((String)value, (int)8, (int)32) && PasswordCommonValidUtils.validCommonCharacterPassword((String)value);
    }

    public static boolean verifyAdminPassword(String value) {
        return PasswordCommonValidUtils.validLengthPassword((String)value, (int)8, (int)32) && PasswordCommonValidUtils.validCommonCharacterPassword((String)value, (int)2, (boolean)false);
    }

    public static boolean verifyStoragePassword(String value) {
        return PasswordCommonValidUtils.validLengthPassword((String)value, (int)8, (int)16) && PasswordCommonValidUtils.validCommonCharacterPassword((String)value, (int)2, (boolean)true) && PasswordCommonValidUtils.validPasswordWithoutConsecutiveChars((String)value);
    }

    public static boolean verifyServerPassword(String value) {
        return PasswordCommonValidUtils.validLengthPassword((String)value, (int)8, (int)20) && PasswordCommonValidUtils.validCommonCharacterPassword((String)value, (int)2) && PasswordCommonValidUtils.validWhitelistSpecialChars((String)value);
    }

    private PasswordVerifyUtil() {
    }

    static {
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(0, 4, 2), PasswordVerifyUtil::verifyByDefault);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(0, 5, 2), PasswordVerifyUtil::verifyByDefault);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(0, 6, 2), PasswordVerifyUtil::verifyByDefault);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(0, 17, 2), PasswordVerifyUtil::verifyByDefault);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(0, 26, 2), PasswordVerifyUtil::verifyAdminPassword);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(0, 27, 2), PasswordVerifyUtil::verifyAdminPassword);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(3, 1, 14), PasswordVerifyUtil::verifyServerPassword);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(3, 1, 15), PasswordVerifyUtil::verifyServerPassword);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(4, 1, 4), PasswordVerifyUtil::verifyStoragePassword);
        PASSWORD_VERIFY_FUNC.put(PasswordVerifyUtil.buildLocation(4, 1, 7), PasswordVerifyUtil::verifyStoragePassword);
    }
}

