/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallbackPackageSnMappingUtils {
    private static final Logger log = LoggerFactory.getLogger(CallbackPackageSnMappingUtils.class);
    private static final int SLEEP_TIME = 100;
    private static final int RE_CREATE_DIR_TIMES = 5;
    private static final String UPLOAD_PATH = "upload";
    private static final String MAPPING_FILE_NAME_PREFIX = "packageSnMapping_";
    private static final String MAPPING_FILE_NAME_SUFFIX = ".data";

    public static boolean recordToolPackageSnMapping(String packageType, String deviceSns, String packageName) {
        if (StringUtils.isEmpty((CharSequence)deviceSns)) {
            log.error("the deviceSns is empty!");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)packageType)) {
            log.error("the packageType is empty!");
            return false;
        }
        return CallbackPackageSnMappingUtils.doRecord2PersistFile(packageType, deviceSns, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean doRecord2PersistFile(String fileType, String deviceSNs, String packageName) {
        Optional<String> smartKitUploadDir = CallbackPackageSnMappingUtils.getSmartKitUploadDir();
        if (!smartKitUploadDir.isPresent()) {
            log.error("get smartkit upload dir failed.");
            return false;
        }
        FileChannel channel = null;
        FileLock lock = null;
        RandomAccessFile raf = null;
        try {
            File destinationFile = new File(smartKitUploadDir.get(), MAPPING_FILE_NAME_PREFIX + System.currentTimeMillis() + MAPPING_FILE_NAME_SUFFIX);
            if (!destinationFile.exists() && !destinationFile.createNewFile()) {
                log.error("destination File create failed.");
                boolean bl = false;
                return bl;
            }
            JSONObject jsObj = new JSONObject();
            jsObj.put("fileType", (Object)fileType);
            jsObj.put("devicesInfo", (Object)new JSONArray(Collections.singletonList(deviceSNs)));
            raf = new RandomAccessFile(destinationFile, "rw");
            raf.seek(raf.length());
            channel = raf.getChannel();
            lock = channel.lock();
            String toWrite = packageName + "=" + jsObj + "\r\n";
            ByteBuffer sendBuffer = ByteBuffer.wrap(toWrite.getBytes(Charset.defaultCharset()));
            channel.write(sendBuffer);
            boolean bl = true;
            CallbackPackageSnMappingUtils.dealResourceReleasing(channel, lock, raf);
            return bl;
        }
        catch (FileNotFoundException e) {
            log.error("file {} not found!", (Object)MAPPING_FILE_NAME_SUFFIX);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error("IOException on doRecord2PersistFile!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            CallbackPackageSnMappingUtils.dealResourceReleasing(channel, lock, raf);
        }
    }

    private static void dealResourceReleasing(FileChannel channel, FileLock lock, RandomAccessFile raf) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e) {
                log.error("IOException on release lock!" + e);
            }
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{raf, channel});
    }

    public static Optional<String> getSmartKitUploadDir() {
        String uploadFileDir = FilePathValidatorUtils.getSafePath((String)FilePathValidatorUtils.joinChildPath((String[])new String[]{System.getProperty("user.dir"), "..", "..", UPLOAD_PATH})).orElse("");
        if (CallbackPackageSnMappingUtils.checkAndMakeFile(new File(uploadFileDir), true)) {
            return Optional.of(uploadFileDir);
        }
        return Optional.empty();
    }

    public static boolean checkAndMakeFile(File file, boolean isFolder) {
        for (int tryTimes = 5; tryTimes > 0 && !file.exists(); --tryTimes) {
            try {
                if (isFolder && file.mkdirs()) {
                    return true;
                }
                if (!isFolder && !file.createNewFile()) {
                    log.error("make file error! times " + tryTimes);
                }
            }
            catch (IOException e) {
                log.error("make file error!", (Throwable)e);
                log.error("make file error! times {}.", (Object)tryTimes);
            }
            ThreadUtils.threadSafeSleep((int)100, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return file.exists();
    }

    private CallbackPackageSnMappingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

