/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.VmTypeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployDayuGeneralParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployDayuVmPlaneParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuBaseParams;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuParamsVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuPassword;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DeployDayuVmsParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DiskCmd;
import com.huawei.yinglong.virtualization.deploy.entity.vo.FcLoginInfo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.FcScenario;
import com.huawei.yinglong.virtualization.deploy.entity.vo.PacificParams;
import com.huawei.yinglong.virtualization.deploy.entity.vo.TemplateInfo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.VmNicConfigCmd;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public final class DayuImportParamsToDeployFieldUtils {
    public static DayuParamsVo buildDayuParams(DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity, List<DeployDayuVmPlaneParamsEntity> deployDayuVmPlaneParamsEntities) {
        return DayuParamsVo.builder().dayuBaseParams(DayuImportParamsToDeployFieldUtils.buildDayuBaseParams(deployDayuGeneralParamsEntity)).dayuPassword(DayuImportParamsToDeployFieldUtils.buildeDayuPassword(deployDayuGeneralParamsEntity)).dayuTemplateInfo(DayuImportParamsToDeployFieldUtils.buildDayuTemplateInfo(deployDayuGeneralParamsEntity)).fcLoginInfo(DayuImportParamsToDeployFieldUtils.buildFcLoginInfo(deployDayuGeneralParamsEntity)).pacificParams(DayuImportParamsToDeployFieldUtils.buildPacificParams(deployDayuGeneralParamsEntity)).deployDayuVmsParamsEntities(DayuImportParamsToDeployFieldUtils.buildDeployDayuVmsParamsEntities(deployDayuGeneralParamsEntity, deployDayuVmPlaneParamsEntities)).build();
    }

    private static PacificParams buildPacificParams(DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity) {
        PacificParams pacificParams = PacificParams.builder().build();
        BeanUtils.copyProperties((Object)deployDayuGeneralParamsEntity, (Object)pacificParams);
        return pacificParams;
    }

    private static DayuPassword buildeDayuPassword(DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity) {
        DayuPassword dayuPassword = DayuPassword.builder().build();
        BeanUtils.copyProperties((Object)deployDayuGeneralParamsEntity, (Object)dayuPassword);
        return dayuPassword;
    }

    private static List<DeployDayuVmsParamsEntity> buildDeployDayuVmsParamsEntities(DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity, List<DeployDayuVmPlaneParamsEntity> deployDayuVmPlaneParamsEntities) {
        return deployDayuVmPlaneParamsEntities.stream().map(deployDayuVmPlaneParamsEntity -> DayuImportParamsToDeployFieldUtils.buildDayuVmParams(deployDayuGeneralParamsEntity, deployDayuVmPlaneParamsEntity)).collect(Collectors.toList());
    }

    private static DeployDayuVmsParamsEntity buildDayuVmParams(DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity, DeployDayuVmPlaneParamsEntity deployDayuVmPlaneParamsEntity) {
        return DeployDayuVmsParamsEntity.builder().dataStoreName(deployDayuVmPlaneParamsEntity.getDataStoreName()).vmTypeEnum(VmTypeEnum.of((String)deployDayuVmPlaneParamsEntity.getVmType())).hostName(deployDayuVmPlaneParamsEntity.getVmName()).cnaName(deployDayuVmPlaneParamsEntity.getCnaName()).cpuCores(deployDayuVmPlaneParamsEntity.getCpu()).memorySizeGb(deployDayuVmPlaneParamsEntity.getMemory()).nicConfigs(DayuImportParamsToDeployFieldUtils.buildNicConfigs(deployDayuVmPlaneParamsEntity, deployDayuGeneralParamsEntity)).diskCmds(DayuImportParamsToDeployFieldUtils.buildDiskCmds(deployDayuVmPlaneParamsEntity)).ndpComponentList(deployDayuVmPlaneParamsEntity.getNdpComponentList()).build();
    }

    private static List<DiskCmd> buildDiskCmds(DeployDayuVmPlaneParamsEntity deployDayuVmPlaneParamsEntity) {
        ArrayList<DiskCmd> diskCmds = new ArrayList<DiskCmd>();
        diskCmds.add(DiskCmd.builder().name("serviceDisk").dateStoreName(deployDayuVmPlaneParamsEntity.getDataStoreName()).quantityGB(deployDayuVmPlaneParamsEntity.getServiceDisk()).build());
        if (deployDayuVmPlaneParamsEntity.getDataDisk() > 0) {
            diskCmds.add(DiskCmd.builder().name("dataDisk").dateStoreName(deployDayuVmPlaneParamsEntity.getDataStoreName()).quantityGB(deployDayuVmPlaneParamsEntity.getDataDisk()).build());
        }
        return diskCmds;
    }

    private static List<VmNicConfigCmd> buildNicConfigs(DeployDayuVmPlaneParamsEntity deployDayuVmPlaneParamsEntity, DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity) {
        ArrayList<VmNicConfigCmd> vmNicConfigCmds = new ArrayList<VmNicConfigCmd>();
        VmNicConfigCmd op = VmNicConfigCmd.builder().ip(deployDayuVmPlaneParamsEntity.getOpIp()).netmask(deployDayuVmPlaneParamsEntity.getOpMask()).portGroupName(deployDayuVmPlaneParamsEntity.getOpPort()).build();
        vmNicConfigCmds.add(op);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{deployDayuVmPlaneParamsEntity.getMpIp()})) {
            VmNicConfigCmd mp = VmNicConfigCmd.builder().ip(deployDayuVmPlaneParamsEntity.getMpIp()).gateway(deployDayuGeneralParamsEntity.getFloatingNetwork()).netmask(deployDayuGeneralParamsEntity.getFloatingMask()).portGroupName("managePortgroup").build();
            vmNicConfigCmds.add(mp);
        }
        vmNicConfigCmds.addAll(IntStream.range(vmNicConfigCmds.size(), 6).mapToObj(index -> VmNicConfigCmd.builder().portGroupName("managePortgroup").build()).collect(Collectors.toList()));
        return vmNicConfigCmds;
    }

    static FcLoginInfo buildFcLoginInfo(DeployDayuGeneralParamsEntity entity) {
        return FcLoginInfo.builder().scenario(FcScenario.SEPARATE).url(entity.getFcIp()).user(entity.getFcUser()).password(entity.getFcPwd()).build();
    }

    private static TemplateInfo buildDayuTemplateInfo(DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity) {
        return TemplateInfo.builder().filepath(deployDayuGeneralParamsEntity.getDayuTemplateFilePath()).cnaName(deployDayuGeneralParamsEntity.getDayuTemplateCnaName()).datastoreName(deployDayuGeneralParamsEntity.getDayuTemplateDatastoreName()).templateName("dayuTemplate").build();
    }

    private static DayuBaseParams buildDayuBaseParams(DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity) {
        DayuBaseParams dayuBaseParams = DayuBaseParams.builder().build();
        BeanUtils.copyProperties((Object)deployDayuGeneralParamsEntity, (Object)dayuBaseParams);
        return dayuBaseParams;
    }

    private DayuImportParamsToDeployFieldUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

