/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.virtualization.deploy.entity.NetworkPlaneType;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NetworkPlaneInfo;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class DeployA3000Utils {
    @Nullable
    public static A3000DeployProcessConfig getProcessConfig(String executionId, BpmContextService bpmContextService) {
        return (A3000DeployProcessConfig)bpmContextService.getContext(executionId, A3000DeployProcessConfig.class);
    }

    public static Optional<NetworkPlaneInfo> getNetworkPlane(A3000DeployProcessConfig processConfig, NetworkPlaneType planeType) {
        return CollectionUtils.emptyIfNull(processConfig.getNetworkInfo()).stream().filter(networkPlaneInfo -> NetworkPlaneType.of(networkPlaneInfo.getNetworkPlaneName()) == planeType).findFirst();
    }

    public static String transferAlgorithm(String algorithm) {
        return StringUtils.defaultString((String)algorithm).replace("-", "_");
    }

    private DeployA3000Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

