/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.DeployDcsQueryActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.TaskStateEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployFcResultUtils {
    private static final Logger log = LoggerFactory.getLogger(DeployFcResultUtils.class);
    private static final String KEY_TASK_PARAM = "taskParam";
    private static final List<TaskStateEnum> TASK_STATE_UPDATE_LIST = Arrays.asList(TaskStateEnum.END, TaskStateEnum.ERROR, TaskStateEnum.RUNNING, TaskStateEnum.PAUSE);

    private static Optional<FcInstallParamsVo> getFcInstallParam(BpmContextService bpmContextService, String executionId) {
        String taskId = DeployFcResultUtils.getCurrentTaskId(bpmContextService, executionId);
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            log.error("get fc install param, taskId is empty.");
            return Optional.empty();
        }
        return DeployFcResultUtils.getFcInstallParamsVoFromProcessConfig(taskId, (VirtualizationDeployProcessConfig)bpmContextService.getContext(executionId, VirtualizationDeployProcessConfig.class));
    }

    @NotNull
    public static Optional<FcInstallParamsVo> getFcInstallParamsVoFromProcessConfig(String taskId, VirtualizationDeployProcessConfig processConfig) {
        if (processConfig == null || processConfig.getDeployFc() == null) {
            log.error("get fc install param, config or deploy fc is null, taskId={}.", (Object)taskId);
            return Optional.empty();
        }
        return processConfig.getDeployFc().stream().filter(paramsVo -> Objects.nonNull(paramsVo.getTask())).filter(paramsVo -> Objects.equals(taskId, paramsVo.getTask().getTaskId())).peek(paramsVo -> paramsVo.getTask().setInstallMode(processConfig.getInstallMode())).peek(paramsVo -> paramsVo.getTask().setAutoCreateVM(Boolean.valueOf(DeployFcResultUtils.isAutoCreateVm(processConfig)))).peek(paramsVo -> DeployFcResultUtils.updateFcVrmSizeScene(processConfig, paramsVo)).findFirst();
    }

    private static boolean isAutoCreateVm(VirtualizationDeployProcessConfig processConfig) {
        return Optional.ofNullable(processConfig.getDmeData()).map(maps -> (String)maps.get("vm_auto_create")).map(Boolean::new).orElse(false);
    }

    private static String getCurrentTaskId(BpmContextService bpmContextService, String executionId) {
        FcInstallParamsVo fcInstallParamsVo = (FcInstallParamsVo)bpmContextService.getContext(executionId, FcInstallParamsVo.class, KEY_TASK_PARAM, null);
        if (fcInstallParamsVo == null || fcInstallParamsVo.getTask() == null) {
            log.error("current install param task is null.");
            return "";
        }
        return fcInstallParamsVo.getTask().getTaskId();
    }

    public static ExternalTaskHandler createRetryDeployFcTaskHandler(BpmContextService bpmContextService, String module, boolean isNotifyFinish, Function<FcInstallParamsVo, Response<Boolean>> updateParamsHandler, Function<String, Response<String>> retryHandler) {
        return (externalTask, externalTaskService) -> {
            Optional<FcInstallParamsVo> opTaskParam = DeployFcResultUtils.getFcInstallParam(bpmContextService, externalTask.getExecutionId());
            if (!opTaskParam.isPresent()) {
                log.error("not find fc {} params, executionId={}.", (Object)module, (Object)externalTask.getExecutionId());
                bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            FcInstallParamsVo fcInstallParamsVo = opTaskParam.get();
            if (fcInstallParamsVo.getTask() == null || StringUtils.isEmpty((CharSequence)fcInstallParamsVo.getTask().getTaskId())) {
                log.error("not find fc {} params, executionId={}.", (Object)module, (Object)externalTask.getExecutionId());
                bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            String taskId = fcInstallParamsVo.getTask().getTaskId();
            if (updateParamsHandler != null) {
                log.info("retry to update fc install param, taskId={}.", (Object)taskId);
                Response updateResponse = (Response)updateParamsHandler.apply(fcInstallParamsVo);
                if (!ResponseUtil.isSuccess((Response)updateResponse) || !((Boolean)updateResponse.getData()).booleanValue()) {
                    log.error("retry task({}) update params {} failed.", (Object)taskId, (Object)module);
                    bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                    return;
                }
            }
            log.info("retry to deploy task, taskId={}.", (Object)taskId);
            Response response = (Response)retryHandler.apply(taskId);
            if (!ResponseUtil.isSuccess((Response)response)) {
                log.error("retry task {} {} failed.", (Object)taskId, (Object)module);
                bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            if (isNotifyFinish) {
                log.info("retry to notify activity has finished.");
                bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            }
        };
    }

    public static ExternalTaskHandler createStartDeployFcTaskHandler(BpmContextService bpmContextService, String module, Function<FcInstallParamsVo, Response<String>> starter) {
        return (externalTask, externalTaskService) -> {
            Optional<FcInstallParamsVo> opTaskParam = DeployFcResultUtils.getFcInstallParam(bpmContextService, externalTask.getExecutionId());
            if (!opTaskParam.isPresent()) {
                log.error("not find {} param.", (Object)module);
                bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            FcInstallParamsVo paramsVo = opTaskParam.get();
            log.info("prepare to start deploy {} task, name:{}.", (Object)module, (Object)paramsVo.getTask().getTaskName());
            boolean isSuccessfully = DeployFcResultUtils.handleDeployStartResponse(bpmContextService, externalTask, externalTaskService, paramsVo, starter);
            log.info("started {}, id={}, name={}, result={}.", new Object[]{module, paramsVo.getTask().getTaskId(), paramsVo.getTask().getTaskName(), isSuccessfully});
        };
    }

    private static boolean handleDeployStartResponse(BpmContextService bpmContextService, ExternalTask externalTask, ExternalTaskService externalTaskService, FcInstallParamsVo paramsVo, Function<FcInstallParamsVo, Response<String>> executor) {
        DcsDeployStartActivityResult startActivityResult = new DcsDeployStartActivityResult();
        Response<String> response = executor.apply(paramsVo);
        if (!ResponseUtil.isSuccess(response)) {
            startActivityResult.setSuccess(false);
            startActivityResult.setMessage(response.getResult().getDescription());
            startActivityResult.setSuggestion(response.getResult().getSuggestion());
        } else {
            startActivityResult.setSuccess(true);
            startActivityResult.setTaskId((String)response.getData());
        }
        bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startActivityResult);
        bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        return startActivityResult.isSuccess();
    }

    public static ExternalTaskHandler createQueryDeployDmeDetailTaskHandler(BpmContextService bpmContextService, String module, Supplier<Response<DeployTaskInfoVo>> supplier) {
        return (externalTask, externalTaskService) -> {
            Response taskInfoVoResponse = (Response)supplier.get();
            if (!ResponseUtil.isSuccess((Response)taskInfoVoResponse) || taskInfoVoResponse.getData() == null) {
                log.error("query {} deploy details failed.", (Object)module);
                return;
            }
            DeployTaskInfoVo taskInfoVo = (DeployTaskInfoVo)taskInfoVoResponse.getData();
            if (TASK_STATE_UPDATE_LIST.stream().anyMatch(state -> state.isSameState(taskInfoVo.getState()))) {
                bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)new DeployDcsQueryActivityResult(taskInfoVo.getChildren()));
            }
            if (TaskStateEnum.END.isSameState(taskInfoVo.getState())) {
                log.info("query {} deploy detail, it has end.", (Object)module);
                bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            } else if (TaskStateEnum.ERROR.isSameState(taskInfoVo.getState())) {
                log.error("query {} deploy detail, it has error.", (Object)module);
                bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            } else if (TaskStateEnum.PAUSE.isSameState(taskInfoVo.getState())) {
                log.warn("query {} deploy detail, it has pause.", (Object)module);
                bpmContextService.notifyInvocationPaused(externalTask, externalTaskService);
            } else {
                log.warn("query {} deploy detail, result state = {}.", (Object)module, (Object)taskInfoVo.getState());
            }
        };
    }

    public static ExternalTaskHandler createQueryDeployFcDetailTaskHandler(BpmContextService bpmContextService, String module, Function<String, Response<DeployTaskInfoVo>> querier) {
        return (externalTask, externalTaskService) -> {
            String taskId = DeployFcResultUtils.getCurrentTaskId(bpmContextService, externalTask.getExecutionId());
            if (StringUtils.isEmpty((CharSequence)taskId)) {
                log.error("not find fc {} params, executionId={}.", (Object)module, (Object)externalTask.getExecutionId());
                bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            Response response = (Response)querier.apply(taskId);
            if (!ResponseUtil.isSuccess((Response)response) || response.getData() == null) {
                log.error("query fc task progress failed, taskId={}.", (Object)taskId);
                return;
            }
            DeployTaskInfoVo taskInfoVo = (DeployTaskInfoVo)response.getData();
            if (DeployFcResultUtils.handleDeployFcDetailResult(bpmContextService, externalTask, externalTaskService, taskInfoVo)) {
                log.info("query fc deploy {} detail has finish. taskId={}.", (Object)module, (Object)taskId);
            }
        };
    }

    private static boolean handleDeployFcDetailResult(BpmContextService bpmContextService, ExternalTask externalTask, ExternalTaskService externalTaskService, DeployTaskInfoVo taskInfoVo) {
        bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)new DeployDcsQueryActivityResult(taskInfoVo.getChildren()));
        String status = taskInfoVo.getState();
        log.info("handle fc detail status={}, taskId={}.", (Object)status, (Object)taskInfoVo.getTaskId());
        if (TaskStateEnum.END.isSameState(status) || TaskStateEnum.SKIP.isSameState(status)) {
            bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return true;
        }
        if (TaskStateEnum.PAUSE.isSameState(status)) {
            bpmContextService.notifyInvocationPaused(externalTask, externalTaskService);
            return false;
        }
        if (TaskStateEnum.ERROR.isSameState(status)) {
            bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            return false;
        }
        return false;
    }

    public static void handleDeployDetailResult(BpmContextService bpmContextService, ExternalTask externalTask, ExternalTaskService externalTaskService, DeployTaskInfoVo taskInfoVo) {
        if (TASK_STATE_UPDATE_LIST.stream().anyMatch(state -> state.isSameState(taskInfoVo.getState()))) {
            bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)new DeployDcsQueryActivityResult(taskInfoVo.getChildren()));
        }
        if (TaskStateEnum.END.isSameState(taskInfoVo.getState())) {
            log.info("query {} deploy detail, it has end.", (Object)externalTask.getTopicName());
            bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        } else if (TaskStateEnum.SKIP.isSameState(taskInfoVo.getState())) {
            log.info("query {} deploy detail, it has skip.", (Object)externalTask.getTopicName());
            bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        } else if (TaskStateEnum.ERROR.isSameState(taskInfoVo.getState())) {
            log.error("query {} deploy detail, it has error.", (Object)externalTask.getTopicName());
            bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        } else if (TaskStateEnum.PAUSE.isSameState(taskInfoVo.getState())) {
            log.warn("query {} deploy detail, it has pause.", (Object)externalTask.getTopicName());
            bpmContextService.notifyInvocationPaused(externalTask, externalTaskService);
        } else {
            log.warn("query {}} deploy detail, result state = {}.", (Object)externalTask.getTopicName(), (Object)taskInfoVo.getState());
        }
    }

    private static boolean isDmeManageFusionCompute(VirtualizationDeployProcessConfig processConfig) {
        if (!CollectionUtils.emptyIfNull(processConfig.getInstallMode()).containsAll(Arrays.asList(InstallModeEnum.VRM.getInstallMode(), InstallModeEnum.DME.getInstallMode()))) {
            log.info("not install VRM and eDME, mode : {}.", processConfig.getInstallMode());
            return false;
        }
        if (Objects.equals(MapUtils.emptyIfNull(processConfig.getDmeData()).getOrDefault("DMEData_FC_basic_manage", "NO"), "NO")) {
            log.info("eDME  not need to manage FC.");
            return false;
        }
        return true;
    }

    public static void updateFcVrmSizeScene(VirtualizationDeployProcessConfig processConfig, FcInstallParamsVo fcInstallParamsVo) {
        if (!DeployFcResultUtils.isDmeManageFusionCompute(processConfig)) {
            return;
        }
        Optional.of(fcInstallParamsVo).map(FcInstallParamsVo::getVrm).map(VrmInstallParamsVo::getSize).ifPresent(size -> size.setScene("eDME"));
    }

    private DeployFcResultUtils() {
    }
}

