/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.virtualization.deploy.entity.excel.ExcelMergeCellArea;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public final class ExcelCommonUtils {
    public static Optional<ExcelMergeCellArea> getMergeCellPositionByCellValue(Sheet sheet, String mergeCellValue) {
        for (CellRangeAddress mergedRegion : sheet.getMergedRegions()) {
            Cell cell = sheet.getRow(mergedRegion.getFirstRow()).getCell(mergedRegion.getFirstColumn());
            if (!mergeCellValue.equals(cell.getStringCellValue())) continue;
            ExcelMergeCellArea mergeCellPosition = ExcelMergeCellArea.builder().firstRow(mergedRegion.getFirstRow()).firstCol(mergedRegion.getFirstColumn()).lastRow(mergedRegion.getLastRow()).lastCol(mergedRegion.getLastColumn()).build();
            return Optional.of(mergeCellPosition);
        }
        return Optional.empty();
    }

    private ExcelCommonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

