/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.google.common.collect.ImmutableList;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.excel.ExcelMergeCellArea;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployParamsData;
import com.huawei.yinglong.virtualization.deploy.utils.ExcelCommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExportParametersExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExportParametersExcelUtils.class);
    private static final int HOST_INFO_ROW = 1;
    private static final int HEADER_COL = 1;
    private static final int VALUE_COL = 2;
    private static final int MAX_VM_SIZE = 2;
    private static final int VM_PLANE_HEADER_ROW = 1;
    private static final int VM_PLANE_START_COL = 1;
    private static final List<String> HICLOUD_PARAM_TITLE = ImmutableList.of((Object)"deploy.params.template.common.virtualization.title", (Object)"deploy.params.template.hicloud.base.title", (Object)"deploy.params.template.hicloud.gde.manage.title", (Object)"deploy.params.template.hicloud.gde.data.title", (Object)"deploy.params.template.hicloud.gde.plane.title", (Object)"deploy.params.template.hicloud.service.title");
    private static final List<String> SFS_PARAM_TITLE = ImmutableList.of((Object)"deploy.params.template.common.virtualization.title", (Object)"deploy.params.template.sfs.base.title", (Object)"deploy.params.template.sfs.manage.plan.title", (Object)"deploy.params.template.sfs.manage.plan.password.title");
    private static final List<String> SDN_PARAM_TITLE = ImmutableList.of((Object)"deploy.params.template.sdn.base.title", (Object)"deploy.params.template.sdn.general.title", (Object)"deploy.params.template.sdn.password.title", (Object)"deploy.params.template.sdn.network.title");
    private static final List<String> CAMPUS_PARAM_TITLE = ImmutableList.of((Object)"deploy.params.template.common.virtualization.title", (Object)"deploy.params.template.campus.base.title", (Object)"deploy.params.template.campus.level.title", (Object)"deploy.params.template.campus.global.title");

    public static String exportDeployParams(String templatePath, String targetPath, DeployParamsData exportData) {
        if (!ExportParametersExcelUtils.copyTemplateToTargetPath(templatePath, targetPath)) {
            return ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.export.error.copy");
        }
        Path path = Paths.get(targetPath, new String[0]);
        try (XSSFWorkbook workbook = new XSSFWorkbook(Files.newInputStream(path, new OpenOption[0]));
             OutputStream fileOut = Files.newOutputStream(path, new OpenOption[0]);){
            XSSFSheet fusionComputeSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.sheet"));
            ExportParametersExcelUtils.exportFusionComputeParams(fusionComputeSheet, exportData);
            XSSFSheet hostSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.host.sheet"));
            ExportParametersExcelUtils.exportHostsParams(hostSheet, exportData);
            XSSFSheet dmeSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.sheet"));
            ExportParametersExcelUtils.exportDmeData(dmeSheet, exportData);
            XSSFSheet ultraVRSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ultravr.sheet"));
            ExportParametersExcelUtils.exportUltraVRData(ultraVRSheet, exportData);
            XSSFSheet eBackupBasicSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.sheet"));
            ExportParametersExcelUtils.exportEbackupBasicData(eBackupBasicSheet, exportData);
            XSSFSheet eBackupPlaneSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.parmas.template.plane.sheet"));
            ExportParametersExcelUtils.exportEbackupPlaneData(eBackupPlaneSheet, exportData);
            XSSFSheet dayuSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.sheet"));
            ExportParametersExcelUtils.exportDayuData(dayuSheet, exportData);
            XSSFSheet dayuPlaneSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.plane.sheet"));
            ExportParametersExcelUtils.exportDayuPlaneData(dayuPlaneSheet, exportData);
            XSSFSheet dayuComponentsSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.component.sheet"));
            ExportParametersExcelUtils.exportDayuComponentData(dayuComponentsSheet, exportData);
            ExportParametersExcelUtils.exportHiCloudParamsInfo(exportData, workbook);
            ExportParametersExcelUtils.exportHiCloudMultiRows(exportData, workbook);
            ExportParametersExcelUtils.exportSfsParamsInfo(exportData, workbook);
            ExportParametersExcelUtils.exportSfsMultiRows(exportData, workbook);
            ExportParametersExcelUtils.exportSdnParamsInfo(exportData, workbook);
            ExportParametersExcelUtils.exportSdnMultiRows(exportData, workbook);
            ExportParametersExcelUtils.exportCampusParamsInfo(exportData, workbook);
            ExportParametersExcelUtils.exportCampusMultiRows(exportData, workbook);
            workbook.write(fileOut);
        }
        catch (IOException exception) {
            log.error("export parameters error", (Throwable)exception);
            return ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.export.error.write");
        }
        return "";
    }

    private static void exportCampusMultiRows(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet campusVmSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.campus.vm.sheet"));
        ExportParametersExcelUtils.exportMultiRows(campusVmSheet, 1, 0, 0, exportData.getCampusVmExportInfos());
    }

    private static void exportCampusParamsInfo(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet campusSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.campus.sheet"));
        CAMPUS_PARAM_TITLE.forEach(key -> ExportParametersExcelUtils.exportSfsParam(campusSheet, key, exportData.getCampusExportInfos()));
    }

    private static void exportHiCloudMultiRows(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet hiCloudVmSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.vm.sheet"));
        ExportParametersExcelUtils.exportMultiRows(hiCloudVmSheet, 1, 0, 0, exportData.getHiCloudVmExportInfos());
    }

    private static void exportHiCloudParamsInfo(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet hiCloudSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.sheet"));
        HICLOUD_PARAM_TITLE.forEach(key -> ExportParametersExcelUtils.exportHiCloudParam(hiCloudSheet, key, exportData.getHiCloudExportInfos()));
    }

    private static void exportSdnMultiRows(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet sdnVmSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sdn.vm.sheet"));
        ExportParametersExcelUtils.exportMultiRows(sdnVmSheet, 1, 0, 0, exportData.getSdnVmExportInfos());
    }

    static void exportSdnParamsInfo(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet sdnSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sdn.sheet"));
        SDN_PARAM_TITLE.forEach(key -> ExportParametersExcelUtils.exportSfsParam(sdnSheet, key, exportData.getSdnExportInfos()));
    }

    static void exportSfsParamsInfo(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet sfsSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sfs.sheet"));
        SFS_PARAM_TITLE.forEach(key -> ExportParametersExcelUtils.exportSfsParam(sfsSheet, key, exportData.getSfsExportInfos()));
    }

    private static void exportSfsMultiRows(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet sfsVmSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sfs.vm.sheet"));
        ExportParametersExcelUtils.exportMultiRows(sfsVmSheet, 1, 0, 0, exportData.getSfsVmExportInfos());
    }

    private static void exportSfsParam(XSSFSheet sfsSheet, String cellKey, Map<String, String> sfsExportInfos) {
        Optional<ExcelMergeCellArea> mergeCellArea = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg(cellKey));
        if (!mergeCellArea.isPresent()) {
            return;
        }
        ExcelMergeCellArea cellArea = mergeCellArea.get();
        ExportParametersExcelUtils.exportSingleCol(sfsSheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(sfsExportInfos));
    }

    private static void exportHiCloudParam(XSSFSheet hiCloudSheet, String cellKey, Map<String, String> hiCloudInfos) {
        Optional<ExcelMergeCellArea> mergeCell = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg(cellKey));
        if (!mergeCell.isPresent()) {
            return;
        }
        ExcelMergeCellArea cellArea = mergeCell.get();
        ExportParametersExcelUtils.exportSingleCol(hiCloudSheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(hiCloudInfos));
    }

    static void exportDayuParamsInfo(DeployParamsData exportData, XSSFWorkbook workbook) {
        XSSFSheet dayuSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.sheet"));
        ExportParametersExcelUtils.exportDayuData(dayuSheet, exportData);
    }

    private static void exportDayuComponentData(XSSFSheet dayuComponentsSheet, DeployParamsData exportData) {
        int i = 2;
        while (Objects.nonNull(dayuComponentsSheet.getRow(i))) {
            XSSFRow row = dayuComponentsSheet.getRow(i);
            String header = row.getCell(0).getStringCellValue();
            String components = exportData.getDayuExportInfos().getOrDefault(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.dayu.component.list"), "");
            String value = "";
            if (components.contains(header)) {
                value = ResourceConfigLoader.getStringFromExportMsg("deploy.params.export.true");
            }
            XSSFCell cell = row.createCell(1);
            cell.setCellValue(value);
            ++i;
        }
    }

    private static void exportDayuPlaneData(XSSFSheet eBackupPlaneSheet, DeployParamsData exportData) {
        ExportParametersExcelUtils.exportMultiRows(eBackupPlaneSheet, 1, 0, 0, exportData.getDayuPlaneExportInfos());
    }

    private static void exportDayuData(XSSFSheet dayuSheet, DeployParamsData exportData) {
        ExportParametersExcelUtils.buildDayuBaseSheet(dayuSheet, "deploy.params.template.common.virtualization.title", exportData.getDayuExportInfos());
        ExportParametersExcelUtils.buildDayuBaseSheet(dayuSheet, "deploy.params.template.dayu.common.info.title", exportData.getDayuExportInfos());
        ExportParametersExcelUtils.buildDayuBaseSheet(dayuSheet, "deploy.params.template.dayu.service.info.title", exportData.getDayuExportInfos());
        ExportParametersExcelUtils.buildDayuBaseSheet(dayuSheet, "deploy.params.template.dayu.password.title", exportData.getDayuExportInfos());
        ExportParametersExcelUtils.buildDayuBaseSheet(dayuSheet, "deploy.params.template.pacific.title", exportData.getDayuExportInfos());
    }

    private static void buildDayuBaseSheet(XSSFSheet dayuSheet, String key, Map<String, String> exportData) {
        Optional<ExcelMergeCellArea> dayuCommonPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)dayuSheet, ResourceConfigLoader.getStringFromExportMsg(key));
        if (!dayuCommonPosition.isPresent()) {
            log.error("can not find %s", (Object)ResourceConfigLoader.getStringFromExportMsg(key));
            return;
        }
        ExcelMergeCellArea cellArea = dayuCommonPosition.get();
        ExportParametersExcelUtils.exportSingleCol(dayuSheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(exportData));
    }

    private static boolean copyTemplateToTargetPath(String templatePath, String targetPath) {
        try {
            FileUtils.copyFile((File)new File(templatePath), (File)new File(targetPath));
            return true;
        }
        catch (IOException exception) {
            log.error("copy template to target {}", (Object)targetPath);
            return false;
        }
    }

    private static void exportFusionComputeParams(XSSFSheet fusionComputeSheet, DeployParamsData exportData) {
        ExportParametersExcelUtils.exportFcBaseParams(fusionComputeSheet, exportData.getFcBaseInfos());
        ExportParametersExcelUtils.exportFcVrmParams(fusionComputeSheet, exportData.getVrmExportInfos());
        ExportParametersExcelUtils.exportFcCommonParams(fusionComputeSheet, exportData.getFcCommonInfos());
        ExportParametersExcelUtils.exportFcNtpTimeParams(fusionComputeSheet, exportData.getNtpTimeInfos());
        ExportParametersExcelUtils.exportFcBackupParams(fusionComputeSheet, exportData.getBackupInfos());
    }

    private static void exportHostsParams(XSSFSheet hostSheet, DeployParamsData exportData) {
        ExportParametersExcelUtils.exportFcHostParams(hostSheet, 1, exportData.getFcHostExportInfos());
    }

    private static void exportFcBaseParams(XSSFSheet fusionComputeSheet, Map<String, String> fcExportInfos) {
        Optional<ExcelMergeCellArea> fcBasePosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)fusionComputeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.base.title"));
        if (!fcBasePosition.isPresent()) {
            log.error("can not find fc base info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(fusionComputeSheet, fcBasePosition.get().getFirstRow(), fcBasePosition.get().getLastRow(), MapUtils.emptyIfNull(fcExportInfos));
    }

    private static void exportFcCommonParams(XSSFSheet fusionComputeSheet, Map<String, String> fcExportInfos) {
        Optional<ExcelMergeCellArea> fcCommonPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)fusionComputeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.common.title"));
        if (!fcCommonPosition.isPresent()) {
            log.error("can not find fc common info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(fusionComputeSheet, fcCommonPosition.get().getFirstRow(), fcCommonPosition.get().getLastRow(), MapUtils.emptyIfNull(fcExportInfos));
    }

    private static void exportFcNtpTimeParams(XSSFSheet sheet, Map<String, String> fcExportInfos) {
        Optional<ExcelMergeCellArea> fcNtpTimePosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.ntp.time.title"));
        if (!fcNtpTimePosition.isPresent()) {
            log.error("can not find fc ntp time info area");
            return;
        }
        ExcelMergeCellArea cellArea = fcNtpTimePosition.get();
        ExportParametersExcelUtils.exportSingleCol(sheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(fcExportInfos));
    }

    private static void exportFcBackupParams(XSSFSheet sheet, Map<String, String> fcExportInfos) {
        Optional<ExcelMergeCellArea> backupPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.backup.title"));
        if (!backupPosition.isPresent()) {
            log.error("can not find fc backup info area");
            return;
        }
        ExcelMergeCellArea cellArea = backupPosition.get();
        ExportParametersExcelUtils.exportSingleCol(sheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(fcExportInfos));
    }

    private static void exportFcHostParams(XSSFSheet fusionComputeSheet, int headerRow, List<Map<String, String>> fcExportInfos) {
        ExportParametersExcelUtils.exportMultiRows(fusionComputeSheet, headerRow, 0, 0, fcExportInfos);
    }

    private static void exportFcVrmParams(XSSFSheet fusionComputeSheet, Map<String, String> vrmExportInfos) {
        Optional<ExcelMergeCellArea> fcVrmPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)fusionComputeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.vrm.title"));
        if (!fcVrmPosition.isPresent()) {
            log.error("can not find fc vrm info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(fusionComputeSheet, fcVrmPosition.get().getFirstRow(), fcVrmPosition.get().getLastRow(), MapUtils.emptyIfNull(vrmExportInfos));
    }

    private static void exportMultiRows(XSSFSheet exportSheet, int headerRow, int deltaRow, int startCol, List<Map<String, String>> exportInfos) {
        XSSFRow tableHeaderRow = exportSheet.getRow(headerRow);
        for (int row = 0; row < exportInfos.size(); ++row) {
            Map<String, String> singleExportInfo = exportInfos.get(row);
            int dataRow = deltaRow + row + 1 + headerRow;
            XSSFRow exportWriteRow = Objects.isNull(exportSheet.getRow(dataRow)) ? exportSheet.createRow(dataRow) : exportSheet.getRow(dataRow);
            for (int col = startCol; col < tableHeaderRow.getLastCellNum(); ++col) {
                String header = tableHeaderRow.getCell(col).getStringCellValue();
                String cellValue = singleExportInfo.getOrDefault(header, "");
                XSSFCell dataCell = Objects.isNull(exportWriteRow.getCell(col)) ? exportWriteRow.createCell(col) : exportWriteRow.getCell(col);
                dataCell.setCellValue(cellValue);
            }
        }
    }

    private static void exportSingleCol(XSSFSheet exportSheet, int startRow, int endRow, Map<String, String> exportInfos) {
        for (int i = startRow; i <= endRow; ++i) {
            XSSFRow row = exportSheet.getRow(i);
            String header = row.getCell(1).getStringCellValue();
            String value = exportInfos.getOrDefault(header, "");
            XSSFCell cell = row.createCell(2);
            cell.setCellValue(value);
        }
    }

    private static void exportDmeData(XSSFSheet dmeSheet, DeployParamsData exportData) {
        ExportParametersExcelUtils.exportDmeVirtualizationData(dmeSheet, exportData);
        ExportParametersExcelUtils.exportDmeNormalData(dmeSheet, exportData);
        ExportParametersExcelUtils.exportDmeTenantData(dmeSheet, exportData);
        ExportParametersExcelUtils.exportDmeManageFcData(dmeSheet, exportData);
        ExportParametersExcelUtils.exportDmeCcsData(dmeSheet, exportData);
        ExportParametersExcelUtils.exportDmeDcsasData(dmeSheet, exportData);
    }

    private static void exportDmeDcsasData(XSSFSheet dmeSheet, DeployParamsData exportData) {
        Optional<ExcelMergeCellArea> cssPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.dcsas.title"));
        if (!cssPosition.isPresent()) {
            log.error("can not find dme dcsas info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(dmeSheet, cssPosition.get().getFirstRow(), cssPosition.get().getLastRow(), MapUtils.emptyIfNull(exportData.getDmeExportInfos()));
    }

    private static void exportDmeCcsData(XSSFSheet dmeSheet, DeployParamsData exportData) {
        Optional<ExcelMergeCellArea> cssPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.container.cluster.service.title"));
        if (!cssPosition.isPresent()) {
            log.error("can not find dme ccs info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(dmeSheet, cssPosition.get().getFirstRow(), cssPosition.get().getLastRow(), MapUtils.emptyIfNull(exportData.getDmeExportInfos()));
    }

    private static void exportDmeManageFcData(XSSFSheet dmeSheet, DeployParamsData exportData) {
        Optional<ExcelMergeCellArea> manageFcPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.fusion.compute.title"));
        if (!manageFcPosition.isPresent()) {
            log.error("can not find dme tenant info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(dmeSheet, manageFcPosition.get().getFirstRow(), manageFcPosition.get().getLastRow(), MapUtils.emptyIfNull(exportData.getDmeExportInfos()));
    }

    private static void exportDmeTenantData(XSSFSheet dmeSheet, DeployParamsData exportData) {
        Optional<ExcelMergeCellArea> tenantPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.tenant.title"));
        if (!tenantPosition.isPresent()) {
            log.error("can not find dme tenant info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(dmeSheet, tenantPosition.get().getFirstRow(), tenantPosition.get().getLastRow(), MapUtils.emptyIfNull(exportData.getDmeExportInfos()));
    }

    private static void exportDmeVirtualizationData(XSSFSheet dmeSheet, DeployParamsData exportData) {
        Optional<ExcelMergeCellArea> dmePosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.common.virtualization.title"));
        if (!dmePosition.isPresent()) {
            log.error("can not find dme info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(dmeSheet, dmePosition.get().getFirstRow(), dmePosition.get().getLastRow(), MapUtils.emptyIfNull(exportData.getDmeExportInfos()));
    }

    private static void exportDmeNormalData(XSSFSheet dmeSheet, DeployParamsData exportData) {
        Optional<ExcelMergeCellArea> dmePosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.title"));
        if (!dmePosition.isPresent()) {
            log.error("can not find dme info area");
            return;
        }
        ExportParametersExcelUtils.exportSingleCol(dmeSheet, dmePosition.get().getFirstRow(), dmePosition.get().getLastRow(), MapUtils.emptyIfNull(exportData.getDmeExportInfos()));
    }

    private static void exportUltraVRData(XSSFSheet ultraVRSheet, DeployParamsData deployParamsData) {
        Optional<ExcelMergeCellArea> ultraVRCommonPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)ultraVRSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ultravr.template.title"));
        if (!ultraVRCommonPosition.isPresent()) {
            log.error("can not find ultra vr common info");
            return;
        }
        ExcelMergeCellArea cellArea = ultraVRCommonPosition.get();
        ExportParametersExcelUtils.exportSingleCol(ultraVRSheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(deployParamsData.getUltraExportInfos()));
        Optional<ExcelMergeCellArea> ultraVRVmPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)ultraVRSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ultravr.vm.title"));
        if (!ultraVRVmPosition.isPresent()) {
            log.error("can not find ultra vr vm info");
            return;
        }
        cellArea = ultraVRVmPosition.get();
        ExportParametersExcelUtils.exportSingleCol(ultraVRSheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(deployParamsData.getUltraExportInfos()));
    }

    private static void exportEbackupBasicData(XSSFSheet eBackupSheet, DeployParamsData deployParamsData) {
        Optional<ExcelMergeCellArea> eBackupCommonPosition = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)eBackupSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.template.title"));
        if (!eBackupCommonPosition.isPresent()) {
            log.error("can not find eBackup common info");
            return;
        }
        ExcelMergeCellArea cellArea = eBackupCommonPosition.get();
        ExportParametersExcelUtils.exportSingleCol(eBackupSheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(deployParamsData.getEBackupExportInfos()));
        ExportParametersExcelUtils.exportEbackupSingleVmInfo(eBackupSheet, "deploy.params.template.ebackup.vm1.tile", Collections.emptyMap());
        ExportParametersExcelUtils.exportEbackupSingleVmInfo(eBackupSheet, "deploy.params.template.ebackup.vm2.tile", Collections.emptyMap());
        List<Map<String, String>> eBackupVmExportInfos = deployParamsData.getEBackupVmExportInfos();
        if (!eBackupVmExportInfos.isEmpty()) {
            ExportParametersExcelUtils.exportEbackupSingleVmInfo(eBackupSheet, "deploy.params.template.ebackup.vm1.tile", eBackupVmExportInfos.get(0));
        }
        if (eBackupVmExportInfos.size() >= 2) {
            ExportParametersExcelUtils.exportEbackupSingleVmInfo(eBackupSheet, "deploy.params.template.ebackup.vm2.tile", eBackupVmExportInfos.get(1));
        }
    }

    private static void exportEbackupSingleVmInfo(XSSFSheet eBackupSheet, String nameKey, Map<String, String> vmInfoMaps) {
        Optional<ExcelMergeCellArea> eBackupVmInfo2 = ExcelCommonUtils.getMergeCellPositionByCellValue((Sheet)eBackupSheet, ResourceConfigLoader.getStringFromExportMsg(nameKey));
        if (!eBackupVmInfo2.isPresent()) {
            log.error("can not find eBackup vm info {}.", (Object)nameKey);
            return;
        }
        ExcelMergeCellArea cellArea = eBackupVmInfo2.get();
        ExportParametersExcelUtils.exportSingleCol(eBackupSheet, cellArea.getFirstRow(), cellArea.getLastRow(), MapUtils.emptyIfNull(vmInfoMaps));
    }

    private static void exportEbackupPlaneData(XSSFSheet eBackupPlaneSheet, DeployParamsData deployParamsData) {
        List<Map<String, String>> vmPlanes;
        String vmName;
        ExportParametersExcelUtils.clearEbackupPlaneAllData(eBackupPlaneSheet);
        Map<String, List<Map<String, String>>> planeInfoMaps = deployParamsData.getEBackupPlaneExportInfos();
        List<Map<String, String>> vmInfos = deployParamsData.getEBackupVmExportInfos();
        int deltaRow = 0;
        if (!vmInfos.isEmpty()) {
            vmName = vmInfos.get(0).get(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.ebackup.vm.name"));
            vmPlanes = planeInfoMaps.getOrDefault(StringUtils.defaultString((String)vmName), Collections.emptyList());
            if (CollectionUtils.isEmpty(vmPlanes)) {
                return;
            }
            ExportParametersExcelUtils.exportMultiRows(eBackupPlaneSheet, 1, deltaRow, 1, vmPlanes);
            deltaRow += vmPlanes.size();
        }
        if (vmInfos.size() >= 2) {
            vmName = vmInfos.get(1).get(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.ebackup.vm.name"));
            vmPlanes = planeInfoMaps.getOrDefault(StringUtils.defaultString((String)vmName), Collections.emptyList());
            if (CollectionUtils.isEmpty(vmPlanes)) {
                return;
            }
            ExportParametersExcelUtils.exportMultiRows(eBackupPlaneSheet, 1, deltaRow, 1, vmPlanes);
        }
    }

    private static void clearEbackupPlaneAllData(XSSFSheet eBackupPlaneSheet) {
        int deltaRow = 0;
        LinkedList<Map<String, String>> emptyVmPlanes = new LinkedList<Map<String, String>>();
        emptyVmPlanes.add(Collections.emptyMap());
        emptyVmPlanes.add(Collections.emptyMap());
        emptyVmPlanes.add(Collections.emptyMap());
        emptyVmPlanes.add(Collections.emptyMap());
        ExportParametersExcelUtils.exportMultiRows(eBackupPlaneSheet, 1, deltaRow, 2, emptyVmPlanes);
        ExportParametersExcelUtils.exportMultiRows(eBackupPlaneSheet, 1, deltaRow += emptyVmPlanes.size(), 2, emptyVmPlanes);
    }

    private ExportParametersExcelUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

