/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.export.annotation.ExportField;
import com.huawei.yinglong.virtualization.deploy.entity.export.edme.DeployDmeParamsEntity;
import com.huawei.yinglong.virtualization.deploy.utils.DmeExportParamsFiledFilterUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExportParametersParseUtils {
    private static final Logger log = LoggerFactory.getLogger(ExportParametersParseUtils.class);

    public static Map<String, String> transferTableHeaderMappingParamsByAnnotation(Object exportObject) {
        Field[] declaredFields = exportObject.getClass().getDeclaredFields();
        return Arrays.stream(declaredFields).filter(field -> field.isAnnotationPresent(ExportField.class)).peek(field -> field.setAccessible(true)).collect(Collectors.toMap(field -> ResourceConfigLoader.getStringFromExportHeaderTemplate(field.getAnnotation(ExportField.class).tableHeader()), field -> ExportParametersParseUtils.getFieldContent(exportObject, field)));
    }

    public static DeployDmeParamsEntity transferDmeMapToExportEntity(Map<String, String> dmeMap) {
        DeployDmeParamsEntity exportEntity = new DeployDmeParamsEntity();
        Arrays.stream(exportEntity.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(ExportField.class)).peek(field -> field.setAccessible(true)).filter(field -> StringUtils.isNotEmpty((CharSequence)field.getAnnotation(ExportField.class).mapping())).forEach(field -> ExportParametersParseUtils.setFieldContent(dmeMap, exportEntity, field));
        return exportEntity;
    }

    private static void setFieldContent(Map<String, String> dmeMap, DeployDmeParamsEntity exportEntity, Field field) {
        String mappingKey = field.getAnnotation(ExportField.class).mapping();
        try {
            if (DmeExportParamsFiledFilterUtils.isSetFiled(field.getName(), dmeMap)) {
                field.set(exportEntity, dmeMap.getOrDefault(mappingKey, ""));
            }
        }
        catch (IllegalAccessException exception) {
            log.error("transfer map key {} to dme export entity error", (Object)mappingKey, (Object)exception);
        }
    }

    private static String getFieldContent(Object exportObject, Field field) {
        try {
            Object fieldContent = field.get(exportObject);
            if (Objects.isNull(fieldContent) || StringUtils.isEmpty((CharSequence)String.valueOf(fieldContent))) {
                return "";
            }
            String description = field.getAnnotation(ExportField.class).description();
            if (!StringUtils.isEmpty((CharSequence)description)) {
                return ResourceConfigLoader.getStringFromExportMsg(description + fieldContent);
            }
            if (field.getAnnotation(ExportField.class).isSensitive()) {
                return "********";
            }
            return String.valueOf(fieldContent);
        }
        catch (IllegalAccessException exception) {
            log.error("get filed {} error", (Object)field.getName(), (Object)exception);
            return "";
        }
    }

    private ExportParametersParseUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

