/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.smartkit.baseserver.report.business.excel.ReportCell;
import com.huawei.smartkit.baseserver.report.business.excel.ReportCellStyle;
import com.huawei.smartkit.baseserver.report.business.excel.ReportMergeRegion;
import com.huawei.smartkit.baseserver.report.business.excel.ReportRow;
import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.dto.ProcessActivity;
import com.huawei.yinglong.bpm.dto.ProcessInstanceDto;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.constant.ReportCellStypeEnum;
import com.huawei.yinglong.virtualization.deploy.constant.VirtualizationDeployConstant;
import com.huawei.yinglong.virtualization.deploy.entity.ExportReportDetailParams;
import com.huawei.yinglong.virtualization.deploy.entity.TaskDetailMergeItem;
import com.huawei.yinglong.virtualization.deploy.entity.TaskStateEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.export.ExportParams;
import com.huawei.yinglong.virtualization.deploy.utils.CallbackPackageSnMappingUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExportReportUtils {
    private static final Logger log = LoggerFactory.getLogger(ExportReportUtils.class);
    private static final String DEFAULT_TIME_FORMAT_INVALID = "--";
    private static final String RESOURCE_BUNDLE_NAME = "export_report";
    private static final EnumMap<ProcessStatus, String> processStatusMaps = new EnumMap(ProcessStatus.class);
    private static final EnumMap<TaskStateEnum, String> taskStatusMaps = new EnumMap(TaskStateEnum.class);
    private static final SimpleDateFormat dateFormat;

    public static String formatTime(long timeMs) {
        if (timeMs == 0L) {
            return DEFAULT_TIME_FORMAT_INVALID;
        }
        return dateFormat.format(new Date(timeMs));
    }

    public static String durationTime(long timeMs) {
        if (timeMs < 0L || timeMs > TimeUnit.DAYS.toMicros(1L)) {
            return DEFAULT_TIME_FORMAT_INVALID;
        }
        Duration duration = Duration.ofMillis(timeMs);
        long hour = duration.toHours();
        long minute = duration.toMinutes() % TimeUnit.HOURS.toMinutes(1L);
        long second = duration.getSeconds() % TimeUnit.MINUTES.toSeconds(1L);
        if (hour > 0L) {
            return ResourceUtils.getStringFromBundle((String)RESOURCE_BUNDLE_NAME, (String)"report.time.format.hour", (Object[])new Object[]{hour, minute, second});
        }
        if (minute > 0L) {
            return ResourceUtils.getStringFromBundle((String)RESOURCE_BUNDLE_NAME, (String)"report.time.format.minute", (Object[])new Object[]{minute, second});
        }
        return ResourceUtils.getStringFromBundle((String)RESOURCE_BUNDLE_NAME, (String)"report.time.format.second", (Object[])new Object[]{second});
    }

    public static String getString(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return "";
        }
        return ResourceUtils.getStringFromBundle((String)RESOURCE_BUNDLE_NAME, (String)key);
    }

    public static String formatStatus(ProcessStatus processStatus) {
        return StringUtils.defaultString((String)processStatusMaps.get(processStatus));
    }

    public static String formatStatus(TaskStateEnum stateEnum) {
        return StringUtils.defaultString((String)taskStatusMaps.get((Object)stateEnum));
    }

    public static ReportRow createTitleCell(int row, String value, int colSize) {
        LinkedList<ReportCell> cells = new LinkedList<ReportCell>();
        cells.add(ReportCell.builder().col(1).value((Object)value).build());
        cells.addAll(IntStream.rangeClosed(2, colSize).mapToObj(idx -> ReportCell.builder().value((Object)"").col(idx).build()).collect(Collectors.toList()));
        return ReportRow.builder().row(row).rowStyle((ReportCellStyle)ReportCellStypeEnum.TITLE).cells(cells).build();
    }

    public static ReportRow createMergeTitleCell(int row, ReportCellStyle cellStyle, Map<Integer, String> colValueMaps) {
        List cells = colValueMaps.entrySet().stream().map(entry -> ReportCell.builder().col(((Integer)entry.getKey()).intValue()).cellStyle(cellStyle).value(entry.getValue()).build()).collect(Collectors.toList());
        return ReportRow.builder().row(row).cells(cells).build();
    }

    public static ReportRow createListRows(int row, ReportCellStyle cellStyle, List<String> values) {
        return ExportReportUtils.createListRows(row, 1, cellStyle, values);
    }

    public static ReportRow createListRows(int row, int startCol, ReportCellStyle cellStyle, List<String> values) {
        AtomicInteger colIdx = new AtomicInteger(startCol);
        List cells = values.stream().map(value -> ReportCell.builder().col(colIdx.getAndIncrement()).value(value).build()).collect(Collectors.toList());
        return ReportRow.builder().row(row).rowStyle(cellStyle).cells(cells).build();
    }

    public static ReportRow createHorizontalKeyValue(int row, String key, String value) {
        LinkedList<ReportCell> cells = new LinkedList<ReportCell>();
        cells.add(ReportCell.builder().col(1).value((Object)key).cellStyle((ReportCellStyle)ReportCellStypeEnum.HEADER).build());
        cells.add(ReportCell.builder().col(2).value((Object)value).cellStyle((ReportCellStyle)ReportCellStypeEnum.DEFAULT).build());
        return ReportRow.builder().row(row).cells(cells).build();
    }

    public static List<Long> parseStartEndTime(List<DeployTaskDetailVo> detailItems) {
        if (detailItems.isEmpty()) {
            return Arrays.asList(0L, 0L);
        }
        List sortTimes = detailItems.stream().flatMap(deployTaskDetailVo -> Stream.of(deployTaskDetailVo.getBeginTime(), deployTaskDetailVo.getFinishTime())).filter(time -> time > 0L).sorted().collect(Collectors.toList());
        return Arrays.asList((Long)sortTimes.get(0), (Long)sortTimes.get(sortTimes.size() - 1));
    }

    public static Optional<String> canonicalReportPath(String reportPath) {
        try {
            File reportPathFile = new File(reportPath);
            if (reportPathFile.exists()) {
                return Optional.of(reportPathFile.getCanonicalPath());
            }
            boolean isMkdirSucceed = reportPathFile.mkdirs();
            log.info("current directory {} is not exists, mkdir result : {}.", (Object)reportPath, (Object)isMkdirSucceed);
            return isMkdirSucceed ? Optional.of(reportPathFile.getCanonicalPath()) : Optional.empty();
        }
        catch (IOException e) {
            log.error("get export report file error", (Throwable)e);
            return Optional.empty();
        }
    }

    public static ProcessStatus findDeployStatus(List<ProcessActivity> processActivities, String deployId) {
        return processActivities.stream().flatMap(processActivity -> ExportReportUtils.handleProcessActivity(processActivity).stream()).filter(processActivity -> Objects.equals(processActivity.getId(), deployId)).map(ProcessActivity::getStatus).findFirst().orElse(ProcessStatus.NO_START);
    }

    private static List<ProcessActivity> handleProcessActivity(ProcessActivity activity) {
        LinkedList<ProcessActivity> activities = new LinkedList<ProcessActivity>(CollectionUtils.emptyIfNull((Collection)activity.getChildren()));
        activities.add(activity);
        return activities;
    }

    public static boolean checkProcessInstanceValid(ProcessInstanceDto processInstanceDto) {
        if (Objects.isNull(processInstanceDto) || Objects.isNull(processInstanceDto.getProcessConfig())) {
            log.error("process instance dto is null or process config invalid.");
            return false;
        }
        ProcessStatus processStatus = processInstanceDto.getStatus();
        log.info("process instance status is {}", (Object)processStatus);
        return ProcessStatus.isEndStatus((ProcessStatus)processStatus);
    }

    public static String generateReportFileName(String prefix, String taskName) {
        String reportFileNamePattern = "{0}_{1}_{2}.xlsx";
        return MessageFormat.format("{0}_{1}_{2}.xlsx", prefix, taskName, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
    }

    public static void backupReportToToolBox(ExportParams exportParams, String reportFileName) {
        String reportBackupZipFile = FilePathValidatorUtils.joinChildPath((String[])new String[]{VirtualizationDeployConstant.REPORT_BACKUP_PATH, reportFileName + ".zip"});
        boolean result = ZipUtils.compressFileBy7Zip((String)VirtualizationDeployConstant.ZIP_TOOL_PATH, (String)FilePathValidatorUtils.joinChildPath((String[])new String[]{exportParams.getExportPath(), reportFileName}), (String)reportBackupZipFile);
        log.info("zip report file result : {}.", (Object)result);
        if (result) {
            CallbackPackageSnMappingUtils.recordToolPackageSnMapping("dcsDeploy", exportParams.getTaskId(), reportBackupZipFile);
        }
    }

    public static List<ReportRow> generateSummaryTaskBasicInfo(ProcessInstanceDto processInstanceDto, AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.basic.info"), 5));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.name"), processInstanceDto.getName()));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.create.time"), ExportReportUtils.formatTime(processInstanceDto.getCreateTime())));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.start.time"), ExportReportUtils.formatTime(processInstanceDto.getStartTime())));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.end.time"), ExportReportUtils.formatTime(processInstanceDto.getEndTime())));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.cost.time"), ExportReportUtils.durationTime(processInstanceDto.getEndTime() - processInstanceDto.getStartTime())));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.status"), ExportReportUtils.formatStatus(processInstanceDto.getStatus())));
        return reportRows;
    }

    public static List<ReportRow> generateTaskStatisticsInfo(Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps, String name, ProcessStatus status, List<String> deployIds, AtomicInteger row) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        reportRows.add(ExportReportUtils.createTitleCell(row.getAndIncrement(), ExportReportUtils.getString(name), 9));
        List<Long> startEndTimes = ExportReportUtils.getStartEndTimes(processActivityMaps, deployIds);
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(row.getAndIncrement(), ExportReportUtils.getString("report.start.time"), ExportReportUtils.formatTime(startEndTimes.get(0))));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(row.getAndIncrement(), ExportReportUtils.getString("report.end.time"), ExportReportUtils.formatTime(startEndTimes.get(1))));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(row.getAndIncrement(), ExportReportUtils.getString("report.cost.time"), ExportReportUtils.durationTime(startEndTimes.get(1) - startEndTimes.get(0))));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(row.getAndIncrement(), ExportReportUtils.getString("report.status.deploy"), ExportReportUtils.formatStatus(status)));
        return reportRows;
    }

    public static List<ReportMergeRegion> generateDetailItemHeaders(List<String> taskDetailItemHeaders, List<ReportRow> reportRows, AtomicInteger row) {
        int rowIdx = row.getAndIncrement();
        reportRows.add(ExportReportUtils.createListRows(rowIdx, ReportCellStypeEnum.HEADER, taskDetailItemHeaders));
        return Collections.singletonList(ReportMergeRegion.builder().firstRow(rowIdx).firstCol(1).lastRow(rowIdx).lastCol(2).build());
    }

    public static List<ReportMergeRegion> generateTaskDetailItems(ExportReportDetailParams params) {
        int firstRow = params.getRow().get();
        LinkedList<DeployTaskDetailVo> allDetailItems = new LinkedList<DeployTaskDetailVo>();
        List<TaskDetailMergeItem> mergeRowItems = ExportReportUtils.parseChildTaskDetailItems(params.getProcessActivityMap(), allDetailItems, params.getDeployId(), firstRow, params.getStypeEnum());
        mergeRowItems.add(new TaskDetailMergeItem().setStartRow(firstRow).setMergeCol(1).setRowCount(allDetailItems.size()).setValue(ExportReportUtils.getString(params.getName())).setCellStyle(params.getStypeEnum()));
        return ExportReportUtils.createTaskDetailItemRow(params.getReportRows(), params.getRow(), allDetailItems, mergeRowItems);
    }

    public static List<TaskDetailMergeItem> parseChildTaskDetailItems(Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps, List<DeployTaskDetailVo> allDetailItems, String deployId, int firstRow, ReportCellStyle cellStyle) {
        List<DeployTaskDetailVo> detailItems = ExportReportUtils.getDeployDetailItems(processActivityMaps, deployId);
        LinkedList<TaskDetailMergeItem> mergeRowItems = new LinkedList<TaskDetailMergeItem>();
        int idx = 0;
        int mergeColumnIdx = 2;
        int singleStartRow = 0;
        for (DeployTaskDetailVo detailItem : detailItems) {
            if (CollectionUtils.isEmpty((Collection)detailItem.getChildren())) {
                allDetailItems.add(detailItem);
                if (singleStartRow == 0) {
                    singleStartRow = firstRow + idx;
                }
                ++idx;
                continue;
            }
            if (singleStartRow > 0) {
                mergeRowItems.add(new TaskDetailMergeItem().setStartRow(singleStartRow).setRowCount(firstRow + idx - singleStartRow).setMergeCol(2).setCellStyle(cellStyle));
            }
            singleStartRow = 0;
            allDetailItems.addAll(detailItem.getChildren());
            int detailChildSize = detailItem.getChildren().size();
            mergeRowItems.add(new TaskDetailMergeItem().setStartRow(firstRow + idx).setRowCount(detailChildSize).setMergeCol(2).setCellStyle(cellStyle).setValue(detailItem.getTaskName()));
            idx += detailChildSize;
        }
        if (singleStartRow > 0) {
            mergeRowItems.add(new TaskDetailMergeItem().setStartRow(singleStartRow).setRowCount(firstRow + idx - singleStartRow).setMergeCol(2).setCellStyle(cellStyle));
        }
        return mergeRowItems;
    }

    public static List<DeployTaskDetailVo> getDeployDetailItems(Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps, String deployId) {
        return processActivityMaps.entrySet().stream().filter(entry -> Objects.equals(((ProcessActivity)entry.getKey()).getId(), deployId)).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
    }

    public static ReportCell generateOnlyOneLevelMergeCell(String nameKey, ReportCellStyle cellStyle) {
        return ReportCell.builder().col(1).value((Object)ExportReportUtils.getString(nameKey)).cellStyle(cellStyle).build();
    }

    public static List<ReportMergeRegion> generateOnlyOneLevelDetailItems(List<ReportRow> reportRows, AtomicInteger fcRow, List<DeployTaskDetailVo> detailItems, ReportCell mergeCell) {
        int firstRow = fcRow.get();
        reportRows.addAll(detailItems.stream().map(detailItem -> ExportReportUtils.createListRows(fcRow.getAndIncrement(), 3, ReportCellStypeEnum.DEFAULT, ExportReportUtils.parseTaskDetailItems(detailItem))).collect(Collectors.toList()));
        ExportReportUtils.insertMergeRegionCell(reportRows, firstRow, mergeCell);
        return Collections.singletonList(ReportMergeRegion.builder().firstRow(firstRow).firstCol(1).lastRow(firstRow + detailItems.size() - 1).lastCol(2).build());
    }

    public static List<ReportMergeRegion> createTaskDetailItemRow(List<ReportRow> reportRows, AtomicInteger fcRow, List<DeployTaskDetailVo> allDetailItems, List<TaskDetailMergeItem> mergeRowItems) {
        reportRows.addAll(allDetailItems.stream().map(detailItem -> ExportReportUtils.createListRows(fcRow.getAndIncrement(), 3, ReportCellStypeEnum.DEFAULT, ExportReportUtils.parseTaskDetailItems(detailItem))).collect(Collectors.toList()));
        mergeRowItems.forEach(mergeItem -> ExportReportUtils.insertMergeRegionCell(reportRows, mergeItem.getStartRow(), ReportCell.builder().col(mergeItem.getMergeCol()).cellStyle(mergeItem.getCellStyle()).value((Object)mergeItem.getValue()).build()));
        return mergeRowItems.stream().filter(TaskDetailMergeItem::isNeedMerge).map(mergeItem -> ReportMergeRegion.builder().firstRow(mergeItem.getStartRow()).firstCol(mergeItem.getMergeCol()).lastRow(mergeItem.getLastRow()).lastCol(mergeItem.getMergeCol()).build()).collect(Collectors.toList());
    }

    private static List<String> parseTaskDetailItems(DeployTaskDetailVo detailItem) {
        TaskStateEnum stateEnum = TaskStateEnum.of(detailItem.getState());
        return Arrays.asList(detailItem.getTaskName(), ExportReportUtils.formatTime(detailItem.getBeginTime()), ExportReportUtils.formatTime(detailItem.getFinishTime()), ExportReportUtils.durationTime(detailItem.getFinishTime() - detailItem.getBeginTime()), ExportReportUtils.formatStatus(stateEnum), StringUtils.defaultString((String)(ExportReportUtils.isShowTaskDetailErrorMsg(stateEnum) ? detailItem.getErrorMsg() : null)), StringUtils.defaultString((String)(ExportReportUtils.isShowTaskDetailErrorMsg(stateEnum) ? detailItem.getSuggestion() : null)));
    }

    private static void insertMergeRegionCell(List<ReportRow> reportRows, int row, ReportCell reportCell) {
        reportRows.stream().filter(reportRow -> reportRow.getRow() == row).findFirst().ifPresent(reportRow -> reportRow.getCells().add(reportCell));
    }

    private static boolean isShowTaskDetailErrorMsg(TaskStateEnum stateEnum) {
        return stateEnum == TaskStateEnum.ERROR || stateEnum == TaskStateEnum.PAUSE;
    }

    private static List<Long> getStartEndTimes(Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps, List<String> deployIds) {
        List<DeployTaskDetailVo> detailItems = processActivityMaps.entrySet().stream().filter(entry -> deployIds.contains(((ProcessActivity)entry.getKey()).getId())).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
        return ExportReportUtils.parseStartEndTime(detailItems);
    }

    public static List<String> getSummaryBasicInfoValues(Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps, String deployId, String resNameId) {
        AtomicReference<ProcessStatus> processStatus = new AtomicReference<ProcessStatus>(ProcessStatus.NO_START);
        List<Long> startEndTime = ExportReportUtils.parseStartEndTime(ExportReportUtils.getDeployDmeDcsDetailItems(processActivityMaps, deployId, processStatus));
        return Arrays.asList(ExportReportUtils.getString(resNameId), ExportReportUtils.formatTime(startEndTime.get(0)), ExportReportUtils.formatTime(startEndTime.get(1)), ExportReportUtils.durationTime(startEndTime.get(1) - startEndTime.get(0)), ExportReportUtils.formatStatus(processStatus.get()));
    }

    private static List<DeployTaskDetailVo> getDeployDmeDcsDetailItems(Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps, String deployId, AtomicReference<ProcessStatus> processStatus) {
        return processActivityMaps.keySet().stream().filter(processActivity -> Objects.equals(deployId, processActivity.getId())).peek(processActivity -> processStatus.set(processActivity.getStatus())).flatMap(processActivity -> ((List)processActivityMaps.get(processActivity)).stream()).collect(Collectors.toList());
    }

    public static Map<ProcessActivity, List<DeployTaskDetailVo>> filterProcessActivityMaps(BpmEngineService bpmEngineService, List<ProcessActivity> processActivities) {
        HashMap<ProcessActivity, List<DeployTaskDetailVo>> activityListMaps = new HashMap<ProcessActivity, List<DeployTaskDetailVo>>();
        CollectionUtils.emptyIfNull(processActivities).stream().filter(processActivity -> CollectionUtils.isNotEmpty((Collection)processActivity.getChildren())).flatMap(processActivity -> processActivity.getChildren().stream()).flatMap(processActivity -> ExportReportUtils.getProcessActivities(processActivity).stream()).forEach(processActivity -> ExportReportUtils.generateProcessActivity2DetailsMap(bpmEngineService, processActivity, activityListMaps));
        return activityListMaps;
    }

    private static List<ProcessActivity> getProcessActivities(ProcessActivity processActivity) {
        if (CollectionUtils.isNotEmpty((Collection)processActivity.getChildren())) {
            return processActivity.getChildren();
        }
        return Collections.singletonList(processActivity);
    }

    private static void generateProcessActivity2DetailsMap(BpmEngineService bpmEngineService, ProcessActivity processActivity, Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps) {
        if (StringUtils.isEmpty((CharSequence)processActivity.getActivityInstanceId())) {
            processActivityMaps.put(processActivity, Collections.emptyList());
            log.info("put empty process activity map, id={}.", (Object)processActivity.getId());
            return;
        }
        ProcessActivity processActivityDetail = bpmEngineService.querySingleActivityByInstanceId(processActivity.getActivityInstanceId());
        List businessMaps = processActivityDetail.getChildren().stream().map(ProcessActivity::getBusiness).filter(Objects::nonNull).filter(map -> map.containsKey("details")).collect(Collectors.toList());
        log.info("process id {}, business map size is {}.", (Object)processActivityDetail.getId(), (Object)businessMaps.size());
        List dcsDetailItems = businessMaps.stream().map(map -> map.get("details")).filter(details -> details instanceof List).flatMap(details -> ((List)details).stream()).map(detail -> (DeployTaskDetailVo)ObjectMapperUtils.transObject((Object)detail, DeployTaskDetailVo.class, null)).filter(Objects::nonNull).collect(Collectors.toList());
        processActivityMaps.put(processActivity, dcsDetailItems);
        log.info("put some process activity map, id={}, size={}.", (Object)processActivity.getId(), (Object)dcsDetailItems.size());
    }

    public static boolean hasDeployDmeModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containDmeDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeployEDataInsightModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containDayuDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeployHiCloudModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containHiCloudDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeploySfsModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containSfsDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeploySdnModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containSdnDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeployCampusModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containCampusDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeployMigrationModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containFusionCube82xDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeployFusionComputeModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containFcDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeployEbackupModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containEbackupDeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeployUltraVRModule(VirtualizationDeployProcessConfig processConfig) {
        return InstallModeEnum.containUltraVRdeployScene(processConfig.getInstallMode());
    }

    public static boolean hasDeployA3000Module(A3000DeployProcessConfig processConfig, InstallModeEnum modeEnum) {
        return CollectionUtils.emptyIfNull(processConfig.getInstallMode()).contains(modeEnum.getInstallMode());
    }

    private ExportReportUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        processStatusMaps.put(ProcessStatus.NO_START, ExportReportUtils.getString("report.status.nostart"));
        processStatusMaps.put(ProcessStatus.RUNNING, ExportReportUtils.getString("report.status.running"));
        processStatusMaps.put(ProcessStatus.FAILED, ExportReportUtils.getString("report.status.failed"));
        processStatusMaps.put(ProcessStatus.SUCCEED, ExportReportUtils.getString("report.status.succeed"));
        processStatusMaps.put(ProcessStatus.FINISHED, ExportReportUtils.getString("report.status.finished"));
        processStatusMaps.put(ProcessStatus.PAUSE, ExportReportUtils.getString("report.status.pause"));
        taskStatusMaps.put(TaskStateEnum.NOT_START, ExportReportUtils.getString("report.status.nostart"));
        taskStatusMaps.put(TaskStateEnum.RUNNING, ExportReportUtils.getString("report.status.running"));
        taskStatusMaps.put(TaskStateEnum.ERROR, ExportReportUtils.getString("report.status.failed"));
        taskStatusMaps.put(TaskStateEnum.END, ExportReportUtils.getString("report.status.finished"));
        taskStatusMaps.put(TaskStateEnum.SKIP, ExportReportUtils.getString("report.status.skip"));
        taskStatusMaps.put(TaskStateEnum.PAUSE, ExportReportUtils.getString("report.status.pause"));
        taskStatusMaps.put(TaskStateEnum.DAYU_STOPPED, ExportReportUtils.getString("report.status.pause"));
        taskStatusMaps.put(TaskStateEnum.DAYU_FINISHED, ExportReportUtils.getString("report.status.finished"));
        taskStatusMaps.put(TaskStateEnum.DAYU_FAILED, ExportReportUtils.getString("report.status.failed"));
        taskStatusMaps.put(TaskStateEnum.DAYU_ROLLBACK_FAILED, ExportReportUtils.getString("report.dayu.status.rollback.failed"));
        taskStatusMaps.put(TaskStateEnum.DAYU_ROLLBACK_SUCCESS, ExportReportUtils.getString("report.dayu.status.rollback.success"));
        dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }
}

