/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.virtualization.deploy.utils.FilePathValidateUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileContentUtils {
    private static final Logger log = LoggerFactory.getLogger(FileContentUtils.class);

    public static String readStringFromFile(String path) {
        Optional<String> normalizationPath = FilePathValidateUtils.getNormalizationPath(path);
        if (!normalizationPath.isPresent()) {
            log.error("can't get normal precheck path");
            return "";
        }
        File file = new File(normalizationPath.get());
        try {
            return FileUtils.readFileToString((File)file, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException exception) {
            log.error("can't read content from precheck json file");
            return "";
        }
    }

    private FileContentUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

