/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.excel.ExcelMergeCellArea;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployParamsData;
import com.huawei.yinglong.virtualization.deploy.utils.ExcelCommonUtils;
import com.huawei.yinglong.virtualization.deploy.utils.FilePathValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvUtils;
import com.huawei.yinglong.virtualization.deploy.utils.a3000.VerifyContext;
import com.huawei.yinglong.virtualization.deploy.utils.importing.ImportEcontainerParamUtils;
import com.huawei.yinglong.virtualization.deploy.utils.importing.ImportIntegrateParamUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImportParametersExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ImportParametersExcelUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DeployParamsData importParamsFromExcel(String excelPath, List<String> installMode, boolean isA3000) {
        Optional<String> normalizationPath = FilePathValidateUtils.getNormalizationPath(excelPath);
        if (!normalizationPath.isPresent()) {
            log.error("current template path invalid,return empty data");
            return ImportParametersExcelUtils.emptyDeployData();
        }
        log.info("parse date from template");
        try (XSSFWorkbook workbook = new XSSFWorkbook(Files.newInputStream(Paths.get(normalizationPath.get(), new String[0]), new OpenOption[0]));){
            if (ToolEnvUtils.isA3000Deploy()) {
                DeployParamsData deployParamsData = ImportParametersExcelUtils.parseA3000Params(workbook);
                return deployParamsData;
            }
            if (ToolEnvUtils.isA3000Expansion()) {
                DeployParamsData deployParamsData = ImportParametersExcelUtils.parseA3000ExpansionParams(workbook);
                return deployParamsData;
            }
            DeployParamsData deployParamsData = ImportParametersExcelUtils.parseFcParams(installMode, workbook);
            return deployParamsData;
        }
        catch (IOException exception) {
            log.error("parse template error,return empty data");
            return ImportParametersExcelUtils.emptyDeployData();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DeployParamsData importIntegrateParamsFromExcel(String excelPath, List<String> installMode) {
        Optional<String> normalizationPath = FilePathValidateUtils.getNormalizationPath(excelPath);
        if (!normalizationPath.isPresent()) {
            log.error("current template path invalid,return empty data");
            return ImportParametersExcelUtils.emptyDeployData();
        }
        log.info("parse date from template");
        try (XSSFWorkbook workbook = new XSSFWorkbook(Files.newInputStream(Paths.get(normalizationPath.get(), new String[0]), new OpenOption[0]));){
            DeployParamsData deployParamsData = ImportParametersExcelUtils.parseIntegrateParams(installMode, workbook);
            return deployParamsData;
        }
        catch (IOException exception) {
            log.error("parse template error,return empty data");
            return ImportParametersExcelUtils.emptyDeployData();
        }
    }

    private static DeployParamsData parseIntegrateParams(List<String> installMode, XSSFWorkbook workbook) {
        return DeployParamsData.builder().integrateInfo(ImportIntegrateParamUtils.parseIntegrateParams(workbook, installMode).orElse(null)).build();
    }

    private static DeployParamsData parseFcParams(List<String> installMode, XSSFWorkbook workbook) {
        XSSFSheet fusionComputeSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.sheet"));
        return DeployParamsData.builder().fcBaseInfos(ImportParametersExcelUtils.parseFcBaseParams((Sheet)fusionComputeSheet, installMode)).vrmExportInfos(ImportParametersExcelUtils.parseVrmParams((Sheet)fusionComputeSheet, installMode)).fcCommonInfos(ImportParametersExcelUtils.parseFcCommonParams((Sheet)fusionComputeSheet, installMode)).ntpTimeInfos(ImportParametersExcelUtils.parseFcNtpTimeParams((Sheet)fusionComputeSheet, installMode)).backupInfos(ImportParametersExcelUtils.parseFcBackupParams((Sheet)fusionComputeSheet, installMode)).fcHostExportInfos(ImportParametersExcelUtils.parseFcHostParams((Sheet)workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.host.sheet")), installMode)).ultraExportInfos(ImportParametersExcelUtils.parseUltraVRParams((Sheet)workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ultravr.sheet")), installMode)).eBackupExportInfos(ImportParametersExcelUtils.parseEbackupBasicParams((Sheet)workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.sheet")), installMode)).eBackupVmExportInfos(ImportParametersExcelUtils.parseEbackupVmInfos((Sheet)workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.sheet")), installMode)).eBackupPlaneExportInfos(ImportParametersExcelUtils.parseEbackupVmPlaneInfos((Sheet)workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.parmas.template.plane.sheet")), installMode)).dmeExportInfos(ImportParametersExcelUtils.parseDmeParams((Sheet)workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.sheet")), installMode)).dayuExportInfos(ImportParametersExcelUtils.parseDayuParams((Sheet)workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.sheet")), workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.component.sheet")), installMode)).dayuPlaneExportInfos(ImportParametersExcelUtils.parseDayuPlaneParams(workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.plane.sheet")), installMode)).hiCloudExportInfos(ImportParametersExcelUtils.parseHiCloudParams(workbook, installMode)).hiCloudVmExportInfos(ImportParametersExcelUtils.parseHiCloudVmParams(workbook, installMode)).sfsExportInfos(ImportParametersExcelUtils.parseSfsParams(workbook, installMode)).sfsVmExportInfos(ImportParametersExcelUtils.parseSfsVmParams(workbook, installMode)).sdnExportInfos(ImportParametersExcelUtils.parseSdnParams(workbook, installMode)).sdnVmExportInfos(ImportParametersExcelUtils.parseSdnVmParams(workbook, installMode)).campusCoreExportInfos(ImportParametersExcelUtils.parseCampusCoreParams(workbook, installMode)).campusCoreVmExportInfos(ImportParametersExcelUtils.parseCampusCoreVmParams(workbook, installMode)).fusionCube82xInfos(ImportParametersExcelUtils.parseFusionCube82xparams(workbook, installMode)).fusionCube82xVmInfos(ImportParametersExcelUtils.parseFusionCubeVmInfosParams(workbook, installMode)).build();
    }

    private static List<Map<String, String>> parseFusionCubeVmInfosParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containFusionCube82xDeployScene(installMode)) {
            return Collections.emptyList();
        }
        return Optional.ofNullable(workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.fusion.cube.vm.params.sheet"))).map(sfsVmSheet -> ImportParametersExcelUtils.parseSubTableByHeader((Sheet)sfsVmSheet, 1, sfsVmSheet.getLastRowNum() + 1, 4)).orElse(Collections.emptyList());
    }

    private static Map<String, String> parseFusionCube82xparams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containFusionCube82xDeployScene(installMode)) {
            return Collections.emptyMap();
        }
        XSSFSheet sheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.fusion.cube.params.sheet"));
        if (Objects.isNull(sheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> fusionCubeb2xMap = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.fusion.cube.base.params.title"));
        fusionCubeb2xMap.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.fusion.cube.password.params.title")));
        fusionCubeb2xMap.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.fusion.cube.network.params.title")));
        return fusionCubeb2xMap;
    }

    private static List<Map<String, String>> parseSdnVmParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containSdnDeployScene(installMode)) {
            return Collections.emptyList();
        }
        return Optional.ofNullable(workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sdn.vm.sheet"))).map(vmSheet -> ImportParametersExcelUtils.parseSubTableByHeader((Sheet)vmSheet, 1, vmSheet.getLastRowNum() + 1, 4)).orElse(Collections.emptyList());
    }

    private static Map<String, String> parseSdnParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containSdnDeployScene(installMode)) {
            return Collections.emptyMap();
        }
        XSSFSheet sfsSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sdn.sheet"));
        if (Objects.isNull(sfsSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> sdbParam = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sdn.base.title"));
        sdbParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sdn.general.title")));
        sdbParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sdn.password.title")));
        sdbParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sdn.network.title")));
        return sdbParam;
    }

    private static DeployParamsData parseA3000Params(XSSFWorkbook workbook) {
        return DeployParamsData.builder().eContainerInfo(ImportEcontainerParamUtils.parseEcontainerParams(workbook).orElse(null)).build();
    }

    private static DeployParamsData parseA3000ExpansionParams(XSSFWorkbook workbook) {
        return DeployParamsData.builder().eContainerInfo(ImportEcontainerParamUtils.parseParamsA3000Expansion(workbook).orElse(null)).build();
    }

    private static List<Map<String, String>> parseCampusCoreVmParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containCampusCoreDeployScene(installMode)) {
            return Collections.emptyList();
        }
        return Optional.ofNullable(workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.campus.vm.sheet"))).map(campusCoreVmSheet -> ImportParametersExcelUtils.parseSubTableByHeader((Sheet)campusCoreVmSheet, 1, campusCoreVmSheet.getLastRowNum() + 1, 10)).orElse(Collections.emptyList());
    }

    private static Map<String, String> parseCampusCoreParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containCampusCoreDeployScene(installMode)) {
            return Collections.emptyMap();
        }
        XSSFSheet campusCoreSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.campus.sheet"));
        if (Objects.isNull(campusCoreSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> campusCoreParam = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)campusCoreSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.common.virtualization.title"));
        campusCoreParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)campusCoreSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.campus.base.title")));
        campusCoreParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)campusCoreSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.campus.level.title")));
        campusCoreParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)campusCoreSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.campus.global.title")));
        return campusCoreParam;
    }

    private static List<Map<String, String>> parseSfsVmParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containSfsDeployScene(installMode)) {
            return Collections.emptyList();
        }
        return Optional.ofNullable(workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sfs.vm.sheet"))).map(sfsVmSheet -> ImportParametersExcelUtils.parseSubTableByHeader((Sheet)sfsVmSheet, 1, sfsVmSheet.getLastRowNum() + 1, 2)).orElse(Collections.emptyList());
    }

    private static Map<String, String> parseSfsParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containSfsDeployScene(installMode)) {
            return Collections.emptyMap();
        }
        XSSFSheet sfsSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sfs.sheet"));
        if (Objects.isNull(sfsSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> sfsParam = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.common.virtualization.title"));
        sfsParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sfs.base.title")));
        sfsParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sfs.manage.plan.title")));
        sfsParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.sfs.manage.plan.password.title")));
        return sfsParam;
    }

    private static List<Map<String, String>> parseHiCloudVmParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containHiCloudDeployScene(installMode)) {
            return Collections.emptyList();
        }
        return Optional.ofNullable(workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.vm.sheet"))).map(hiCloudVmSheet -> ImportParametersExcelUtils.parseSubTableByHeader((Sheet)hiCloudVmSheet, 1, hiCloudVmSheet.getLastRowNum() + 1, 5)).orElse(Collections.emptyList());
    }

    private static Map<String, String> parseHiCloudParams(XSSFWorkbook workbook, List<String> installMode) {
        if (!InstallModeEnum.containHiCloudDeployScene(installMode)) {
            return Collections.emptyMap();
        }
        XSSFSheet hiCloudSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.sheet"));
        if (Objects.isNull(hiCloudSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> hiCloudParam = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.common.virtualization.title"));
        hiCloudParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.base.title")));
        hiCloudParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.gde.manage.title")));
        hiCloudParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.gde.data.title")));
        hiCloudParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.gde.plane.title")));
        hiCloudParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.hicloud.service.title")));
        return hiCloudParam;
    }

    private static List<Map<String, String>> parseDayuPlaneParams(XSSFSheet dayuSheet, List<String> installMode) {
        if (!InstallModeEnum.containDayuDeployScene(installMode) || Objects.isNull(dayuSheet)) {
            return Collections.emptyList();
        }
        boolean vmPlaneHeaderRowIdx = true;
        XSSFRow headerRow = dayuSheet.getRow(1);
        List<String> headers = ImportParametersExcelUtils.parseDayuVmPlaneHeaders((Row)headerRow);
        return ImportParametersExcelUtils.buildDayuVmPlaneList(headers, dayuSheet);
    }

    private static List<Map<String, String>> buildDayuVmPlaneList(List<String> headers, XSSFSheet dayuSheet) {
        XSSFRow row;
        ArrayList<Map<String, String>> dayuVmplanes = new ArrayList<Map<String, String>>();
        int vmPlaneDataRowIdx = 2;
        while (!Objects.isNull(row = dayuSheet.getRow(vmPlaneDataRowIdx)) && ImportParametersExcelUtils.isHostNameExist((Row)row)) {
            ++vmPlaneDataRowIdx;
            dayuVmplanes.add(ImportParametersExcelUtils.buidDayuVmMap((Row)row, headers));
        }
        return dayuVmplanes;
    }

    private static boolean isHostNameExist(Row row) {
        return StringUtils.isNotEmpty((CharSequence)row.getCell(0).getStringCellValue());
    }

    private static Map<String, String> buidDayuVmMap(Row row, List<String> headers) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        IntStream.range(0, row.getLastCellNum()).forEach(index -> paramsMap.put((String)headers.get(index), ImportParametersExcelUtils.getCellStringValue(row.getCell(index))));
        return paramsMap;
    }

    private static String getCellStringValue(Cell cell) {
        if (Objects.isNull(cell)) {
            return "";
        }
        if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue());
        }
        return "";
    }

    private static List<String> parseDayuVmPlaneHeaders(Row headerRow) {
        return IntStream.range(0, headerRow.getLastCellNum()).mapToObj(index -> headerRow.getCell(index).getStringCellValue()).collect(Collectors.toList());
    }

    private static Map<String, List<Map<String, String>>> parseEbackupVmPlaneInfos(Sheet eBackupSheet, List<String> installMode) {
        if (!InstallModeEnum.containEbackupDeployScene(installMode) || Objects.isNull(eBackupSheet)) {
            return Collections.emptyMap();
        }
        boolean vmPlaneHeaderRowIdx = true;
        Row headerRow = eBackupSheet.getRow(1);
        List<String> headers = ImportParametersExcelUtils.parseEBackupVmPlaneHeaders(headerRow);
        HashMap<String, List<Map<String, String>>> vmPlaneMaps = new HashMap<String, List<Map<String, String>>>();
        String headerName = ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.vm1.tile");
        vmPlaneMaps.put(headerName, ImportParametersExcelUtils.parseEbackupVmPlaneInfo(eBackupSheet, headerName, headerRow, headers));
        headerName = ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.vm2.tile");
        vmPlaneMaps.put(headerName, ImportParametersExcelUtils.parseEbackupVmPlaneInfo(eBackupSheet, headerName, headerRow, headers));
        return vmPlaneMaps;
    }

    private static List<String> parseEBackupVmPlaneHeaders(Row headerRow) {
        return IntStream.range(0, headerRow.getLastCellNum()).mapToObj(arg_0 -> ((Row)headerRow).getCell(arg_0)).map(ImportParametersExcelUtils::getStringFromDiffTypeCell).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private static List<Map<String, String>> parseEbackupVmPlaneInfo(Sheet eBackupSheet, String headerName, Row headerRow, List<String> headers) {
        Optional<ExcelMergeCellArea> subTableArea = ExcelCommonUtils.getMergeCellPositionByCellValue(eBackupSheet, headerName);
        if (!subTableArea.isPresent()) {
            log.error("{} param area not exists", (Object)headerName);
            return Collections.emptyList();
        }
        ExcelMergeCellArea cellArea = subTableArea.get();
        int startRow = cellArea.getFirstRow();
        int endRow = cellArea.getLastRow();
        log.info("start parse [{}] vm plane table, from [{}] row to [{}] row", new Object[]{headerName, startRow, endRow});
        return IntStream.range(startRow, endRow + 1).mapToObj(arg_0 -> ((Sheet)eBackupSheet).getRow(arg_0)).map(dataRow -> ImportParametersExcelUtils.parseSingleRowByHeader(headerRow, dataRow)).peek(dataMap -> dataMap.put(headers.get(0), headerName)).collect(Collectors.toList());
    }

    private static List<Map<String, String>> parseEbackupVmInfos(Sheet eBackupSheet, List<String> installMode) {
        if (!InstallModeEnum.containEbackupDeployScene(installMode) || Objects.isNull(eBackupSheet)) {
            return Collections.emptyList();
        }
        LinkedList<Map<String, String>> eBackupVmInfos = new LinkedList<Map<String, String>>();
        Map<String, String> vmInfoMaps = ImportParametersExcelUtils.parseColSubTableByHeader(eBackupSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.vm1.tile"));
        String vmListName = ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.ebackup.vm.list");
        vmInfoMaps.put(vmListName, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.vm1.tile"));
        eBackupVmInfos.add(vmInfoMaps);
        vmInfoMaps = ImportParametersExcelUtils.parseColSubTableByHeader(eBackupSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.vm2.tile"));
        if (ImportParametersExcelUtils.checkEbackupHasVm(vmInfoMaps)) {
            vmInfoMaps.put(vmListName, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.vm2.tile"));
            eBackupVmInfos.add(vmInfoMaps);
        }
        return eBackupVmInfos;
    }

    private static boolean checkEbackupHasVm(Map<String, String> vmInfoMaps) {
        return Stream.of("deploy.template.header.ebackup.vm.name", "deploy.template.header.ebackup.vm.role", "deploy.template.header.ebackup.belong.cna").map(ResourceConfigLoader::getStringFromExportHeaderTemplate).map(vmInfoMaps::get).allMatch(StringUtils::isNotEmpty);
    }

    private static Map<String, String> parseEbackupBasicParams(Sheet eBackupSheet, List<String> installMode) {
        if (!InstallModeEnum.containEbackupDeployScene(installMode) || Objects.isNull(eBackupSheet)) {
            return Collections.emptyMap();
        }
        return ImportParametersExcelUtils.parseColSubTableByHeader(eBackupSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ebackup.template.title"));
    }

    private static Map<String, String> parseUltraVRParams(Sheet ultraVRSheet, List<String> installMode) {
        if (!InstallModeEnum.containUltraVRdeployScene(installMode) || Objects.isNull(ultraVRSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> ultraVRMaps = ImportParametersExcelUtils.parseColSubTableByHeader(ultraVRSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ultravr.template.title"));
        ultraVRMaps.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(ultraVRSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.ultravr.vm.title")));
        return ultraVRMaps;
    }

    private static List<Map<String, String>> parseFcHostParams(Sheet fcSheet, List<String> installMode) {
        if (!InstallModeEnum.containFcCnaDeployScene(installMode) || Objects.isNull(fcSheet)) {
            return Collections.emptyList();
        }
        int headerRow = ImportParametersExcelUtils.getTemplateHeaderStartRowNum(fcSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.host.title"));
        int dataEndRow = fcSheet.getLastRowNum();
        return ImportParametersExcelUtils.parseSubTableByHeader(fcSheet, headerRow + 1, dataEndRow + 1, 100);
    }

    private static Map<String, String> parseFcBaseParams(Sheet fcSheet, List<String> installMode) {
        if (!InstallModeEnum.containFcDeployScene(installMode) || Objects.isNull(fcSheet)) {
            return Collections.emptyMap();
        }
        return ImportParametersExcelUtils.parseColSubTableByHeader(fcSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.base.title"));
    }

    private static Map<String, String> parseFcCommonParams(Sheet fcSheet, List<String> installMode) {
        if (!InstallModeEnum.containFcDeployScene(installMode) || Objects.isNull(fcSheet)) {
            return Collections.emptyMap();
        }
        return ImportParametersExcelUtils.parseColSubTableByHeader(fcSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.common.title"));
    }

    private static Map<String, String> parseFcNtpTimeParams(Sheet fcSheet, List<String> installMode) {
        if (!InstallModeEnum.containFcVrmDeployScene(installMode) || Objects.isNull(fcSheet)) {
            return Collections.emptyMap();
        }
        return ImportParametersExcelUtils.parseColSubTableByHeader(fcSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.ntp.time.title"));
    }

    private static Map<String, String> parseFcBackupParams(Sheet fcSheet, List<String> installMode) {
        if (!InstallModeEnum.containFcVrmDeployScene(installMode) || Objects.isNull(fcSheet)) {
            return Collections.emptyMap();
        }
        return ImportParametersExcelUtils.parseColSubTableByHeader(fcSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.fc.backup.title"));
    }

    private static Map<String, String> parseVrmParams(Sheet vrmSheet, List<String> installMode) {
        if (!InstallModeEnum.containFcVrmDeployScene(installMode) || Objects.isNull(vrmSheet)) {
            return Collections.emptyMap();
        }
        return ImportParametersExcelUtils.parseColSubTableByHeader(vrmSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.vrm.title"));
    }

    private static Map<String, String> parseDmeParams(Sheet dmeSheet, List<String> installMode) {
        if (!InstallModeEnum.containDmeDeployScene(installMode) || Objects.isNull(dmeSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> dmeParamsData = ImportParametersExcelUtils.parseColSubTableByHeader(dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.common.virtualization.title"));
        dmeParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.title")));
        dmeParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.tenant.title")));
        dmeParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.fusion.compute.title")));
        dmeParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.container.tenant.title")));
        dmeParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.container.cluster.service.title")));
        dmeParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dmeSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dme.dcsas.title")));
        return dmeParamsData;
    }

    private static Map<String, String> parseDayuParams(Sheet dayuSheet, XSSFSheet componentSheet, List<String> installMode) {
        if (!InstallModeEnum.containDayuDeployScene(installMode) || Objects.isNull(dayuSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> dayuParamsData = ImportParametersExcelUtils.parseColSubTableByHeader(dayuSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.common.virtualization.title"));
        dayuParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dayuSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.common.info.title")));
        dayuParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dayuSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.service.info.title")));
        dayuParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dayuSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.dayu.password.title")));
        dayuParamsData.putAll(ImportParametersExcelUtils.parseColSubTableByHeader(dayuSheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.pacific.title")));
        if (Objects.nonNull(componentSheet)) {
            dayuParamsData.put(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.dayu.component.list"), ImportParametersExcelUtils.getComponentListAsString(componentSheet));
        }
        return dayuParamsData;
    }

    private static String getComponentListAsString(XSSFSheet componentSheet) {
        XSSFRow currentRow;
        ArrayList<String> components = new ArrayList<String>();
        int rows = 2;
        while (!Objects.isNull(currentRow = componentSheet.getRow(rows))) {
            ++rows;
            if (!currentRow.getCell(1).getStringCellValue().equals(ResourceConfigLoader.getStringFromExportMsg("deploy.params.export.true"))) continue;
            components.add(currentRow.getCell(0).getStringCellValue());
        }
        return CollectionUtils.isEmpty(components) ? "" : String.join((CharSequence)",", components);
    }

    private static int getTemplateHeaderStartRowNum(Sheet sheet, String headerTitle) {
        int totalRowNum = sheet.getLastRowNum();
        log.info("match {} in {} rows at {} sheet", new Object[]{headerTitle, totalRowNum, sheet.getSheetName()});
        for (int rowCount = 0; rowCount <= totalRowNum; ++rowCount) {
            String title = Optional.ofNullable(sheet.getRow(rowCount)).map(row -> row.getCell(0)).map(ImportParametersExcelUtils::getStringFromDiffTypeCell).orElse("");
            if (!headerTitle.equals(title)) continue;
            return rowCount;
        }
        log.warn("can't match target {} title", (Object)headerTitle);
        return -1;
    }

    private static List<Map<String, String>> parseSubTableByHeader(Sheet sheet, int headerRowNum, int dataEndNum, int dataParseLimit) {
        if (ImportParametersExcelUtils.hasNegativeNumber(headerRowNum, dataEndNum)) {
            return Collections.emptyList();
        }
        int dataStartRowNum = headerRowNum + 1;
        int rowLimit = dataParseLimit < 0 ? Integer.MAX_VALUE : dataParseLimit;
        int dataRowNum = Math.min(dataEndNum - dataStartRowNum + 1, rowLimit);
        log.info("header row index:{};data end row index:{};data row total num:{}", new Object[]{headerRowNum, dataEndNum, dataRowNum});
        ArrayList<Map<String, String>> paramData = new ArrayList<Map<String, String>>();
        Row headerRow = sheet.getRow(headerRowNum);
        for (int currentRowNum = 0; currentRowNum < dataRowNum; ++currentRowNum) {
            Row dataRow = sheet.getRow(dataStartRowNum + currentRowNum);
            if (ImportParametersExcelUtils.isEmptyRow(dataRow)) {
                log.warn("current row {} is empty,skip parse", (Object)(dataStartRowNum + currentRowNum));
                continue;
            }
            paramData.add(ImportParametersExcelUtils.parseSingleRowByHeader(headerRow, dataRow));
        }
        return paramData;
    }

    public static Map<String, String> parseColSubTableByHeader(Sheet sheet, String headerName) {
        Optional<ExcelMergeCellArea> subTableArea = ExcelCommonUtils.getMergeCellPositionByCellValue(sheet, headerName);
        if (!subTableArea.isPresent()) {
            log.error("{} param area not exists", (Object)headerName);
            return new HashMap<String, String>();
        }
        int headerCol = subTableArea.get().getLastCol() + 1;
        int valueCol = subTableArea.get().getFirstCol() + 2;
        int startRow = subTableArea.get().getFirstRow();
        int endRow = subTableArea.get().getLastRow();
        log.info("start parse [{}] sub table,header col:[{}],value col:[{}],from [{}] row to [{}] row", new Object[]{headerName, headerCol, valueCol, startRow, endRow});
        return ImportParametersExcelUtils.parseColSubTableByPosition(sheet, headerCol, valueCol, startRow, endRow);
    }

    private static Map<String, String> parseColSubTableByPosition(Sheet sheet, int headerCol, int dataCol, int startRow, int endRow) {
        HashMap<String, String> parseData = new HashMap<String, String>();
        for (int row = startRow; row <= Math.min(sheet.getLastRowNum(), endRow); ++row) {
            String header = Optional.ofNullable(sheet.getRow(row).getCell(headerCol)).map(ImportParametersExcelUtils::getStringFromDiffTypeCell).orElse("");
            if (StringUtils.isEmpty((CharSequence)header)) continue;
            String data = Optional.ofNullable(sheet.getRow(row).getCell(dataCol)).map(ImportParametersExcelUtils::getStringFromDiffTypeCell).orElse("");
            parseData.put(header, data);
            VerifyContext.getInstance().parseVerifiers(sheet, row, dataCol, data);
        }
        return parseData;
    }

    private static Map<String, String> parseSingleRowByHeader(Row headerRow, Row dataRow) {
        HashMap<String, String> parseData = new HashMap<String, String>();
        int totalCol = headerRow.getLastCellNum();
        for (int col = 0; col < totalCol; ++col) {
            String headerCell = Optional.ofNullable(headerRow.getCell(col)).map(ImportParametersExcelUtils::getStringFromDiffTypeCell).orElse("");
            if (StringUtils.isEmpty((CharSequence)headerCell)) continue;
            int currentCol = col;
            String data = Optional.ofNullable(dataRow).map(row -> row.getCell(currentCol)).map(ImportParametersExcelUtils::getStringFromDiffTypeCell).orElse("");
            parseData.put(headerCell, data);
        }
        return parseData;
    }

    private static DeployParamsData emptyDeployData() {
        return DeployParamsData.builder().fcBaseInfos(Collections.emptyMap()).vrmExportInfos(Collections.emptyMap()).fcCommonInfos(Collections.emptyMap()).ntpTimeInfos(Collections.emptyMap()).backupInfos(Collections.emptyMap()).fcHostExportInfos(Collections.emptyList()).dmeExportInfos(Collections.emptyMap()).ultraExportInfos(Collections.emptyMap()).eBackupExportInfos(Collections.emptyMap()).eBackupVmExportInfos(Collections.emptyList()).eBackupPlaneExportInfos(Collections.emptyMap()).build();
    }

    private static boolean isEmptyRow(Row row) {
        if (row == null) {
            return true;
        }
        return IntStream.range(0, row.getLastCellNum()).mapToObj(arg_0 -> ((Row)row).getCell(arg_0)).allMatch(cell -> Objects.isNull(cell) || StringUtils.isEmpty((CharSequence)ImportParametersExcelUtils.getStringFromDiffTypeCell(cell)));
    }

    private static boolean hasNegativeNumber(Integer ... nums) {
        return Arrays.stream(nums).anyMatch(num -> num < 0);
    }

    private static String getStringFromDiffTypeCell(Cell cell) {
        CellType cellType = cell.getCellType();
        if (cellType == CellType.STRING) {
            return StringUtils.trim((String)cell.getStringCellValue());
        }
        DataFormatter formatter = new DataFormatter();
        return StringUtils.trim((String)formatter.formatCellValue(cell));
    }

    private ImportParametersExcelUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

