/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.export.annotation.ExportField;
import com.huawei.yinglong.virtualization.deploy.entity.export.edme.DeployDmeParamsEntity;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImportParametersParseUtils {
    private static final Logger log = LoggerFactory.getLogger(ImportParametersParseUtils.class);

    public static void transferMapFromImportExcel(Map<String, String> map, Object entity) {
        Arrays.stream(entity.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(ExportField.class)).peek(field -> field.setAccessible(true)).filter(field -> StringUtils.isNotEmpty((CharSequence)field.getAnnotation(ExportField.class).tableHeader())).forEach(field -> ImportParametersParseUtils.transferContent(map, entity, field));
    }

    private static void transferContent(Map<String, String> map, Object entity, Field field) {
        String keyByMsg;
        String header = ResourceConfigLoader.getStringFromExportHeaderTemplate(field.getAnnotation(ExportField.class).tableHeader());
        String value = map.getOrDefault(header, "");
        String description = field.getAnnotation(ExportField.class).description();
        if (StringUtils.isNotEmpty((CharSequence)description) && !StringUtils.isEmpty((CharSequence)(keyByMsg = ResourceConfigLoader.getExportKeyByMsg(value)))) {
            String[] split = keyByMsg.split("\\.");
            value = split[split.length - 1];
        }
        try {
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                field.set(entity, Boolean.parseBoolean(value));
            } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                field.set(entity, NumberUtils.toInt((String)value, (int)0));
            } else if (field.getType() == String.class) {
                if (StringUtils.isEmpty((CharSequence)value)) {
                    value = field.getAnnotation(ExportField.class).defaultValue();
                }
                field.set(entity, value);
            } else {
                field.set(entity, value);
            }
        }
        catch (IllegalAccessException exception) {
            log.error("parse error", (Throwable)exception);
        }
    }

    public static Map<String, String> transferDmeMap(DeployDmeParamsEntity paramsEntity) {
        HashMap<String, String> dmeParams = new HashMap<String, String>();
        Arrays.stream(paramsEntity.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(ExportField.class)).filter(field -> StringUtils.isNotEmpty((CharSequence)field.getAnnotation(ExportField.class).mapping())).peek(field -> field.setAccessible(true)).forEach(field -> ImportParametersParseUtils.transferSingleDmeParamPair(paramsEntity, dmeParams, field));
        return dmeParams;
    }

    private static void transferSingleDmeParamPair(DeployDmeParamsEntity paramsEntity, Map<String, String> dmeParams, Field field) {
        try {
            String fieldValue = Objects.isNull(field.get(paramsEntity)) ? "" : String.valueOf(field.get(paramsEntity));
            dmeParams.put(field.getAnnotation(ExportField.class).mapping(), fieldValue);
        }
        catch (IllegalAccessException exception) {
            log.error("set dme params pair {} error", (Object)field.getName(), (Object)exception);
        }
    }

    private ImportParametersParseUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

