/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final int PING_DEFAULT_TIMEOUT_MS = 1000;

    public static boolean checkNetworkRangeValid(String ip, String mask, String gateway) {
        byte[] ipValue = IpUtils.textToNumericFormatV4(ip);
        byte[] maskValue = IpUtils.textToNumericFormatV4(mask);
        byte[] gatewayValue = IpUtils.textToNumericFormatV4(gateway);
        if (IpUtils.isByteArrayEmpty(ipValue) || IpUtils.isByteArrayEmpty(maskValue) || IpUtils.isByteArrayEmpty(gatewayValue)) {
            return false;
        }
        for (int i = 0; i < ipValue.length && i < maskValue.length && i < gatewayValue.length; ++i) {
            if ((ipValue[i] & maskValue[i]) == (gatewayValue[i] & maskValue[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isReachable(String ip) {
        return IpUtils.isReachable(ip, 1000);
    }

    public static boolean isReachable(String ip, int timeoutMs) {
        try {
            if (StringUtils.isEmpty((CharSequence)ip)) {
                return false;
            }
            return InetAddress.getByName(ip).isReachable(timeoutMs);
        }
        catch (IOException e) {
            log.error("check ip {} reachable failed.", (Object)ip);
            return false;
        }
    }

    private static byte[] textToNumericFormatV4(String ip) {
        try {
            if (StringUtils.isEmpty((CharSequence)ip)) {
                return new byte[0];
            }
            return InetAddress.getByName(ip).getAddress();
        }
        catch (IOException e) {
            log.error("ip text to number failed.", (Throwable)e);
            return new byte[0];
        }
    }

    private static boolean isByteArrayEmpty(byte[] value) {
        return Objects.isNull(value) || value.length == 0;
    }

    private IpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

