/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.FusionComputeInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.CnaInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamNodeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamVrmVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.IpUtils;
import com.huawei.yinglong.virtualization.deploy.utils.VmParamUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public final class ParamUnionValidateUtils {
    public static Map<String, List<String>> validateUnionParams(VirtualizationDeployProcessConfig processConfig) {
        LinkedList<ParamItem> ipItems = new LinkedList<ParamItem>();
        LinkedList<ParamItem> fcItems = new LinkedList<ParamItem>();
        InsParamVrmVo vrmVo = null;
        boolean hasFcDeploy = InstallModeEnum.containFcDeployScene(processConfig.getInstallMode());
        boolean hasRunTask = MapUtils.isNotEmpty(processConfig.getPreCheckResult());
        if (hasFcDeploy && CollectionUtils.isNotEmpty(processConfig.getDeployFc())) {
            FcInstallParamsVo fcInstallParamsVo = processConfig.getDeployFc().get(0);
            ParamUnionValidateUtils.buildFusionComputeCheckItems(fcInstallParamsVo, ipItems, fcItems);
            vrmVo = Optional.ofNullable(fcInstallParamsVo).map(FcInstallParamsVo::getVrm).map(VrmInstallParamsVo::getVrm).orElse(null);
        }
        HashMap<String, List<String>> validResults = new HashMap<String, List<String>>();
        if (InstallModeEnum.containUltraVRdeployScene(processConfig.getInstallMode()) && Objects.nonNull(processConfig.getUltraVRParams())) {
            List<String> ultraVRValues = ParamUnionValidateUtils.validateUltraVRValues(ipItems, fcItems, vrmVo, processConfig.getUltraVRParams());
            Optional.ofNullable(processConfig.getUltraVRParams().getFusionComputeInfo()).map(FusionComputeInfo::getFloatIp).map(fcIp -> ParamUnionValidateUtils.checkFcIpReachStatus(fcIp, !hasFcDeploy, hasRunTask, "component.name.ultraVR")).filter(StringUtils::isNotEmpty).ifPresent(ultraVRValues::add);
            validResults.put("ultraVR", ultraVRValues);
        }
        if (InstallModeEnum.containEbackupDeployScene(processConfig.getInstallMode()) && Objects.nonNull(processConfig.getEbackupParams())) {
            List<String> ebackupValues = ParamUnionValidateUtils.validateEbackupValues(ipItems, fcItems, vrmVo, processConfig.getEbackupParams());
            Optional.ofNullable(processConfig.getEbackupParams().getFusionComputeInfo()).map(FusionComputeInfo::getFloatIp).map(fcIp -> ParamUnionValidateUtils.checkFcIpReachStatus(fcIp, !hasFcDeploy, hasRunTask, "component.name.eBackup")).filter(StringUtils::isNotEmpty).ifPresent(ebackupValues::add);
            validResults.put("eBackup", ebackupValues);
        }
        if (InstallModeEnum.containDmeDeployScene(processConfig.getInstallMode()) && MapUtils.isNotEmpty(processConfig.getDmeData())) {
            List<String> dmeValues = ParamUnionValidateUtils.validateDmeValues(ipItems, fcItems, vrmVo, processConfig.getDmeData());
            Optional.ofNullable(processConfig.getDmeData().get("vm_fc_url")).map(fcIp -> ParamUnionValidateUtils.checkFcIpReachStatus(fcIp, !hasFcDeploy, hasRunTask, "component.name.dme")).filter(StringUtils::isNotEmpty).ifPresent(dmeValues::add);
            validResults.put("dme", dmeValues);
        }
        return validResults;
    }

    private static String checkFcIpReachStatus(String fcIp, boolean isRequiredReach, boolean hasRunTask, String componentKey) {
        if (StringUtils.isEmpty((CharSequence)fcIp)) {
            return "";
        }
        boolean isReachable = IpUtils.isReachable(fcIp);
        String errorKey = "";
        if (isRequiredReach && !isReachable) {
            errorKey = "param.union.fc.manage.ip.is.unreachable";
        }
        if (!isRequiredReach && !hasRunTask && isReachable) {
            errorKey = "param.union.fc.manage.ip.is.reachable";
        }
        if (StringUtils.isNotEmpty((CharSequence)errorKey)) {
            return ParamUnionValidateUtils.formatErrorMsg(errorKey, ResourceConfigLoader.getStringFromExportHeaderTemplate(componentKey), ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.common.fc.ip"));
        }
        return "";
    }

    private static List<String> validateUltraVRValues(List<ParamItem> ipItems, List<ParamItem> fcItems, InsParamVrmVo vrmVo, UltraVRParams ultraVRParams) {
        List<String> validResults = ParamUnionValidateUtils.validIpRepeated(ipItems, Collections.singletonList(ParamItem.buildUltraVRItem("deploy.template.header.ultravr.vm.ip", ultraVRParams.getIp())));
        Optional.ofNullable(ultraVRParams.getFusionComputeInfo()).ifPresent(fcInfo -> validResults.addAll(ParamUnionValidateUtils.validFusionComputeSameValues(fcItems, ParamItem::buildUltraVRItem, fcInfo)));
        Optional.ofNullable(vrmVo).filter(vrm -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{vrm.getNetmask(), vrm.getGateway()})).filter(vrm -> !IpUtils.checkNetworkRangeValid(ultraVRParams.getIp(), vrm.getNetmask(), vrm.getGateway())).ifPresent(vrm -> validResults.add(ResourceConfigLoader.getErrorMessage("param.ultraVR.manage.ip.notin.fc.segment")));
        return validResults;
    }

    private static List<String> validateEbackupValues(List<ParamItem> ipItems, List<ParamItem> fcItems, InsParamVrmVo vrmVo, EbackupParams ebackupParams) {
        LinkedList<ParamItem> eBackupIpItems = new LinkedList<ParamItem>();
        eBackupIpItems.addAll(ParamUnionValidateUtils.findEbackupPlaneManageIp(ebackupParams, "deploy.ebackup.manage.plane.ip.valid", EbackupVmInfo::getManagePlane, EbackupVmPlane::getManageIp));
        eBackupIpItems.addAll(ParamUnionValidateUtils.findEbackupPlaneManageIp(ebackupParams, "deploy.ebackup.inner.plane.ip.valid", EbackupVmInfo::getInnerPlane, EbackupVmPlane::getManageIp));
        eBackupIpItems.addAll(ParamUnionValidateUtils.findEbackupPlaneManageIp(ebackupParams, "deploy.ebackup.inner.plane.float.ip.valid", EbackupVmInfo::getInnerPlane, EbackupVmPlane::getInnerFloatIp));
        eBackupIpItems.addAll(ParamUnionValidateUtils.findEbackupPlaneManageIp(ebackupParams, "deploy.ebackup.production.plane.ip.valid", EbackupVmInfo::getProductionPlane, EbackupVmPlane::getManageIp));
        eBackupIpItems.addAll(ParamUnionValidateUtils.findEbackupPlaneManageIp(ebackupParams, "deploy.ebackup.backup.plane.ip.valid", EbackupVmInfo::getBackupPlane, EbackupVmPlane::getManageIp));
        List<String> validResults = ParamUnionValidateUtils.validIpRepeated(ipItems, eBackupIpItems);
        Optional.ofNullable(ebackupParams.getFusionComputeInfo()).ifPresent(fcInfo -> validResults.addAll(ParamUnionValidateUtils.validFusionComputeSameValues(fcItems, ParamItem::buildEbackupItem, fcInfo)));
        Optional.ofNullable(vrmVo).filter(vrm -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{vrm.getNetmask(), vrm.getGateway()})).ifPresent(vrm -> validResults.addAll(ParamUnionValidateUtils.parseManageIpSegment(eBackupIpItems, vrm)));
        return validResults;
    }

    private static List<String> parseManageIpSegment(List<ParamItem> eBackupIpItems, InsParamVrmVo vrm) {
        return eBackupIpItems.stream().filter(item -> !IpUtils.checkNetworkRangeValid(item.getParamValue(), vrm.getNetmask(), vrm.getGateway())).map(item -> ParamUnionValidateUtils.formatErrorMsg("param.eBackup.manage.ip.notin.fc.segment", item.getParamName())).collect(Collectors.toList());
    }

    private static List<ParamItem> findEbackupPlaneManageIp(EbackupParams ebackupParams, String planeNameKey, Function<EbackupVmInfo, EbackupVmPlane> function, Function<EbackupVmPlane, String> ipFunction) {
        LinkedList<ParamItem> eBackupIpItems = new LinkedList<ParamItem>();
        ListUtils.emptyIfNull((List)ebackupParams.getEbackupVmInfo()).stream().filter(vmInfo -> Objects.nonNull(function.apply((EbackupVmInfo)vmInfo))).filter(vmInfo -> Objects.equals("managePortgroup", ((EbackupVmPlane)function.apply((EbackupVmInfo)vmInfo)).getPortGroupName())).forEach(vmInfo -> eBackupIpItems.add(ParamItem.buildSpecialItem("component.name.eBackup", ParamUnionValidateUtils.formatErrorMsg(planeNameKey, vmInfo.getName()), (String)ipFunction.apply((EbackupVmPlane)function.apply((EbackupVmInfo)vmInfo)))));
        return eBackupIpItems;
    }

    private static List<String> validIpRepeated(List<ParamItem> ipItems, List<ParamItem> checkIpItems) {
        LinkedList<String> validResults = new LinkedList<String>();
        checkIpItems.stream().filter(checkItem -> StringUtils.isNotEmpty((CharSequence)checkItem.getParamValue())).forEach(checkItem -> ParamUnionValidateUtils.checkIpRepeatedWithItem(ipItems, validResults, checkItem));
        ipItems.addAll(checkIpItems);
        return validResults;
    }

    private static void checkIpRepeatedWithItem(List<ParamItem> ipItems, List<String> validResults, ParamItem checkItem) {
        validResults.addAll(ipItems.stream().filter(ipItem -> StringUtils.isNotEmpty((CharSequence)ipItem.getParamValue())).filter(ipItem -> Objects.equals(checkItem.getParamValue(), ipItem.getParamValue())).map(ipItem -> ParamUnionValidateUtils.buildRepeatedErrorMsg(checkItem, ipItem)).collect(Collectors.toList()));
    }

    private static List<String> validFusionComputeSameValues(List<ParamItem> fcItems, ParamItemBuilder builder, FusionComputeInfo fcInfo) {
        LinkedList<String> validResults = new LinkedList<String>();
        LinkedList<ParamItem> componentFcItems = new LinkedList<ParamItem>();
        componentFcItems.add(builder.build("fc.ip", "deploy.template.header.common.fc.ip", fcInfo.getFloatIp()));
        componentFcItems.add(builder.build("fc.user", "deploy.template.header.common.fc.user", fcInfo.getUserName()));
        componentFcItems.add(builder.build("fc.pwd", "deploy.template.header.common.fc.pwd", fcInfo.getPassword()));
        componentFcItems.stream().filter(checkItem -> StringUtils.isNotEmpty((CharSequence)checkItem.getParamValue())).forEach(checkItem -> ParamUnionValidateUtils.checkFusionComputeSameValueWithItem(fcItems, validResults, checkItem));
        fcItems.addAll(componentFcItems);
        return validResults;
    }

    private static void checkFusionComputeSameValueWithItem(List<ParamItem> fcItems, List<String> validResults, ParamItem checkItem) {
        fcItems.stream().filter(ipItem -> StringUtils.isNotEmpty((CharSequence)ipItem.getParamValue())).filter(ipItem -> Objects.equals(checkItem.getKey(), ipItem.getKey())).filter(ipItem -> !Objects.equals(checkItem.getParamValue(), ipItem.getParamValue())).findFirst().map(ipItem -> ParamUnionValidateUtils.buildNotSameErrorMsg(checkItem, ipItem)).ifPresent(validResults::add);
    }

    private static List<String> validateDmeValues(List<ParamItem> ipItems, List<ParamItem> fcItems, InsParamVrmVo vrmVo, Map<String, String> dmeParams) {
        LinkedList<ParamItem> dmeIpItems = new LinkedList<ParamItem>();
        if (VmParamUtils.isAutoCreateVm(dmeParams)) {
            dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.master.ip", dmeParams.getOrDefault("DMEData_ip1", "")));
            dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.slave1.ip", dmeParams.getOrDefault("DMEData_ip2", "")));
            dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.slave2.ip", dmeParams.getOrDefault("DMEData_ip3", "")));
            dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.tenant.node1.ip", dmeParams.getOrDefault("DMEData_tenant_ip1", "")));
            dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.tenant.node2.ip", dmeParams.getOrDefault("DMEData_tenant_ip2", "")));
        }
        dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.float.manage.ip", dmeParams.getOrDefault("DMEData_float_ip", "")));
        dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.southbound.flout.ip", dmeParams.getOrDefault("DMEData_lvs_ip", "")));
        dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.tenant.sc.float.ip", dmeParams.getOrDefault("DMEData_tenant_float_ip", "")));
        dmeIpItems.add(ParamItem.buildDmeItem("deploy.template.header.edme.tenant.sc.glb.ip", dmeParams.getOrDefault("DMEData_tenant_glb_dip", "")));
        List<String> validResults = ParamUnionValidateUtils.validIpRepeated(ipItems, dmeIpItems);
        String manageIp = dmeParams.getOrDefault("vm_fc_url", "");
        String userName = dmeParams.getOrDefault("vm_fc_user", "");
        String userPwd = dmeParams.getOrDefault("vm_fc_password", "");
        validResults.addAll(ParamUnionValidateUtils.validFusionComputeSameValues(fcItems, ParamItem::buildDmeItem, FusionComputeInfo.builder().floatIp(manageIp).userName(userName).password(userPwd).build()));
        if (Objects.equals(dmeParams.get("DMEData_sm_option"), "YES") && vrmVo != null && !Objects.equals(vrmVo.getCipherMode(), "sm") && Objects.equals(dmeParams.get("DMEData_kms_option"), "YES")) {
            validResults.add(ParamUnionValidateUtils.formatErrorMsg("param.dme.kms.option.error", new String[0]));
        }
        return validResults;
    }

    private static void buildFusionComputeCheckItems(FcInstallParamsVo fcParamVo, List<ParamItem> ipItems, List<ParamItem> fcItems) {
        Optional.ofNullable(fcParamVo).map(FcInstallParamsVo::getVrm).map(VrmInstallParamsVo::getVrm).ifPresent(vrmVo -> ParamUnionValidateUtils.buildFusionComputeVrmItems(ipItems, fcItems, vrmVo));
        Optional.ofNullable(fcParamVo).map(FcInstallParamsVo::getCna).map(CnaInstallParamsVo::getNodes).filter(CollectionUtils::isNotEmpty).ifPresent(nodes -> ParamUnionValidateUtils.buildFusionComputeCnaItems(ipItems, nodes));
    }

    private static void buildFusionComputeCnaItems(List<ParamItem> ipItems, List<InsParamNodeVo> nodes) {
        ipItems.addAll(nodes.stream().map(node -> ParamItem.buildSpecialItem("component.name.fc", ParamUnionValidateUtils.formatErrorMsg("deploy.template.header.fc.host.ip.valid", node.getHostName()), node.getHostIp())).collect(Collectors.toList()));
    }

    private static void buildFusionComputeVrmItems(List<ParamItem> ipItems, List<ParamItem> fcItems, InsParamVrmVo vrmVo) {
        String manageIp = Objects.equals(vrmVo.getMode(), "double") ? vrmVo.getFloatIp() : vrmVo.getMasterIp();
        fcItems.add(ParamItem.buildFusionComputeItem("fc.ip", "param.fusioncompute.manage.ip", manageIp));
        String userName = Objects.equals(vrmVo.getUserMode(), "three") ? "sysadmin" : "admin";
        fcItems.add(ParamItem.buildFusionComputeItem("fc.user", "deploy.template.header.common.fc.user", userName));
        String userPwd = Objects.equals(vrmVo.getUserMode(), "three") ? vrmVo.getSysAdminPwd() : vrmVo.getAdminPwd();
        fcItems.add(ParamItem.buildFusionComputeItem("fc.pwd", "deploy.template.header.common.fc.pwd", userPwd));
        ipItems.add(ParamItem.buildFusionComputeItem("deploy.template.header.fc.vrm.master.ip", vrmVo.getMasterIp()));
        ipItems.add(ParamItem.buildFusionComputeItem("deploy.template.header.fc.vrm.slave.ip", vrmVo.getSlaveIp()));
        ipItems.add(ParamItem.buildFusionComputeItem("deploy.template.header.fc.vrm.float.ip", vrmVo.getFloatIp()));
    }

    private static String buildRepeatedErrorMsg(ParamItem p1, ParamItem p2) {
        return ParamUnionValidateUtils.formatErrorMsg("param.union.repeated.error", p1.getComponentName(), p1.getParamName(), p2.getComponentName(), p2.getParamName());
    }

    private static String buildNotSameErrorMsg(ParamItem p1, ParamItem p2) {
        return ParamUnionValidateUtils.formatErrorMsg("param.union.same.error", p1.getComponentName(), p1.getParamName(), p2.getComponentName(), p2.getParamName());
    }

    private static String formatErrorMsg(String key, String ... params) {
        return String.format(Locale.ROOT, ResourceConfigLoader.getErrorMessage(key), (Object[])params);
    }

    private ParamUnionValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    static interface ParamItemBuilder {
        public ParamItem build(String var1, String var2, String var3);
    }

    private static class ParamItem {
        private String key;
        private String componentName;
        private String paramName;
        private String paramValue;

        static ParamItem buildFusionComputeItem(String key, String nameKey, String value) {
            return ParamItem.buildItem(key, "component.name.fc", nameKey, value);
        }

        static ParamItem buildFusionComputeItem(String nameKey, String value) {
            return ParamItem.buildFusionComputeItem(nameKey, nameKey, value);
        }

        static ParamItem buildUltraVRItem(String key, String nameKey, String value) {
            return ParamItem.buildItem(key, "component.name.ultraVR", nameKey, value);
        }

        static ParamItem buildUltraVRItem(String nameKey, String value) {
            return ParamItem.buildUltraVRItem(nameKey, nameKey, value);
        }

        static ParamItem buildEbackupItem(String key, String nameKey, String value) {
            return ParamItem.buildItem(key, "component.name.eBackup", nameKey, value);
        }

        static ParamItem buildDmeItem(String key, String nameKey, String value) {
            return ParamItem.buildItem(key, "component.name.dme", nameKey, value);
        }

        static ParamItem buildDmeItem(String nameKey, String value) {
            return ParamItem.buildDmeItem(nameKey, nameKey, value);
        }

        static ParamItem buildSpecialItem(String componentKey, String paramName, String value) {
            return ParamItem.buildSpecialItem(paramName, componentKey, paramName, value);
        }

        static ParamItem buildSpecialItem(String key, String componentKey, String paramName, String value) {
            return ParamItem.builder().key(key).componentName(ResourceConfigLoader.getStringFromExportHeaderTemplate(componentKey)).paramName(paramName).paramValue(value).build();
        }

        private static ParamItem buildItem(String key, String componentKey, String nameKey, String value) {
            return ParamItem.buildSpecialItem(key, componentKey, ResourceConfigLoader.getStringFromExportHeaderTemplate(nameKey), value);
        }

        ParamItem(String key, String componentName, String paramName, String paramValue) {
            this.key = key;
            this.componentName = componentName;
            this.paramName = paramName;
            this.paramValue = paramValue;
        }

        public static ParamItemBuilder builder() {
            return new ParamItemBuilder();
        }

        public String getKey() {
            return this.key;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getParamName() {
            return this.paramName;
        }

        public String getParamValue() {
            return this.paramValue;
        }

        public static class ParamItemBuilder {
            private String key;
            private String componentName;
            private String paramName;
            private String paramValue;

            ParamItemBuilder() {
            }

            public ParamItemBuilder key(String key) {
                this.key = key;
                return this;
            }

            public ParamItemBuilder componentName(String componentName) {
                this.componentName = componentName;
                return this;
            }

            public ParamItemBuilder paramName(String paramName) {
                this.paramName = paramName;
                return this;
            }

            public ParamItemBuilder paramValue(String paramValue) {
                this.paramValue = paramValue;
                return this;
            }

            public ParamItem build() {
                return new ParamItem(this.key, this.componentName, this.paramName, this.paramValue);
            }

            public String toString() {
                return "ParamUnionValidateUtils.ParamItem.ParamItemBuilder(key=" + this.key + ", componentName=" + this.componentName + ", paramName=" + this.paramName + ", paramValue=" + this.paramValue + ")";
            }
        }
    }
}

