/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ToolConfigUtils.class);
    private static final String TOOL_CONFIG_PATH = "/tool-config.ini";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<SubnodeConfiguration> getSection(String section) {
        try (InputStreamReader reader = new InputStreamReader(ToolConfigUtils.class.getResourceAsStream(TOOL_CONFIG_PATH), StandardCharsets.UTF_8);){
            INIConfiguration config = new INIConfiguration();
            config.read((Reader)reader);
            Optional<SubnodeConfiguration> optional = Optional.ofNullable(config.getSection(section));
            return optional;
        }
        catch (IOException | ConfigurationException e) {
            log.error("read tool config file failed, section : {}.", (Object)section, (Object)e);
            return Optional.empty();
        }
    }

    public static Map<String, String> get(String section) {
        Optional<SubnodeConfiguration> optionalSection = ToolConfigUtils.getSection(section);
        if (!optionalSection.isPresent() || optionalSection.get().isEmpty()) {
            log.warn("read tool config not find section : {}.", (Object)section);
            return Collections.emptyMap();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(optionalSection.get().getKeys(), 0), false).collect(Collectors.toMap(key -> key.replace("..", "."), key -> ((SubnodeConfiguration)optionalSection.get()).getString(key)));
    }

    private ToolConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

