/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public final class ToolEnvUtils {
    private static ToolEnvEnum currentToolEnvEnum;

    public static Optional<String> getEnv(String name) {
        return Optional.ofNullable(System.getenv(name));
    }

    public static JSONObject getEnvObj(String name) {
        return JSON.parseObject((String)ToolEnvUtils.getEnv(name).orElse("{}"));
    }

    public static List<String> getSupportComponents() {
        List<String> supportComponents = ToolEnvUtils.getSupportSceneArgs("typeList");
        if (CollectionUtils.isEmpty(supportComponents)) {
            return Arrays.stream(InstallModeEnum.values()).filter(InstallModeEnum::isDcsMode).map(InstallModeEnum::getComponent).distinct().collect(Collectors.toList());
        }
        return supportComponents;
    }

    public static ToolEnvEnum getToolFromValue() {
        if (Objects.nonNull((Object)currentToolEnvEnum)) {
            return currentToolEnvEnum;
        }
        List<String> toolFroms = ToolEnvUtils.getSupportSceneArgs("toolFrom");
        currentToolEnvEnum = CollectionUtils.isEmpty(toolFroms) ? ToolEnvEnum.DSC_DEPLOY : ToolEnvEnum.getEnumByValue(toolFroms.get(0));
        return currentToolEnvEnum;
    }

    public static List<String> getSupportSceneArgs(String key) {
        return Optional.ofNullable(ToolEnvUtils.getEnvObj("jsonSceneArgsList")).filter(json -> json.containsKey((Object)key)).map(json -> json.getString(key)).map(value -> Arrays.asList(value.split(","))).orElse(Collections.emptyList());
    }

    public static boolean isA3000Expansion() {
        return ToolEnvEnum.A3000_EXPANSION.equals((Object)ToolEnvUtils.getToolFromValue());
    }

    public static boolean isA3000Deploy() {
        return ToolEnvEnum.A3000_DEPLOY.equals((Object)ToolEnvUtils.getToolFromValue());
    }

    private ToolEnvUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

