/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.river.deploy.virtualization.deployvm.entity.FcInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.DcsccsPublicDomainInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.ExtraIpConfigParam;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmNode;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmParam;
import com.huawei.yinglong.virtualization.deploy.constant.VmNodeType;
import com.huawei.yinglong.virtualization.deploy.entity.vo.FcScenario;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmParamUtils {
    private static final Logger log = LoggerFactory.getLogger(VmParamUtils.class);

    public static boolean isAutoCreateVm(Map<String, String> dmeDatas) {
        String autoCreate = MapUtils.emptyIfNull(dmeDatas).getOrDefault("vm_auto_create", "false");
        return Objects.equals("true", autoCreate);
    }

    public static VmParam createVmParam(Map<String, String> dmeDatas) {
        return VmParam.builder().fcInfo(FcInfo.builder().user(dmeDatas.getOrDefault("vm_fc_user", "")).url(dmeDatas.getOrDefault("vm_fc_url", "")).password(dmeDatas.getOrDefault("vm_fc_password", "")).userType(Integer.valueOf(FcScenario.of(dmeDatas.get("vm_fc_scenario")) == FcScenario.CONVERGED ? 2 : 0)).build()).netDevice(dmeDatas.getOrDefault("DMEData_nic", "enp4s0")).imagePath(dmeDatas.getOrDefault("DMEData_package_path", "")).arch(dmeDatas.getOrDefault("DMEData_CPU_architecture", "X86")).netMask(dmeDatas.getOrDefault("vm_netMask", "")).gateway(dmeDatas.getOrDefault("vm_gateway", "")).vmNode(VmParamUtils.buildVmNodes(dmeDatas)).build();
    }

    private static List<VmNode> buildVmNodes(Map<String, String> dmeDatas) {
        List<VmNode> vmNodes = VmParamUtils.buildNormalVmNodes(dmeDatas);
        if (Objects.equals("YES", dmeDatas.getOrDefault("DMEData_deploy_tenant", "NO"))) {
            log.info("need deploy tenant vm nodes");
            vmNodes.addAll(VmParamUtils.buildTenantVmNodes(dmeDatas));
            boolean isDeployCcs = Objects.equals("YES", dmeDatas.getOrDefault("DMEData_deploy_ccs", "NO")) && Objects.equals("type2", dmeDatas.getOrDefault("DMEData_sdn_scene", "type3"));
            log.info("need deploy container vm nodes");
            vmNodes.addAll(VmParamUtils.buildContainerTenantVmNodes(dmeDatas, isDeployCcs));
            boolean isDeployDcsas = Objects.equals("YES", dmeDatas.getOrDefault("DMEData_deploy_dcsas", "NO"));
            log.info("need deploy dcsas vm nodes");
            vmNodes.addAll(VmParamUtils.buildAutoScalingVmNodes(dmeDatas, isDeployDcsas));
        }
        return vmNodes;
    }

    private static List<VmNode> buildAutoScalingVmNodes(Map<String, String> dmeDatas, boolean isDeploy) {
        return IntStream.range(1, 3).mapToObj(String::valueOf).map(idx -> VmNode.builder().isDeploy(isDeploy).ip((String)dmeDatas.get("DMEData_dcsas_ip" + idx)).name((String)dmeDatas.get("DMEData_dcsas_hostname" + idx)).rootPassword((String)dmeDatas.get("DMEData_dcsas_password" + idx)).cnaName((String)dmeDatas.get("dcs_cna_name" + idx)).datastoreSystemName((String)dmeDatas.get("dcsas_disk_system_name" + idx)).datastoreDataName((String)dmeDatas.get("dcsas_disk_data_name" + idx)).sizeGb(Integer.valueOf(NumberUtils.toInt((String)((String)dmeDatas.get("dcs_size_gb" + idx))))).type(Integer.valueOf(VmNodeType.DCSAS.getType())).managementLevel((String)dmeDatas.get("DMEData_deploy_scale")).build()).collect(Collectors.toList());
    }

    private static List<VmNode> buildContainerTenantVmNodes(Map<String, String> dmeDatas, boolean isDeploy) {
        return IntStream.range(1, 3).mapToObj(String::valueOf).map(idx -> VmNode.builder().isDeploy(isDeploy).ip((String)dmeDatas.get("DMEData_ccs_ip" + idx)).name((String)dmeDatas.get("DMEData_ccs_hostname" + idx)).rootPassword((String)dmeDatas.get("DMEData_ccs_password" + idx)).cnaName((String)dmeDatas.get("ccs_cna_name" + idx)).datastoreSystemName((String)dmeDatas.get("ccs_disk_system_name" + idx)).datastoreDataName((String)dmeDatas.get("ccs_disk_data_name" + idx)).sizeGb(Integer.valueOf(NumberUtils.toInt((String)((String)dmeDatas.get("ccs_size_gb" + idx))))).type(Integer.valueOf(VmNodeType.CCS.getType())).managementLevel((String)dmeDatas.get("DMEData_deploy_scale")).dcsccsPublicDomainInfo(DcsccsPublicDomainInfo.builder().gateway((String)dmeDatas.get("ccs_domain_gateway")).bmsVipSegment((String)dmeDatas.get("ccs_domain_bms_vip_segment")).clientSegment((String)dmeDatas.get("ccs_domain_client_segment")).build()).extraIpConfigParams(Collections.singletonList(ExtraIpConfigParam.builder().ip((String)dmeDatas.get("DMEData_ccs_internal_ip" + idx)).portGroup((String)dmeDatas.get("ccs_domain_port_group")).netMask((String)dmeDatas.get("ccs_domain_mask")).build())).build()).collect(Collectors.toList());
    }

    private static List<VmNode> buildTenantVmNodes(Map<String, String> dmeDatas) {
        return IntStream.range(1, 3).mapToObj(String::valueOf).map(idx -> VmNode.builder().ip((String)dmeDatas.get("DMEData_tenant_ip" + idx)).name((String)dmeDatas.get("DMEData_tenant_hostname" + idx)).rootPassword((String)dmeDatas.get("DMEData_tenant_password" + idx)).cnaName((String)dmeDatas.get("tenant_cna_name" + idx)).datastoreSystemName((String)dmeDatas.get("tenant_disk_system_name" + idx)).datastoreDataName((String)dmeDatas.get("tenant_disk_data_name" + idx)).sizeGb(Integer.valueOf(NumberUtils.toInt((String)((String)dmeDatas.get("tenant_size_gb" + idx))))).type(Integer.valueOf(VmNodeType.TENANT.getType())).managementLevel((String)dmeDatas.get("DMEData_deploy_scale")).build()).collect(Collectors.toList());
    }

    private static List<VmNode> buildNormalVmNodes(Map<String, String> dmeDatas) {
        return IntStream.range(1, 4).mapToObj(String::valueOf).map(idx -> VmNode.builder().ip((String)dmeDatas.get("DMEData_ip" + idx)).name((String)dmeDatas.get("DMEData_hostname" + idx)).rootPassword((String)dmeDatas.get("DMEData_root_password" + idx)).cnaName((String)dmeDatas.get("vm_cna_name" + idx)).datastoreSystemName((String)dmeDatas.get("vm_disk_system_name" + idx)).datastoreDataName((String)dmeDatas.get("vm_disk_data_name" + idx)).sizeGb(Integer.valueOf(NumberUtils.toInt((String)((String)dmeDatas.get("vm_size_gb" + idx))))).type(Integer.valueOf(VmNodeType.NORMAL.getType())).managementLevel((String)dmeDatas.get("DMEData_deploy_scale")).build()).collect(Collectors.toList());
    }

    private VmParamUtils() {
    }
}

