/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.utils.XmlEnums;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);
    public static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = XmlUtils.getDocumentBuilderFactory();
    private static DocumentBuilder documentBuilder = null;
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature(XmlEnums.SECURE_PROCESSING.getResourceValue(), true);
            factory.setFeature(XmlEnums.DISALLOW_DOCTYPE_DECL.getResourceValue(), true);
            factory.setFeature(XmlEnums.EXTERNAL_GENERAL_ENTITY.getResourceValue(), false);
            factory.setFeature(XmlEnums.EXTERNAL_PARAMETER_ENTITY.getResourceValue(), false);
            factory.setFeature(XmlEnums.LOAD_EXTERNAL_DTD.getResourceValue(), false);
        }
        catch (ParserConfigurationException e) {
            log.error("Initialize document builder factory error.", (Throwable)e);
        }
        return factory;
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
    }

    @Nullable
    public static synchronized Document parseDocument(@NotNull InputStream input) {
        Document document = null;
        try {
            document = documentBuilder.parse(input);
            document.normalize();
        }
        catch (IOException | SAXException e) {
            log.error("parse xml document error.", (Throwable)e);
        }
        return document;
    }

    public static String getAttribute(Element element, String attrName, String defaultValue) {
        String attribute = element.getAttribute(attrName);
        if (StringUtils.isEmpty((CharSequence)attribute)) {
            attribute = defaultValue;
        }
        return attribute.trim();
    }

    public static Collection<Element> getChildren(Element parent, String childTagName) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (Objects.isNull(parent)) {
            return children;
        }
        Node child = parent.getFirstChild();
        while (Objects.nonNull(child)) {
            if (child instanceof Element) {
                Element element = (Element)child;
                String tagName = element.getTagName();
                if (StringUtils.isEmpty((CharSequence)childTagName) || childTagName.equals(tagName)) {
                    children.add(element);
                }
            }
            child = child.getNextSibling();
        }
        return children;
    }

    public static NodeList searchNodeByExp(Document doc, String xql) {
        NodeList nodeList = null;
        try {
            Object result = XPATH.evaluate(xql, doc, XPathConstants.NODESET);
            nodeList = (NodeList)result;
        }
        catch (XPathExpressionException e) {
            log.error("eval error," + xql, (Throwable)e);
        }
        return nodeList;
    }

    private XmlUtils() {
    }

    static {
        try {
            documentBuilder = XmlUtils.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("Build documentBuilder failed.", (Throwable)e);
        }
    }
}

