/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.a3000;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.service.verifier.NotEmptyVerifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.StrategyAttribute;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.VerifierDesc;
import com.huawei.yinglong.virtualization.deploy.utils.a3000.strategy.VerifierStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyContext {
    private static final Logger log = LoggerFactory.getLogger(VerifyContext.class);
    private static final String REPEAT_KEY_SLOT = "SLOT";
    private static final String REPEAT_KEY_CABINET_NAME = "CabinetName";
    private static final String REPEAT_KEY_DEVICE_NAME = "DevName";
    private static final VerifyContext INSTANCE = new VerifyContext();
    private final List<Verifier> verifiers = new LinkedList<Verifier>();
    private final Map<String, Set<String>> repeatDatas = new HashMap<String, Set<String>>();
    private final List<String> repeatErrorMsg = new LinkedList<String>();

    public static VerifyContext getInstance() {
        return INSTANCE;
    }

    public synchronized List<String> doVerify() {
        this.verifiers.addAll(this.checkMandatoryLocationVerifiers());
        List<String> result = this.verifiers.stream().filter(verifier -> !verifier.doVerify()).map(verifier -> String.join((CharSequence)":", verifier.getLocation(), verifier.show())).collect(Collectors.toList());
        Optional.of(this.repeatErrorMsg).filter(CollectionUtils::isNotEmpty).ifPresent(result::addAll);
        this.verifiers.clear();
        this.repeatErrorMsg.clear();
        this.repeatDatas.clear();
        return result;
    }

    public synchronized void parseVerifiers(Sheet sheet, int dataRow, int dataCol, String data) {
        List<StrategyAttribute> strategies = VerifierStrategy.getInstance().findStrategies(sheet.getSheetName(), dataRow, dataCol);
        if (CollectionUtils.isEmpty(strategies)) {
            return;
        }
        Location curLocation = Location.builder().sheetName(sheet.getSheetName()).sheetIndex(sheet.getWorkbook().getSheetIndex(sheet)).row(dataRow).column(dataCol).build();
        strategies.stream().filter(strategyAttribute -> !strategyAttribute.isInIgnoreMergeCell(curLocation.getRow())).forEach(strategyAttribute -> this.handleStrategyAttribute(sheet, data, (StrategyAttribute)strategyAttribute, curLocation));
    }

    private List<Verifier> checkMandatoryLocationVerifiers() {
        return VerifierStrategy.getInstance().getStrategyAttributeMap().entrySet().stream().flatMap(this::checkMandatoryAttributesNotInVerifiers).collect(Collectors.toList());
    }

    private Stream<Verifier> checkMandatoryAttributesNotInVerifiers(Map.Entry<String, List<StrategyAttribute>> entry) {
        return entry.getValue().stream().filter(attr -> !attr.isPermitEmpty() && attr.getVerifiers().isEmpty()).flatMap(attribute -> this.findAttributeNotInVerifiers((String)entry.getKey(), (StrategyAttribute)attribute).stream()).flatMap(attr -> this.parseAttributeNotEmptyVerifier((String)entry.getKey(), (StrategyAttribute)attr));
    }

    private List<StrategyAttribute> findAttributeNotInVerifiers(String sheetName, StrategyAttribute attribute) {
        return this.transferCompareStrategyAttribute(attribute).stream().filter(attr -> !this.checkAttributeInVerifiers(sheetName, (StrategyAttribute)attr)).collect(Collectors.toList());
    }

    private boolean checkAttributeInVerifiers(String sheetName, StrategyAttribute attribute) {
        return this.verifiers.stream().map(Verifier::getCurrentLocation).anyMatch(location -> Objects.equals(location.getSheetName(), sheetName) && attribute.locationMatch(location.getRow(), location.getColumn()));
    }

    private List<StrategyAttribute> transferCompareStrategyAttribute(StrategyAttribute attribute) {
        if (attribute.getRow() != -1) {
            return Collections.singletonList(StrategyAttribute.builder().row(attribute.getRow()).column(attribute.getColumn()).build());
        }
        if (attribute.getMaxRow() == -1) {
            return Collections.singletonList(StrategyAttribute.builder().row(attribute.getMinRow()).column(attribute.getColumn()).build());
        }
        return IntStream.range(attribute.getMinRow(), attribute.getMaxRow() + 1).mapToObj(row -> StrategyAttribute.builder().row(row).column(attribute.getColumn()).build()).collect(Collectors.toList());
    }

    private Stream<Verifier> parseAttributeNotEmptyVerifier(String sheetName, StrategyAttribute attr) {
        log.warn("in {} sheet, {} is not found.", (Object)sheetName, (Object)attr);
        if (attr.getRow() != -1) {
            return Stream.of(new NotEmptyVerifier("", Location.builder().sheetName(sheetName).row(attr.getRow()).column(attr.getColumn()).build()));
        }
        if (attr.getMaxRow() == -1) {
            return Stream.of(new NotEmptyVerifier("", Location.builder().sheetName(sheetName).row(attr.getMinRow()).column(attr.getColumn()).build()));
        }
        return IntStream.range(attr.getMinRow(), attr.getMaxRow() + 1).mapToObj(row -> new NotEmptyVerifier("", Location.builder().sheetName(sheetName).row(row).column(attr.getColumn()).build()));
    }

    private void handleStrategyAttribute(Sheet sheet, String data, StrategyAttribute strategyAttr, Location curLocation) {
        List<Verifier> verifierObjs = strategyAttr.getVerifiers().stream().map(verifierDesc -> verifierDesc.createVerifyObj(data, curLocation, VerifyContext.getRelationValue(verifierDesc, sheet, curLocation.getRow()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        boolean permitEmpty = strategyAttr.isPermitEmpty();
        if (!permitEmpty) {
            verifierObjs.add(0, new NotEmptyVerifier(data, curLocation));
        }
        if (StringUtils.isNotEmpty((CharSequence)strategyAttr.getRepeatType())) {
            this.recordRepeat(sheet, curLocation, data, strategyAttr.getRepeatType());
        }
        this.addVerifier(verifierObjs);
    }

    private void recordRepeat(Sheet sheet, Location curLocation, String data, String repeatType) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return;
        }
        if (Objects.equals(REPEAT_KEY_SLOT, repeatType)) {
            this.checkSlotRepeat(sheet, curLocation, data, repeatType);
            return;
        }
        if (Objects.equals(REPEAT_KEY_CABINET_NAME, repeatType) || Objects.equals(REPEAT_KEY_DEVICE_NAME, repeatType)) {
            this.checkCabinetDevNameRepeat(curLocation, data, repeatType);
            return;
        }
        this.checkRepeat(curLocation, data, repeatType);
    }

    private void checkRepeat(Location curLocation, String data, String repeatType) {
        if (!this.repeatDatas.computeIfAbsent(repeatType, key -> new HashSet()).add(data)) {
            this.repeatErrorMsg.add(String.join((CharSequence)":", curLocation.toString(), ResourceConfigLoader.getStringFromExportMsgWithParams("deploy.params.value.exists", data)));
        }
    }

    private void checkCabinetDevNameRepeat(Location curLocation, String data, String repeatType) {
        if (Objects.equals(REPEAT_KEY_CABINET_NAME, repeatType)) {
            this.repeatDatas.computeIfAbsent(repeatType, key -> new HashSet()).add(data);
            this.checkOnlyRepeatContain(curLocation, data, REPEAT_KEY_DEVICE_NAME, "verify.params.cabinet.value.exist");
        } else {
            this.checkRepeat(curLocation, data, repeatType);
            this.checkOnlyRepeatContain(curLocation, data, REPEAT_KEY_CABINET_NAME, "verify.params.device.value.exist");
        }
    }

    private void checkOnlyRepeatContain(Location curLocation, String data, String repeatType, String tipResKey) {
        if (this.repeatDatas.getOrDefault(repeatType, Collections.emptySet()).contains(data)) {
            this.repeatErrorMsg.add(String.join((CharSequence)":", curLocation.toString(), ResourceConfigLoader.getStringFromExportMsgWithParams(tipResKey, data)));
        }
    }

    private void checkSlotRepeat(Sheet sheet, Location curLocation, String data, String repeatType) {
        String cabinet = this.getCabinet(sheet, curLocation);
        if (StringUtils.isEmpty((CharSequence)cabinet)) {
            return;
        }
        if (!this.notRepeat(sheet, curLocation, data, repeatType)) {
            this.repeatErrorMsg.add(String.join((CharSequence)":", curLocation.toString(), ResourceConfigLoader.getStringFromExportMsgWithParams("deploy.params.slot.exists", cabinet, data)));
        }
    }

    private boolean notRepeat(Sheet sheet, Location curLocation, String data, String repeatType) {
        return this.repeatDatas.computeIfAbsent(repeatType, key -> new HashSet()).add(String.join((CharSequence)"-", this.getCabinet(sheet, curLocation), data));
    }

    private String getCabinet(Sheet sheet, Location curLocation) {
        Cell cell = sheet.getRow(curLocation.getRow()).getCell(curLocation.getColumn() - 1);
        if (cell.getCellType() == CellType.NUMERIC) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue());
        }
        return cell.getStringCellValue();
    }

    private void addVerifier(List<Verifier> verifier) {
        this.verifiers.addAll(verifier);
    }

    private static List<RelationValue> getRelationValue(VerifierDesc verifierDesc, Sheet sheet, int curRow) {
        if (CollectionUtils.isEmpty(verifierDesc.getRelationLocations())) {
            return Collections.emptyList();
        }
        return verifierDesc.getRelationLocations().stream().map(location -> VerifyContext.getRelationValue(sheet, curRow, location)).collect(Collectors.toList());
    }

    private static RelationValue getRelationValue(Sheet sheet, int curRow, Location location) {
        if (location.getSheetIndex() == -1) {
            location.setSheetName(sheet.getSheetName());
            if (location.getRow() == -1) {
                location.setRow(curRow);
            }
            return new RelationValue(location, Optional.ofNullable(sheet.getRow(location.getRow()).getCell(location.getColumn())).map(Cell::getStringCellValue).orElse(""));
        }
        Sheet relationSheet = sheet.getWorkbook().getSheetAt(location.getSheetIndex());
        location.setSheetName(relationSheet.getSheetName());
        return new RelationValue(location, Optional.ofNullable(relationSheet.getRow(location.getRow()).getCell(location.getColumn())).map(Cell::getStringCellValue).orElse(""));
    }

    private VerifyContext() {
    }
}

