/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.a3000.strategy;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageType;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.StrategyAttribute;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.VerifierDesc;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvEnum;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvUtils;
import com.huawei.yinglong.virtualization.deploy.utils.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifierStrategy {
    private static final Logger log = LoggerFactory.getLogger(VerifierStrategy.class);
    private static volatile VerifierStrategy ins;
    private final Map<String, List<StrategyAttribute>> strategyAttributeMap = new HashMap<String, List<StrategyAttribute>>();

    private VerifierStrategy() {
        this.initStrategyFile("A3000VerifyStrategy.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VerifierStrategy getInstance() {
        if (!Objects.isNull(ins)) return ins;
        Class<VerifierStrategy> clazz = VerifierStrategy.class;
        synchronized (VerifierStrategy.class) {
            if (!Objects.isNull(ins)) return ins;
            ins = new VerifierStrategy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    private void initStrategyFile(String strategyFile) {
        try (InputStream resource = this.getClass().getResourceAsStream("/excel-verify/" + strategyFile);){
            if (Objects.isNull(resource)) {
                log.warn(" verify strategy  resource not found {}", (Object)strategyFile);
                return;
            }
            Document doc = XmlUtils.parseDocument(resource);
            NodeList config = XmlUtils.searchNodeByExp(doc, "config");
            if (config == null) {
                log.warn("initStrategyFile config is null");
                throw new IllegalArgumentException("initStrategyFile error.");
            }
            for (int i = 0; i < config.getLength(); ++i) {
                Node item = config.item(i);
                if (!(item instanceof Element)) continue;
                this.parseConfig((Element)item);
            }
        }
        catch (IOException e) {
            log.warn("parse verify strategy error", (Throwable)e);
        }
    }

    private void parseConfig(Element config) {
        XmlUtils.getChildren(config, "table").forEach(this::parseTable);
    }

    private void parseTable(Element item) {
        String sheetName = item.getAttribute("sheetName");
        String[] split = sheetName.split("\\|");
        List attribute = XmlUtils.getChildren(item, "attribute").stream().filter(this::involved).map(this::parseAttribute).collect(Collectors.toList());
        if (LanguageUtils.getCurrentLanguage() == LanguageType.EN && split.length > 1) {
            this.strategyAttributeMap.put(split[1], attribute);
        } else {
            this.strategyAttributeMap.put(split[0], attribute);
        }
    }

    private boolean involved(Element attr) {
        Collection<Element> verify = XmlUtils.getChildren(attr, "verify");
        List verifierDescs = verify.stream().map(this::buildVerifier).collect(Collectors.toList());
        ToolEnvEnum toolFromValue = ToolEnvUtils.getToolFromValue();
        return verifierDescs.isEmpty() || verifierDescs.stream().anyMatch(verifierDesc -> this.isContainsCurrentScene((VerifierDesc)verifierDesc, toolFromValue));
    }

    private StrategyAttribute parseAttribute(Element element) {
        String name = element.getAttribute("name");
        String[] names = name.split("\\|");
        StrategyAttribute.StrategyAttributeBuilder builder = StrategyAttribute.builder();
        builder.zhName(names[0]);
        if (names.length > 1) {
            builder.enName(names[1]);
        }
        return builder.permitEmpty(Boolean.parseBoolean(XmlUtils.getAttribute(element, "permitEmpty", "false"))).row(this.getNumber(element.getAttribute("row"))).column(this.getNumber(element.getAttribute("column"))).minRow(this.getNumber(element.getAttribute("minRow"))).maxRow(this.getNumber(element.getAttribute("maxRow"))).mergeCellVerticalNum(this.getNumber(element.getAttribute("mergeCellVerticalNum"))).repeatType(XmlUtils.getAttribute(element, "checkRepeat", "")).verifiers(this.parseVerifier(XmlUtils.getChildren(element, "verify"))).build();
    }

    private int getNumber(String attr) {
        if (StringUtils.isEmpty((CharSequence)attr)) {
            return -1;
        }
        return NumberUtils.parseInt((String)attr, (int)-1);
    }

    private List<VerifierDesc> parseVerifier(Collection<Element> verify) {
        List verifierDesces = verify.stream().map(this::buildVerifier).collect(Collectors.toList());
        ToolEnvEnum toolFromValue = ToolEnvUtils.getToolFromValue();
        return verifierDesces.stream().filter(verifierDesc -> this.isContainsCurrentScene((VerifierDesc)verifierDesc, toolFromValue)).collect(Collectors.toList());
    }

    private boolean isContainsCurrentScene(VerifierDesc verifierDesc, ToolEnvEnum toolFromValue) {
        String[] scenes = verifierDesc.getSupportScenes().split(",");
        if (StringUtils.isEmpty((CharSequence)scenes[0])) {
            return true;
        }
        return Arrays.stream(scenes).anyMatch(scene -> toolFromValue.getToolEnvValue().equalsIgnoreCase((String)scene));
    }

    private VerifierDesc buildVerifier(Element element) {
        return VerifierDesc.builder().type(element.getAttribute("type")).param(element.getAttribute("param")).supportScenes(element.getAttribute("supportScenes")).relationLocations(this.parseLocation(element.getAttribute("relationLocation"))).build();
    }

    private List<Location> parseLocation(String relationLocation) {
        if (StringUtils.isEmpty((CharSequence)relationLocation)) {
            return Collections.emptyList();
        }
        return Arrays.stream(relationLocation.split(",")).map(this::parseCoordinates).collect(Collectors.toList());
    }

    private Location parseCoordinates(String coordinatesString) {
        String[] coordinates = coordinatesString.split(":");
        return Location.builder().sheetIndex(NumberUtils.parseInt((String)coordinates[0], (int)-1)).row(NumberUtils.parseInt((String)coordinates[1], (int)-1)).column(NumberUtils.parseInt((String)coordinates[2], (int)-1)).build();
    }

    public List<StrategyAttribute> findStrategies(String sheetName, int row, int column) {
        return ((List)ins.getStrategyAttributeMap().getOrDefault(sheetName, new ArrayList())).stream().filter(strategyAttribute -> strategyAttribute.locationMatch(row, column)).collect(Collectors.toList());
    }

    public Map<String, List<StrategyAttribute>> getStrategyAttributeMap() {
        return this.strategyAttributeMap;
    }
}

