/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.importing;

import com.huawei.yinglong.virtualization.deploy.bpm.converter.EcontainerConverter;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployParamsData;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerBaseParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerMetaVisionEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerNetworkPlaneEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerNpuPlaneEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerParamDataFromExcel;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerServerParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerStorageLogicParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerStorageParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerSwitchParamEntity;
import com.huawei.yinglong.virtualization.deploy.utils.ImportParametersExcelUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ImportParametersParseUtils;
import com.huawei.yinglong.virtualization.deploy.utils.a3000.VerifyContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public final class ImportEcontainerParamUtils {
    private static List<String> getNetWorkPlaneTitle() {
        List<String> list = Arrays.asList("deploy.template.header.network.plane.name", "deploy.template.header.network.plane.mask", "deploy.template.header.network.plane.gateway", "deploy.template.header.network.plane.port.type", "deploy.template.header.network.plane.bind.mode", "deploy.template.header.network.plane.bind.name", "deploy.template.header.network.plane.nic");
        return list.stream().map(ResourceConfigLoader::getStringFromExportHeaderTemplate).collect(Collectors.toList());
    }

    private static List<String> getSwitchTitle() {
        List<String> list = Arrays.asList("deploy.template.header.switch.type", "deploy.template.header.switch.cabinet", "deploy.template.header.switch.slot", "deploy.template.header.switch.ip", "deploy.template.header.switch.port", "deploy.template.header.switch.username", "deploy.template.header.switch.authentication.algorithm", "deploy.template.header.switch.authentication.password", "deploy.template.header.switch.authentication.level", "deploy.template.header.switch.encrypt.algorithm", "deploy.template.header.switch.encrypt.password");
        return list.stream().map(ResourceConfigLoader::getStringFromExportHeaderTemplate).collect(Collectors.toList());
    }

    private static List<String> getNpuPlaneTitle() {
        List<String> list = Arrays.asList("deploy.template.header.npu.plane.port", "deploy.template.header.npu.plane.start.ip", "deploy.template.header.npu.plane.end.ip", "deploy.template.header.npu.plane.netmask", "deploy.template.header.npu.plane.gateway");
        return list.stream().map(ResourceConfigLoader::getStringFromExportHeaderTemplate).collect(Collectors.toList());
    }

    private static List<String> getServerTitle() {
        List<String> list = Arrays.asList("deploy.template.header.server.type", "deploy.template.header.server.cabinet", "deploy.template.header.server.slot", "deploy.template.header.server.name", "deploy.template.header.server.sn", "deploy.template.header.server.node.type", "deploy.template.header.server.npu.driver.type", "deploy.template.header.server.manager.ip", "deploy.template.header.server.business.ip", "deploy.template.header.server.storage.ip", "deploy.template.header.server.ibmc.current.ip", "deploy.template.header.server.ibmc.target.ip", "deploy.template.header.server.ibmc.username", "deploy.template.header.server.ibmc.pwd", "deploy.template.header.server.ibmc.new.pwd", "deploy.template.header.server.ibmc.fc2mgmt.pwd");
        return list.stream().map(ResourceConfigLoader::getStringFromExportHeaderTemplate).collect(Collectors.toList());
    }

    public static List<String> getStorageParam() {
        List<String> list = Arrays.asList("deploy.template.header.storage.type", "deploy.template.header.storage.name", "deploy.template.header.storage.current.manager.ip", "deploy.template.header.storage.username", "deploy.template.header.storage.password", "deploy.template.header.storage.license.name", "deploy.template.header.storage.account", "deploy.template.header.storage.account.password", "deploy.template.header.storage.pool.name", "deploy.template.header.storage.pool.capacity");
        return list.stream().map(ResourceConfigLoader::getStringFromExportHeaderTemplate).collect(Collectors.toList());
    }

    public static List<String> getStorageLogicParam() {
        List<String> list = Arrays.asList("deploy.template.header.storage.controller.id", "deploy.template.header.storage.cabinet", "deploy.template.header.storage.slot", "deploy.template.header.storage.sn", "deploy.template.header.storage.controller.ip", "deploy.template.header.storage.logic.port.ip", "deploy.template.header.storage.logic.port.type", "deploy.template.header.storage.logic.bind.name", "deploy.template.header.storage.logic.physical.nic");
        return list.stream().map(ResourceConfigLoader::getStringFromExportHeaderTemplate).collect(Collectors.toList());
    }

    public static A3000DeployProcessConfig transferA3000Data(DeployParamsData deployParamsData, EcontainerConverter econtainerConverter) {
        EcontainerBaseParamEntity econtainerBaseParamEntity = new EcontainerBaseParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getEContainerInfo().getBaseParam(), econtainerBaseParamEntity);
        EcontainerMetaVisionEntity econtainerMetaVisionEntity = new EcontainerMetaVisionEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getEContainerInfo().getMetaVisionParam(), econtainerMetaVisionEntity);
        return econtainerConverter.toA3000DeployConfig(EcontainerParamEntity.builder().serverBasicInfo(econtainerBaseParamEntity).metaVisionInfo(econtainerMetaVisionEntity).networkInfos(ImportEcontainerParamUtils.getNetworkPlaneEntities(deployParamsData)).npuPlaneInfos(ImportEcontainerParamUtils.getNpuPlaneEntities(deployParamsData)).switchInfos(ImportEcontainerParamUtils.getSwitchParamEntities(deployParamsData)).serverInfos(ImportEcontainerParamUtils.getServerParamEntities(deployParamsData)).storageInfos(ImportEcontainerParamUtils.getStorageParamEntities(deployParamsData)).build());
    }

    public static A3000DeployProcessConfig transferA3000ExpansionData(DeployParamsData deployParamsData, EcontainerConverter econtainerConverter) {
        EcontainerBaseParamEntity econtainerBaseParamEntity = new EcontainerBaseParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getEContainerInfo().getBaseParam(), econtainerBaseParamEntity);
        return econtainerConverter.toA3000ExpansionDeployConfig(EcontainerParamEntity.builder().serverBasicInfo(econtainerBaseParamEntity).metaVisionInfo(new EcontainerMetaVisionEntity()).networkInfos(ImportEcontainerParamUtils.getNetworkPlaneEntities(deployParamsData)).npuPlaneInfos(Collections.emptyList()).switchInfos(Collections.emptyList()).serverInfos(ImportEcontainerParamUtils.getServerParamEntities(deployParamsData)).storageInfos(Collections.emptyList()).build());
    }

    @NotNull
    private static List<EcontainerStorageParamEntity> getStorageParamEntities(DeployParamsData deployParamsData) {
        return deployParamsData.getEContainerInfo().getStorageParam().stream().map(map -> ImportEcontainerParamUtils.buildStorage(map, deployParamsData.getEContainerInfo().getStorageLogicParam())).collect(Collectors.toList());
    }

    @NotNull
    private static List<EcontainerServerParamEntity> getServerParamEntities(DeployParamsData deployParamsData) {
        return deployParamsData.getEContainerInfo().getServerList().stream().map(ImportEcontainerParamUtils::buildServer).collect(Collectors.toList());
    }

    @NotNull
    private static List<EcontainerSwitchParamEntity> getSwitchParamEntities(DeployParamsData deployParamsData) {
        return deployParamsData.getEContainerInfo().getSwitchList().stream().map(ImportEcontainerParamUtils::buildSwitch).collect(Collectors.toList());
    }

    @NotNull
    private static List<EcontainerNetworkPlaneEntity> getNetworkPlaneEntities(DeployParamsData deployParamsData) {
        return deployParamsData.getEContainerInfo().getNetworkPlaneParam().stream().map(ImportEcontainerParamUtils::buildNetworkPlane).collect(Collectors.toList());
    }

    private static EcontainerNetworkPlaneEntity buildNetworkPlane(Map<String, String> nap) {
        EcontainerNetworkPlaneEntity econtainerNetworkPlaneEntity = new EcontainerNetworkPlaneEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(nap, econtainerNetworkPlaneEntity);
        return econtainerNetworkPlaneEntity;
    }

    @NotNull
    private static List<EcontainerNpuPlaneEntity> getNpuPlaneEntities(DeployParamsData deployParamsData) {
        return deployParamsData.getEContainerInfo().getNpuPlaneParam().stream().map(ImportEcontainerParamUtils::buildNpuPlane).collect(Collectors.toList());
    }

    private static EcontainerNpuPlaneEntity buildNpuPlane(Map<String, String> nap) {
        EcontainerNpuPlaneEntity econtainerNpuPlaneEntity = new EcontainerNpuPlaneEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(nap, econtainerNpuPlaneEntity);
        return econtainerNpuPlaneEntity;
    }

    private static EcontainerSwitchParamEntity buildSwitch(Map<String, String> nap) {
        EcontainerSwitchParamEntity entity = new EcontainerSwitchParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(nap, entity);
        return entity;
    }

    private static EcontainerServerParamEntity buildServer(Map<String, String> nap) {
        EcontainerServerParamEntity entity = new EcontainerServerParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(nap, entity);
        return entity;
    }

    private static EcontainerStorageParamEntity buildStorage(Map<String, String> nap, List<Map<String, String>> logicMap) {
        EcontainerStorageParamEntity entity = new EcontainerStorageParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(nap, entity);
        entity.setLogicInfos(logicMap.stream().map(ImportEcontainerParamUtils::buildStorageLogicInfo).collect(Collectors.toList()));
        return entity;
    }

    private static EcontainerStorageLogicParamEntity buildStorageLogicInfo(Map<String, String> nap) {
        EcontainerStorageLogicParamEntity entity = new EcontainerStorageLogicParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(nap, entity);
        return entity;
    }

    public static Optional<EcontainerParamDataFromExcel> parseEcontainerParams(XSSFWorkbook workbook) {
        return Optional.of(EcontainerParamDataFromExcel.builder().baseParam(ImportEcontainerParamUtils.getEcontainerBaseParam(workbook)).metaVisionParam(ImportEcontainerParamUtils.getEcontainerMetaVisionParam(workbook)).networkPlaneParam(ImportEcontainerParamUtils.getEcontainerMapList(workbook, "deploy.params.template.econtainer.network.plane.sheet", ImportEcontainerParamUtils.getNetWorkPlaneTitle(), 2, 0)).npuPlaneParam(ImportEcontainerParamUtils.getEcontainerMapList(workbook, "deploy.params.template.econtainer.network.plane.sheet", ImportEcontainerParamUtils.getNpuPlaneTitle(), 9, 0)).switchList(ImportEcontainerParamUtils.getEcontainerMapList(workbook, "deploy.params.template.econtainer.switch.sheet", ImportEcontainerParamUtils.getSwitchTitle(), 2, 0)).serverList(ImportEcontainerParamUtils.getEcontainerMapList(workbook, "deploy.params.template.econtainer.server.sheet", ImportEcontainerParamUtils.getServerTitle(), 2, 0)).storageParam(ImportEcontainerParamUtils.getEcontainerMapList(workbook, "deploy.params.template.econtainer.storage.sheet", ImportEcontainerParamUtils.getStorageParam(), 2, 0)).storageLogicParam(ImportEcontainerParamUtils.getEcontainerMapList(workbook, "deploy.params.template.econtainer.storage.sheet", ImportEcontainerParamUtils.getStorageLogicParam(), 6, 0)).build());
    }

    public static Optional<EcontainerParamDataFromExcel> parseParamsA3000Expansion(XSSFWorkbook workbook) {
        return Optional.of(EcontainerParamDataFromExcel.builder().baseParam(ImportEcontainerParamUtils.parseParamsA3000Base(workbook)).networkPlaneParam(ImportEcontainerParamUtils.getEcontainerMapList(workbook, "deploy.params.template.econtainer.network.plane.sheet", ImportEcontainerParamUtils.getNetWorkPlaneTitle(), 2, 0)).serverList(ImportEcontainerParamUtils.getEcontainerMapList(workbook, "deploy.params.template.econtainer.server.sheet", ImportEcontainerParamUtils.getServerTitle(), 2, 0)).build());
    }

    private static List<Map<String, String>> getEcontainerMapList(XSSFWorkbook workbook, String sheetName, List<String> title, int startRow, int startCol) {
        XSSFSheet sheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg(sheetName));
        if (Objects.isNull(sheet)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        int row = startRow;
        while (Objects.nonNull(sheet.getRow(row)) && ImportEcontainerParamUtils.isCellNonNull(sheet.getRow(row).getCell(0))) {
            HashMap<String, String> rowData = new HashMap<String, String>();
            for (int j = startCol; j < startCol + title.size(); ++j) {
                String cellValue = ImportEcontainerParamUtils.getCellValue(sheet.getRow(row).getCell(j));
                rowData.put(title.get(j - startCol), cellValue);
                VerifyContext.getInstance().parseVerifiers((Sheet)sheet, row, j, cellValue);
            }
            ++row;
            mapList.add(rowData);
        }
        return mapList;
    }

    private static String getCellValue(XSSFCell cell) {
        if (Objects.isNull(cell)) {
            return "";
        }
        if (cell.getCellType() == CellType.STRING) {
            return StringUtils.trim((String)cell.getStringCellValue());
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue());
        }
        return "";
    }

    private static boolean isCellNonNull(XSSFCell cell) {
        if (Objects.isNull(cell)) {
            return false;
        }
        if (cell.getCellType() == CellType.STRING || cell.getCellType() == CellType.BLANK) {
            return com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils.isNotEmpty((CharSequence)cell.getStringCellValue());
        }
        return true;
    }

    @NotNull
    private static Map<String, String> getEcontainerBaseParam(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.base.sheet"));
        if (Objects.isNull(sheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> eContainer = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.server.base.title"));
        eContainer.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.server.disk.title")));
        eContainer.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.params.title")));
        return eContainer;
    }

    @NotNull
    private static Map<String, String> parseParamsA3000Base(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.base.sheet"));
        if (Objects.isNull(sheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> eContainer = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.server.base.title"));
        eContainer.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.server.disk.title")));
        return eContainer;
    }

    private static Map<String, String> getEcontainerMetaVisionParam(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.base.sheet"));
        if (Objects.isNull(sheet)) {
            return Collections.emptyMap();
        }
        return ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sheet, ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.econtainer.metaversion.title"));
    }

    private ImportEcontainerParamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

