/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.importing;

import com.huawei.yinglong.virtualization.deploy.bpm.converter.IntegrateConverter;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployParamsData;
import com.huawei.yinglong.virtualization.deploy.entity.export.integrate.CampusIntegrateEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.integrate.HiCloudIntegrateEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.integrate.IntegrateParamDataFromExcel;
import com.huawei.yinglong.virtualization.deploy.entity.export.integrate.IntegrateParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.integrate.SfsIntegrateEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.integrate.UltraVrIntegrateEntity;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.ImportParametersExcelUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ImportParametersParseUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ImportIntegrateParamUtils {
    public static Optional<IntegrateParamDataFromExcel> parseIntegrateParams(XSSFWorkbook workbook, List<String> installModes) {
        return Optional.of(IntegrateParamDataFromExcel.builder().ultraVrParam(ImportIntegrateParamUtils.parseUltraVrParams(workbook, installModes)).hiCloudParam(ImportIntegrateParamUtils.parseHiCloudParams(workbook, installModes)).sfsParam(ImportIntegrateParamUtils.parseSfsParams(workbook, installModes)).campusCoreParam(ImportIntegrateParamUtils.parseCampusParams(workbook, installModes)).build());
    }

    public static IntegrateDmeProcessConfig transferIntegrateData(DeployParamsData deployParamsData, IntegrateConverter integrateConverter) {
        UltraVrIntegrateEntity ultraVrIntegrateEntity = new UltraVrIntegrateEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getIntegrateInfo().getUltraVrParam(), ultraVrIntegrateEntity);
        HiCloudIntegrateEntity hiCloudIntegrateEntity = new HiCloudIntegrateEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getIntegrateInfo().getHiCloudParam(), hiCloudIntegrateEntity);
        SfsIntegrateEntity sfsIntegrateEntity = new SfsIntegrateEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getIntegrateInfo().getSfsParam(), sfsIntegrateEntity);
        CampusIntegrateEntity campusIntegrateEntity = new CampusIntegrateEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getIntegrateInfo().getCampusCoreParam(), campusIntegrateEntity);
        return integrateConverter.toIntegrateDmeProcessConfig(IntegrateParamsEntity.builder().ultraVrIntegrateEntity(ultraVrIntegrateEntity).hiCloudIntegrateEntity(hiCloudIntegrateEntity).sfsIntegrateEntity(sfsIntegrateEntity).campusIntegrateEntity(campusIntegrateEntity).build());
    }

    private static Map<String, String> parseUltraVrParams(XSSFWorkbook workbook, List<String> installModes) {
        if (!InstallModeEnum.containUltraVRdeployScene(installModes)) {
            return Collections.emptyMap();
        }
        XSSFSheet ultraVrSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.ultra.sheet"));
        if (Objects.isNull(ultraVrSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> ultraVrParam = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)ultraVrSheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.base.title"));
        ultraVrParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)ultraVrSheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.ultra.adapt.title")));
        return ultraVrParam;
    }

    private static Map<String, String> parseHiCloudParams(XSSFWorkbook workbook, List<String> installModes) {
        if (!InstallModeEnum.containHiCloudDeployScene(installModes)) {
            return Collections.emptyMap();
        }
        XSSFSheet hiCloudSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.hicloud.sheet"));
        if (Objects.isNull(hiCloudSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> hiCloudParam = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.base.title"));
        hiCloudParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)hiCloudSheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.hicloud.adapt.title")));
        return hiCloudParam;
    }

    private static Map<String, String> parseSfsParams(XSSFWorkbook workbook, List<String> installModes) {
        if (!InstallModeEnum.containSfsDeployScene(installModes)) {
            return Collections.emptyMap();
        }
        XSSFSheet sfsSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.sfs.sheet"));
        if (Objects.isNull(sfsSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> sfsParam = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.base.title"));
        sfsParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)sfsSheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.sfs.adapt.title")));
        return sfsParam;
    }

    private static Map<String, String> parseCampusParams(XSSFWorkbook workbook, List<String> installModes) {
        if (!InstallModeEnum.containCampusCoreDeployScene(installModes)) {
            return Collections.emptyMap();
        }
        XSSFSheet campusSheet = workbook.getSheet(ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.campus.sheet"));
        if (Objects.isNull(campusSheet)) {
            return Collections.emptyMap();
        }
        Map<String, String> campusParam = ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)campusSheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.base.title"));
        campusParam.putAll(ImportParametersExcelUtils.parseColSubTableByHeader((Sheet)campusSheet, ResourceConfigLoader.getStringFromExportMsg("integrate.params.template.campus.adapt.title")));
        return campusParam;
    }

    private ImportIntegrateParamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

