/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.integrate.validate;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.CampusIntegrateVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;

public final class CampusIntegrateValidateUtils {
    public static Optional<String> validateCampusParams(CampusIntegrateVo campusIntegrateVo) {
        List<String> invalidateTips = campusIntegrateVo.validate(0, new Class[0]);
        CampusIntegrateValidateUtils.validateParams(campusIntegrateVo, invalidateTips);
        return CollectionUtils.isEmpty(invalidateTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidateTips));
    }

    public static void validateParams(CampusIntegrateVo campusIntegrateVo, List<String> invalidateTips) {
        CampusIntegrateValidateUtils.validateCampusIp(campusIntegrateVo, invalidateTips);
        CampusIntegrateValidateUtils.validateTemplateExist(campusIntegrateVo, invalidateTips);
    }

    private static void validateTemplateExist(CampusIntegrateVo campusIntegrateVo, List<String> invalidateTips) {
        String templatePath = Optional.of(campusIntegrateVo).map(CampusIntegrateVo::getSoftwarePath).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{templatePath})) {
            invalidateTips.add(CampusIntegrateValidateUtils.getErrorMessage("param.campus.integrate.template.file.valid"));
            return;
        }
        CampusIntegrateValidateUtils.validateServicePackages(campusIntegrateVo, invalidateTips, templatePath);
    }

    static void validateServicePackages(CampusIntegrateVo campusIntegrateVo, List<String> invalidateTips, String templatePath) {
        if (!campusIntegrateVo.isDeployPaasLink() && !campusIntegrateVo.isDeployPaasApi()) {
            invalidateTips.add(CampusIntegrateValidateUtils.getErrorMessage("param.campus.integrate.service.valid"));
            return;
        }
        if (campusIntegrateVo.isDeployPaasLink() && StringUtils.isEmpty((CharSequence)CampusIntegrateValidateUtils.getFilePath(templatePath, ConsistencyPattern::isCampusIntegrateLinkFilePackage))) {
            invalidateTips.add(CampusIntegrateValidateUtils.getErrorMessage("param.campus.integrate.link.file.valid"));
        }
        if (campusIntegrateVo.isDeployPaasApi() && StringUtils.isEmpty((CharSequence)CampusIntegrateValidateUtils.getFilePath(templatePath, ConsistencyPattern::isCampusIntegrateApiFilePackage))) {
            invalidateTips.add(CampusIntegrateValidateUtils.getErrorMessage("param.campus.integrate.api.file.valid"));
        }
    }

    private static String getFilePath(String softwareFilePath, Predicate<String> predicate) {
        List specialFileNames = FileOperateUtils.getSpecialFileNames((File)new File(softwareFilePath), predicate);
        if (specialFileNames.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)File.separator, softwareFilePath, (CharSequence)specialFileNames.get(0));
    }

    private static void validateCampusIp(CampusIntegrateVo campusIntegrateVo, List<String> invalidateTips) {
        Map<String, String> campusIpMap = CampusIntegrateValidateUtils.buildCampusIpMap(campusIntegrateVo);
        CampusIntegrateValidateUtils.validateCampusIpReachable(campusIpMap, invalidateTips);
        List<String> ipRepeatabilityTips = CommonParamsValidateUtils.validateIpRepeatability(campusIpMap);
        if (CollectionUtils.isNotEmpty(ipRepeatabilityTips)) {
            invalidateTips.addAll(ipRepeatabilityTips);
        }
    }

    private static void validateCampusIpReachable(Map<String, String> campusIpMap, List<String> invalidateTips) {
        for (Map.Entry<String, String> entry : campusIpMap.entrySet()) {
            if (!IpUtils.isValidIpV4((String)entry.getValue())) {
                invalidateTips.add(StringUtils.formatTxt((String)CampusIntegrateValidateUtils.getErrorMessage("param.campus.integrate.ip.format.valid"), (Object[])new Object[]{entry.getKey()}));
            }
            if (!IpUtils.isValidIpV4((String)entry.getValue()) || IpUtils.isReachable((String)entry.getValue())) continue;
            invalidateTips.add(StringUtils.formatTxt((String)CampusIntegrateValidateUtils.getErrorMessage("param.campus.integrate.ip.reachable.valid"), (Object[])new Object[]{entry.getKey()}));
        }
    }

    private static Map<String, String> buildCampusIpMap(CampusIntegrateVo campusIntegrateVo) {
        HashMap<String, String> campusIpMap = new HashMap<String, String>();
        Optional.of(campusIntegrateVo).map(CampusIntegrateVo::getPortalIp).ifPresent(portalIp -> campusIpMap.put(CampusIntegrateValidateUtils.getExportHeader("integrate.template.header.dme.portal.ip"), (String)portalIp));
        Optional.of(campusIntegrateVo).map(CampusIntegrateVo::getInstallVmIp).ifPresent(vmIp -> campusIpMap.put(CampusIntegrateValidateUtils.getExportHeader("integrate.template.header.campus.installer.ip"), (String)vmIp));
        Optional.of(campusIntegrateVo).map(CampusIntegrateVo::getManageFloatIp).ifPresent(floatIp -> campusIpMap.put(CampusIntegrateValidateUtils.getExportHeader("integrate.template.header.campus.adapt.manageFloatIp"), (String)floatIp));
        return campusIpMap;
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private static String getExportHeader(String key) {
        return ResourceConfigLoader.getStringFromExportHeaderTemplate(key);
    }

    private CampusIntegrateValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

