/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.integrate.validate;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.HiCloudIntegrateVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;

public final class HiCloudIntegrateValidateUtils {
    public static Optional<String> validateHiCloudParams(HiCloudIntegrateVo hiCloudIntegrateVo) {
        List<String> invalidateTips = hiCloudIntegrateVo.validate(0, new Class[0]);
        HiCloudIntegrateValidateUtils.validateParams(hiCloudIntegrateVo, invalidateTips);
        return CollectionUtils.isEmpty(invalidateTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidateTips));
    }

    public static void validateParams(HiCloudIntegrateVo hiCloudIntegrateVo, List<String> invalidateTips) {
        HiCloudIntegrateValidateUtils.validateHiCloudIp(hiCloudIntegrateVo, invalidateTips);
        HiCloudIntegrateValidateUtils.validateTemplateExist(hiCloudIntegrateVo, invalidateTips);
    }

    private static void validateTemplateExist(HiCloudIntegrateVo hiCloudIntegrateVo, List<String> invalidateTips) {
        String templatePath = Optional.of(hiCloudIntegrateVo).map(HiCloudIntegrateVo::getSoftwarePath).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{templatePath})) {
            invalidateTips.add(HiCloudIntegrateValidateUtils.getErrorMessage("param.hiCloud.integrate.template.file.valid"));
            return;
        }
        HiCloudIntegrateValidateUtils.validateServicePackages(hiCloudIntegrateVo, invalidateTips, templatePath);
    }

    static void validateServicePackages(HiCloudIntegrateVo hiCloudIntegrateVo, List<String> invalidateTips, String templatePath) {
        if (!(hiCloudIntegrateVo.isDeployVmware() || hiCloudIntegrateVo.isDeploySecurity() || hiCloudIntegrateVo.isDeployDataBase() || hiCloudIntegrateVo.isDeployBareMetal())) {
            invalidateTips.add(HiCloudIntegrateValidateUtils.getErrorMessage("param.hiCloud.integrate.service.valid"));
            return;
        }
        if (hiCloudIntegrateVo.isDeployVmware() && StringUtils.isEmpty((CharSequence)HiCloudIntegrateValidateUtils.getFilePath(templatePath, ConsistencyPattern::isHiCloudVmWareIntegrateFilePackage))) {
            invalidateTips.add(HiCloudIntegrateValidateUtils.getErrorMessage("param.hiCloud.integrate.vmware.file.valid"));
        }
        if (hiCloudIntegrateVo.isDeploySecurity() && StringUtils.isEmpty((CharSequence)HiCloudIntegrateValidateUtils.getFilePath(templatePath, ConsistencyPattern::isHiCloudSecurityIntegrateFilePackage))) {
            invalidateTips.add(HiCloudIntegrateValidateUtils.getErrorMessage("param.hiCloud.integrate.security.file.valid"));
        }
        if (hiCloudIntegrateVo.isDeployDataBase() && StringUtils.isEmpty((CharSequence)HiCloudIntegrateValidateUtils.getFilePath(templatePath, ConsistencyPattern::isHiCloudDBaasIntegrateFilePackage))) {
            invalidateTips.add(HiCloudIntegrateValidateUtils.getErrorMessage("param.hiCloud.integrate.database.file.valid"));
        }
        if (hiCloudIntegrateVo.isDeployBareMetal() && StringUtils.isEmpty((CharSequence)HiCloudIntegrateValidateUtils.getFilePath(templatePath, ConsistencyPattern::isHiCloudBmsIntegrateFilePackage))) {
            invalidateTips.add(HiCloudIntegrateValidateUtils.getErrorMessage("param.hiCloud.integrate.bare.file.valid"));
        }
    }

    private static String getFilePath(String softwareFilePath, Predicate<String> predicate) {
        List specialFileNames = FileOperateUtils.getSpecialFileNames((File)new File(softwareFilePath), predicate);
        if (specialFileNames.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)File.separator, softwareFilePath, (CharSequence)specialFileNames.get(0));
    }

    private static void validateHiCloudIp(HiCloudIntegrateVo hiCloudIntegrateVo, List<String> invalidateTips) {
        Map<String, String> hiCloudIpMap = HiCloudIntegrateValidateUtils.buildHiCloudIpMap(hiCloudIntegrateVo);
        HiCloudIntegrateValidateUtils.validateHiCloudIpReachable(hiCloudIpMap, invalidateTips);
        List<String> ipRepeatabilityTips = CommonParamsValidateUtils.validateIpRepeatability(hiCloudIpMap);
        if (CollectionUtils.isNotEmpty(ipRepeatabilityTips)) {
            invalidateTips.addAll(ipRepeatabilityTips);
        }
    }

    private static void validateHiCloudIpReachable(Map<String, String> hiCloudIpMap, List<String> invalidateTips) {
        for (Map.Entry<String, String> entry : hiCloudIpMap.entrySet()) {
            if (!IpUtils.isValidIpV4((String)entry.getValue())) {
                invalidateTips.add(StringUtils.formatTxt((String)HiCloudIntegrateValidateUtils.getErrorMessage("param.hiCloud.integrate.ip.format.valid"), (Object[])new Object[]{entry.getKey()}));
            }
            if (!IpUtils.isValidIpV4((String)entry.getValue()) || IpUtils.isReachable((String)entry.getValue())) continue;
            invalidateTips.add(StringUtils.formatTxt((String)HiCloudIntegrateValidateUtils.getErrorMessage("param.hiCloud.integrate.ip.reachable.valid"), (Object[])new Object[]{entry.getKey()}));
        }
    }

    private static Map<String, String> buildHiCloudIpMap(HiCloudIntegrateVo hiCloudIntegrateVo) {
        HashMap<String, String> hiCloudIpMap = new HashMap<String, String>();
        Optional.of(hiCloudIntegrateVo).map(HiCloudIntegrateVo::getPortalIp).ifPresent(portalIp -> hiCloudIpMap.put(HiCloudIntegrateValidateUtils.getExportHeader("integrate.template.header.dme.portal.ip"), (String)portalIp));
        Optional.of(hiCloudIntegrateVo).map(HiCloudIntegrateVo::getVmIp).ifPresent(vmIp -> hiCloudIpMap.put(HiCloudIntegrateValidateUtils.getExportHeader("integrate.template.header.hicloud.gkit.ip"), (String)vmIp));
        Optional.of(hiCloudIntegrateVo).map(HiCloudIntegrateVo::getKeepLivedIp).ifPresent(keepLivedIp -> hiCloudIpMap.put(HiCloudIntegrateValidateUtils.getExportHeader("integrate.template.header.hicloud.keepalive.vip"), (String)keepLivedIp));
        return hiCloudIpMap;
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private static String getExportHeader(String key) {
        return ResourceConfigLoader.getStringFromExportHeaderTemplate(key);
    }

    private HiCloudIntegrateValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

