/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.integrate.validate;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.SfsIntegrateVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public final class SfsIntegrateValidateUtils {
    public static Optional<String> validateSfsParams(SfsIntegrateVo sfsIntegrateVo) {
        List<String> invalidateTips = sfsIntegrateVo.validate(0, new Class[0]);
        SfsIntegrateValidateUtils.validateParams(sfsIntegrateVo, invalidateTips);
        return CollectionUtils.isEmpty(invalidateTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidateTips));
    }

    public static void validateParams(SfsIntegrateVo sfsIntegrateVo, List<String> invalidateTips) {
        SfsIntegrateValidateUtils.validateSfsIp(sfsIntegrateVo, invalidateTips);
        SfsIntegrateValidateUtils.validateTemplateExist(sfsIntegrateVo).ifPresent(invalidateTips::add);
    }

    private static Optional<String> validateTemplateExist(SfsIntegrateVo sfsIntegrateVo) {
        String templatePath = Optional.of(sfsIntegrateVo).map(SfsIntegrateVo::getSoftwarePath).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{templatePath})) {
            return Optional.of(SfsIntegrateValidateUtils.getErrorMessage("param.sfs.integrate.template.file.valid"));
        }
        return Optional.empty();
    }

    private static void validateSfsIp(SfsIntegrateVo sfsIntegrateVo, List<String> invalidateTips) {
        Map<String, String> sfsIpMap = SfsIntegrateValidateUtils.buildSfsIpMap(sfsIntegrateVo);
        SfsIntegrateValidateUtils.validateSfsIpReachable(sfsIpMap, invalidateTips);
        List<String> ipRepeatabilityTips = CommonParamsValidateUtils.validateIpRepeatability(sfsIpMap);
        if (CollectionUtils.isNotEmpty(ipRepeatabilityTips)) {
            invalidateTips.addAll(ipRepeatabilityTips);
        }
    }

    private static void validateSfsIpReachable(Map<String, String> sfsIpMap, List<String> invalidateTips) {
        for (Map.Entry<String, String> entry : sfsIpMap.entrySet()) {
            if (!IpUtils.isValidIpV4((String)entry.getValue())) {
                invalidateTips.add(StringUtils.formatTxt((String)SfsIntegrateValidateUtils.getErrorMessage("param.sfs.integrate.ip.format.valid"), (Object[])new Object[]{entry.getKey()}));
            }
            if (!IpUtils.isValidIpV4((String)entry.getValue()) || IpUtils.isReachable((String)entry.getValue())) continue;
            invalidateTips.add(StringUtils.formatTxt((String)SfsIntegrateValidateUtils.getErrorMessage("param.sfs.integrate.ip.reachable.valid"), (Object[])new Object[]{entry.getKey()}));
        }
    }

    private static Map<String, String> buildSfsIpMap(SfsIntegrateVo sfsIntegrateVo) {
        HashMap<String, String> sfsIpMap = new HashMap<String, String>();
        Optional.of(sfsIntegrateVo).map(SfsIntegrateVo::getPortalIp).ifPresent(portal -> sfsIpMap.put(SfsIntegrateValidateUtils.getExportHeader("integrate.template.header.dme.portal.ip"), (String)portal));
        Optional.of(sfsIntegrateVo).map(SfsIntegrateVo::getVmIp).ifPresent(vmIp -> sfsIpMap.put(SfsIntegrateValidateUtils.getExportHeader("integrate.template.header.sfs.vm.ip"), (String)vmIp));
        Optional.of(sfsIntegrateVo).map(SfsIntegrateVo::getSfsFloatIp).ifPresent(sfsFloatIp -> sfsIpMap.put(SfsIntegrateValidateUtils.getExportHeader("integrate.template.header.sfs.float.ip"), (String)sfsFloatIp));
        return sfsIpMap;
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private static String getExportHeader(String key) {
        return ResourceConfigLoader.getStringFromExportHeaderTemplate(key);
    }

    private SfsIntegrateValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

