/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.integrate.validate;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.UltraVrIntegrateVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public final class UltraVrIntegrateValidateUtils {
    public static Optional<String> validateUltraVrParams(UltraVrIntegrateVo ultraVrIntegrateVo) {
        List<String> invalidateTips = ultraVrIntegrateVo.validate(0, new Class[0]);
        UltraVrIntegrateValidateUtils.validateParams(ultraVrIntegrateVo, invalidateTips);
        return CollectionUtils.isEmpty(invalidateTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidateTips));
    }

    public static void validateParams(UltraVrIntegrateVo ultraVrIntegrateVo, List<String> invalidateTips) {
        UltraVrIntegrateValidateUtils.validateUltraVrIp(ultraVrIntegrateVo, invalidateTips);
        UltraVrIntegrateValidateUtils.validateTemplateExist(ultraVrIntegrateVo).ifPresent(invalidateTips::add);
        UltraVrIntegrateValidateUtils.validateSamePassword(ultraVrIntegrateVo, invalidateTips);
    }

    private static void validateSamePassword(UltraVrIntegrateVo ultraVrIntegrateVo, List<String> invalidateTips) {
        if (ultraVrIntegrateVo.getInitialPwd().equals(ultraVrIntegrateVo.getCustomPwd())) {
            invalidateTips.add(UltraVrIntegrateValidateUtils.getErrorMessage("param.ultra.integrate.same.password.valid"));
        }
    }

    private static Optional<String> validateTemplateExist(UltraVrIntegrateVo ultraVrIntegrateVo) {
        String templatePath = Optional.of(ultraVrIntegrateVo).map(UltraVrIntegrateVo::getSoftwarePath).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{templatePath})) {
            return Optional.of(UltraVrIntegrateValidateUtils.getErrorMessage("param.ultra.integrate.template.file.valid"));
        }
        return Optional.empty();
    }

    private static void validateUltraVrIp(UltraVrIntegrateVo ultraVrIntegrateVo, List<String> invalidateTips) {
        Map<String, String> ultraVrIpMap = UltraVrIntegrateValidateUtils.buildUltraVrIpMap(ultraVrIntegrateVo);
        UltraVrIntegrateValidateUtils.validateUltraVrIpReachable(ultraVrIpMap, invalidateTips);
        List<String> ipRepeatabilityTips = CommonParamsValidateUtils.validateIpRepeatability(ultraVrIpMap);
        if (CollectionUtils.isNotEmpty(ipRepeatabilityTips)) {
            invalidateTips.addAll(ipRepeatabilityTips);
        }
    }

    private static void validateUltraVrIpReachable(Map<String, String> ultraVrIpMap, List<String> invalidateTips) {
        for (Map.Entry<String, String> entry : ultraVrIpMap.entrySet()) {
            if (!IpUtils.isValidIpV4((String)entry.getValue())) {
                invalidateTips.add(StringUtils.formatTxt((String)UltraVrIntegrateValidateUtils.getErrorMessage("param.ultra.integrate.ip.format.valid"), (Object[])new Object[]{entry.getKey()}));
            }
            if (!IpUtils.isValidIpV4((String)entry.getValue()) || IpUtils.isReachable((String)entry.getValue())) continue;
            invalidateTips.add(StringUtils.formatTxt((String)UltraVrIntegrateValidateUtils.getErrorMessage("param.ultra.integrate.ip.reachable.valid"), (Object[])new Object[]{entry.getKey()}));
        }
    }

    private static Map<String, String> buildUltraVrIpMap(UltraVrIntegrateVo ultraVrIntegrateVo) {
        HashMap<String, String> ultraVrIpMap = new HashMap<String, String>();
        Optional.of(ultraVrIntegrateVo).map(UltraVrIntegrateVo::getPortalIp).ifPresent(portalIp -> ultraVrIpMap.put(UltraVrIntegrateValidateUtils.getExportHeader("integrate.template.header.dme.portal.ip"), (String)portalIp));
        Optional.of(ultraVrIntegrateVo).map(UltraVrIntegrateVo::getServicePortalIp).ifPresent(servicePortalIp -> ultraVrIpMap.put(UltraVrIntegrateValidateUtils.getExportHeader("integrate.template.header.ultra.portal"), (String)servicePortalIp));
        return ultraVrIpMap;
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private static String getExportHeader(String key) {
        return ResourceConfigLoader.getStringFromExportHeaderTemplate(key);
    }

    private UltraVrIntegrateValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

