/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.integrate.validate;

import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.integrate.validate.CampusIntegrateValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.integrate.validate.HiCloudIntegrateValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.integrate.validate.SfsIntegrateValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.integrate.validate.UltraVrIntegrateValidateUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateIntegrateParamsUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidateIntegrateParamsUtils.class);

    public static Response<Map<String, String>> validateIntegrateParams(@NotNull IntegrateDmeProcessConfig processConfig) {
        log.info("Start to validate integrate params, involved Scenarios : {}.", processConfig.getInstallMode());
        HashMap validResult = new HashMap();
        ValidateIntegrateParamsUtils.validateUltraVRParams(processConfig).ifPresent(validMsg -> validResult.put("ultraVR", validMsg));
        ValidateIntegrateParamsUtils.validateHiCloudParams(processConfig).ifPresent(validMsg -> validResult.put("hicloud", validMsg));
        ValidateIntegrateParamsUtils.validateSfsParams(processConfig).ifPresent(validMsg -> validResult.put("Sfs", validMsg));
        ValidateIntegrateParamsUtils.validateCampusParams(processConfig).ifPresent(validMsg -> validResult.put("eCampusCore", validMsg));
        log.info("validate integrate params successfully.");
        return ResponseUtil.success(validResult);
    }

    private static Optional<String> validateUltraVRParams(IntegrateDmeProcessConfig processConfig) {
        if (!InstallModeEnum.containUltraVRdeployScene(processConfig.getInstallMode())) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getUltraVrIntegrateVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.ultraVR.is.empty"));
        }
        return UltraVrIntegrateValidateUtils.validateUltraVrParams(processConfig.getUltraVrIntegrateVo());
    }

    private static Optional<String> validateHiCloudParams(IntegrateDmeProcessConfig processConfig) {
        if (!InstallModeEnum.containHiCloudDeployScene(processConfig.getInstallMode())) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getHiCloudIntegrateVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.hicloud.is.empty"));
        }
        return HiCloudIntegrateValidateUtils.validateHiCloudParams(processConfig.getHiCloudIntegrateVo());
    }

    private static Optional<String> validateSfsParams(IntegrateDmeProcessConfig processConfig) {
        if (!InstallModeEnum.containSfsDeployScene(processConfig.getInstallMode())) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getSfsIntegrateVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.sfs.is.empty"));
        }
        return SfsIntegrateValidateUtils.validateSfsParams(processConfig.getSfsIntegrateVo());
    }

    private static Optional<String> validateCampusParams(IntegrateDmeProcessConfig processConfig) {
        if (!InstallModeEnum.containCampusCoreDeployScene(processConfig.getInstallMode())) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getCampusIntegrateVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.campus.is.empty"));
        }
        return CampusIntegrateValidateUtils.validateCampusParams(processConfig.getCampusIntegrateVo());
    }

    private ValidateIntegrateParamsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

