/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.validate;

import com.google.common.collect.ImmutableMap;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreBaseVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreConstant;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreGlobalVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreLevelVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreVmVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CampusParamsValidateUtils {
    private static final Logger log = LoggerFactory.getLogger(CampusParamsValidateUtils.class);
    private static final List<String> CAMPUS_NO_REACHABLE_IP = Arrays.asList(CampusParamsValidateUtils.getExportHeader("deploy.template.header.common.fc.ip"), CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.dme.ip"));
    private static final List<String> CAMPUS_REACHABLE_IP = Arrays.asList(CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.ntp.ip"), CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.dns.address"));
    private static final List<String> CAMPUS_SEGMENT_IP = Arrays.asList(CampusParamsValidateUtils.getExportHeader("deploy.template.header.common.fc.ip"), CampusParamsValidateUtils.getErrorMessage("param.campus.manage.ip.header"), CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.manage.float"), CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.gauss.float"), CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.nfs.float"), CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.manage.ip"));
    private static final Map<String, List<Integer>> vmsSpecs = ImmutableMap.builder().put((Object)"installer", Arrays.asList(4, 32, 280, 560, 200, 0)).put((Object)"nfs-dns-1", Arrays.asList(2, 4, 120, 350, 500, 0)).put((Object)"nfs-dns-2", Arrays.asList(2, 4, 120, 350, 500, 0)).put((Object)"foundation-1", Arrays.asList(4, 16, 120, 200, 200, 0)).put((Object)"foundation-2", Arrays.asList(4, 16, 120, 200, 200, 0)).put((Object)"foundation-3", Arrays.asList(4, 16, 120, 200, 200, 0)).put((Object)"ops-1", Arrays.asList(3, 8, 120, 100, 180, 200)).put((Object)"ops-2", Arrays.asList(3, 8, 120, 100, 180, 200)).put((Object)"gaussv5-1", Arrays.asList(4, 16, 120, 100, 500, 2048)).put((Object)"gaussv5-2", Arrays.asList(4, 16, 120, 100, 500, 2048)).build();

    public static Optional<String> validateCampusParams(CampusCoreParamVo campusCoreParamVo) {
        List<String> invalidTips = campusCoreParamVo.validate(0, new Class[0]);
        CampusParamsValidateUtils.validateParams(campusCoreParamVo, invalidTips);
        return CollectionUtils.isEmpty(invalidTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidTips));
    }

    public static List<String> validateParams(CampusCoreParamVo campusCoreParamVo, List<String> invalidateTips) {
        CampusParamsValidateUtils.validateCampusIp(campusCoreParamVo, invalidateTips);
        CampusParamsValidateUtils.validateCampusTemplateExist(campusCoreParamVo).ifPresent(invalidateTips::add);
        CampusParamsValidateUtils.validateCampusVm(campusCoreParamVo, invalidateTips);
        CampusParamsValidateUtils.validateCampusSamePwd(campusCoreParamVo, invalidateTips);
        return invalidateTips;
    }

    private static void validateCampusSamePwd(CampusCoreParamVo campusCoreParamVo, List<String> invalidateTips) {
        String rootPwd;
        String templatePwd;
        String defaultPwdSecond;
        String defaultPwd = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreBaseVo).map(CampusCoreBaseVo::getDefaultPwd).orElse("");
        if (Objects.equals(defaultPwd, defaultPwdSecond = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreBaseVo).map(CampusCoreBaseVo::getDefaultPwdSecond).orElse(""))) {
            invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.base.same.pwd.valid"));
        }
        if (Objects.equals(templatePwd = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreBaseVo).map(CampusCoreBaseVo::getTemplatePwd).orElse(""), rootPwd = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreGlobalVo).map(CampusCoreGlobalVo::getRootPwd).orElse(""))) {
            invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.global.same.pwd.valid"));
        }
    }

    private static void validateCampusVm(CampusCoreParamVo campusCoreParamVo, List<String> invalidateTips) {
        List<CampusCoreVmVo> campusCoreVmVos = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreVmVos).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(campusCoreVmVos) || campusCoreVmVos.size() != 10) {
            invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.vm.number.valid"));
            return;
        }
        if (!campusCoreVmVos.stream().allMatch(campusCoreVmVo -> CampusCoreConstant.CAMPUS_VM_HOSTNAME.contains(campusCoreVmVo.getHostName()))) {
            invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.vm.hostname.valid"));
            return;
        }
        campusCoreVmVos.forEach(campusCoreVmVo -> CampusParamsValidateUtils.validateCampusVmSpecification(campusCoreVmVo, invalidateTips));
    }

    private static void validateCampusVmSpecification(CampusCoreVmVo campusCoreVmVo, List<String> invalidateTips) {
        if (campusCoreVmVo.getCpu() < vmsSpecs.get(campusCoreVmVo.getHostName()).get(0)) {
            invalidateTips.add(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.vm.cpu.valid"), (Object[])new Object[]{campusCoreVmVo.getHostName(), vmsSpecs.get(campusCoreVmVo.getHostName()).get(0)}));
        }
        if (campusCoreVmVo.getMemory() < vmsSpecs.get(campusCoreVmVo.getHostName()).get(1)) {
            invalidateTips.add(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.vm.memory.valid"), (Object[])new Object[]{campusCoreVmVo.getHostName(), vmsSpecs.get(campusCoreVmVo.getHostName()).get(1)}));
        }
        if (campusCoreVmVo.getSysDisk() < vmsSpecs.get(campusCoreVmVo.getHostName()).get(2)) {
            invalidateTips.add(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.vm.sys.disk.valid"), (Object[])new Object[]{campusCoreVmVo.getHostName(), vmsSpecs.get(campusCoreVmVo.getHostName()).get(2)}));
        }
        for (int i = 0; i < campusCoreVmVo.getDataDisks().size(); ++i) {
            int targetNumber = vmsSpecs.get(campusCoreVmVo.getHostName()).get(i + 3);
            if (campusCoreVmVo.getDataDisks().get(i) >= targetNumber) continue;
            invalidateTips.add(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.vm.data.disk.valid"), (Object[])new Object[]{campusCoreVmVo.getHostName(), i + 1, targetNumber}));
        }
    }

    private static Optional<String> validateCampusTemplateExist(CampusCoreParamVo campusCoreParamVo) {
        String softwarePath = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreBaseVo).map(CampusCoreBaseVo::getSoftwarePath).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{softwarePath})) {
            return Optional.of(CampusParamsValidateUtils.getErrorMessage("param.campus.template.file.valid"));
        }
        return Optional.empty();
    }

    private static void validateCampusIp(CampusCoreParamVo campusCoreParamVo, List<String> invalidateTips) {
        Map<String, String> campusIpMap = CampusParamsValidateUtils.buildCampusIpMap(campusCoreParamVo, invalidateTips);
        CampusParamsValidateUtils.validateIpReachable(campusIpMap, invalidateTips);
        List<String> ipRepeatabilityTips = CommonParamsValidateUtils.validateIpRepeatability(campusIpMap);
        if (CollectionUtils.isNotEmpty(ipRepeatabilityTips)) {
            invalidateTips.addAll(ipRepeatabilityTips);
        }
        String netmask = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreLevelVo).map(CampusCoreLevelVo::getNetmask).orElse("");
        String gateway = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreLevelVo).map(CampusCoreLevelVo::getManageGateway).orElse("");
        CampusParamsValidateUtils.validateCampusIpSegment(campusIpMap, invalidateTips, gateway, netmask);
    }

    private static void validateCampusIpSegment(Map<String, String> campusIpMap, List<String> invalidateTips, String gateway, String netmask) {
        if (StringUtils.isEmpty((CharSequence)gateway) || StringUtils.isEmpty((CharSequence)netmask)) {
            invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.gateway.mask.valid"));
            return;
        }
        if (!IpUtils.isReachable((String)gateway)) {
            invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.gateway.reachable.valid"));
        }
        for (Map.Entry<String, String> entry : campusIpMap.entrySet()) {
            if (!CAMPUS_SEGMENT_IP.stream().anyMatch(entry.getKey()::contains) || IpUtils.checkNetworkRangeValid((String)entry.getValue(), (String)netmask, (String)gateway)) continue;
            invalidateTips.add(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.ip.range.valid"), (Object[])new Object[]{entry.getKey()}));
        }
    }

    private static void validateIpReachable(Map<String, String> ipMap, List<String> invalidateTips) {
        for (Map.Entry<String, String> entry : ipMap.entrySet()) {
            if (!IpUtils.isValidIpV4((String)entry.getValue())) {
                invalidateTips.add(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.ip.format.valid"), (Object[])new Object[]{entry.getKey()}));
                continue;
            }
            if (!IpUtils.isValidIpV4((String)entry.getValue()) || CAMPUS_NO_REACHABLE_IP.contains(entry.getKey())) continue;
            if (CAMPUS_REACHABLE_IP.stream().noneMatch(entry.getKey()::contains) && IpUtils.isReachable((String)entry.getValue())) {
                invalidateTips.add(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.ip.reachable.valid"), (Object[])new Object[]{entry.getKey()}));
                continue;
            }
            if (!CAMPUS_REACHABLE_IP.stream().anyMatch(entry.getKey()::contains) || IpUtils.isReachable((String)entry.getValue())) continue;
            invalidateTips.add(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.ip.must.reachable.valid"), (Object[])new Object[]{entry.getKey()}));
        }
    }

    private static Map<String, String> buildCampusIpMap(CampusCoreParamVo campusCoreParamVo, List<String> invalidateTips) {
        HashMap<String, String> campusIpMap = new HashMap<String, String>();
        CampusParamsValidateUtils.addCampusBaseVoIp(campusCoreParamVo, invalidateTips, campusIpMap);
        CampusParamsValidateUtils.addCampusVmVoIp(campusCoreParamVo, campusIpMap);
        CampusParamsValidateUtils.addCampusGlobalVoIp(campusCoreParamVo, invalidateTips, campusIpMap);
        return campusIpMap;
    }

    private static void addCampusGlobalVoIp(CampusCoreParamVo campusCoreParamVo, List<String> invalidateTips, Map<String, String> campusIpMap) {
        String ntpIp;
        String dmeIp = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreGlobalVo).map(CampusCoreGlobalVo::getDmeIp).orElse("");
        if (StringUtils.isNotEmpty((CharSequence)dmeIp)) {
            campusIpMap.put(CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.dme.ip"), dmeIp);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ntpIp = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreGlobalVo).map(CampusCoreGlobalVo::getNtpIp).orElse("")))) {
            campusIpMap.put(CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.ntp.ip"), ntpIp);
        }
    }

    private static void addCampusVmVoIp(CampusCoreParamVo campusCoreParamVo, Map<String, String> campusIpMap) {
        Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreVmVos).ifPresent(vmList -> CampusParamsValidateUtils.addManageIp(vmList, campusIpMap));
    }

    static void addCampusBaseVoIp(CampusCoreParamVo campusCoreParamVo, List<String> invalidateTips, Map<String, String> campusIpMap) {
        Optional<CampusCoreBaseVo> campusCoreBaseVoOptional = Optional.of(campusCoreParamVo).map(CampusCoreParamVo::getCampusCoreBaseVo);
        if (!campusCoreBaseVoOptional.isPresent()) {
            return;
        }
        CampusCoreBaseVo campusCoreBaseVo = campusCoreBaseVoOptional.get();
        campusIpMap.put(CampusParamsValidateUtils.getExportHeader("deploy.template.header.common.fc.ip"), campusCoreBaseVo.getFcIp());
        if (StringUtils.isNotEmpty((CharSequence)campusCoreBaseVo.getDnsAddress())) {
            campusIpMap.put(CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.dns.address"), campusCoreBaseVo.getDnsAddress());
        }
        campusIpMap.put(CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.manage.float"), campusCoreBaseVo.getManageFloatIp());
        campusIpMap.put(CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.gauss.float"), campusCoreBaseVo.getGaussFloatIp());
        campusIpMap.put(CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.nfs.float"), campusCoreBaseVo.getNfsFloatIp());
        String manageStartIp = campusCoreBaseVo.getManageStartIp();
        String manageEndIp = campusCoreBaseVo.getManageEndIp();
        if (IpUtils.isValidIpV4((String)manageStartIp) && IpUtils.isValidIpV4((String)manageEndIp)) {
            String[] manageStartArray = manageStartIp.split("\\.");
            String[] manageEndIpArray = manageEndIp.split("\\.");
            boolean samePrefixes = Arrays.equals(Arrays.copyOfRange(manageStartArray, 0, 3), Arrays.copyOfRange(manageEndIpArray, 0, 3));
            if (!samePrefixes) {
                invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.ip.eContainer.valid"));
            }
            if (samePrefixes) {
                String prefixes = manageStartArray[0].concat(".").concat(manageStartArray[1].concat(".")).concat(manageStartArray[2]).concat(".");
                int startIndex = Integer.parseInt(manageStartArray[3]);
                int endIndex = Integer.parseInt(manageEndIpArray[3]);
                if (endIndex - startIndex < 4) {
                    invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.ip.eContainer.number.valid"));
                }
                for (int i = startIndex; i <= endIndex; ++i) {
                    String ip = prefixes.concat(String.valueOf(i));
                    campusIpMap.put(StringUtils.formatTxt((String)CampusParamsValidateUtils.getErrorMessage("param.campus.manage.start.ip"), (Object[])new Object[]{ip}), ip);
                }
            }
        } else {
            invalidateTips.add(CampusParamsValidateUtils.getErrorMessage("param.campus.ip.eContainer.ipv4.valid"));
        }
    }

    private static void addManageIp(List<CampusCoreVmVo> vmList, Map<String, String> campusIpMap) {
        vmList.forEach(vm -> campusIpMap.put(vm.getHostName() + CampusParamsValidateUtils.getExportHeader("deploy.template.header.campus.manage.ip"), vm.getOmIp()));
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private static String getExportHeader(String key) {
        return ResourceConfigLoader.getStringFromExportHeaderTemplate(key);
    }

    private CampusParamsValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

