/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.validate;

import com.google.common.collect.ArrayListMultimap;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonParamsValidateUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonParamsValidateUtils.class);

    public static List<String> validateIpRepeatability(Map<String, String> ipMap) {
        ArrayListMultimap reverseMultimap = ArrayListMultimap.create();
        ipMap.forEach((ipName, ipAddress) -> reverseMultimap.put(ipAddress, ipName));
        return reverseMultimap.asMap().values().stream().filter(ipNames -> ipNames.size() > 1).map(ipNames -> CommonParamsValidateUtils.getErrorMessage("param.hicloud.ip.same.valid", ipNames.toString())).collect(Collectors.toList());
    }

    private static String getErrorMessage(String key, String name) {
        return String.format(Locale.ROOT, ResourceConfigLoader.getErrorMessage(key), name);
    }

    private CommonParamsValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

