/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.validate;

import com.google.common.collect.ArrayListMultimap;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.VmTypeEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils.ConsistencyCheckUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuBaseParams;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuParamsVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuPassword;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DeployDayuVmsParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.vo.FcLoginInfo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.PacificParams;
import com.huawei.yinglong.virtualization.deploy.utils.ToolConfigUtils;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DayuParamsValidateUtils {
    private static final Logger log = LoggerFactory.getLogger(DayuParamsValidateUtils.class);
    private static final Map<String, String> eDataInsightIpMap = new HashMap<String, String>();
    private static final String PACAKE_PATH_X86 = "Software_Euler-x86_64.zip";
    private static final String PACAKE_PATH_ARM = "Software_Euler-aarch64.zip";
    private static final String TEMPLATE_PATH_X86 = "DayuImage_Euler-x86_64.zip";
    private static final String TEMPLATE_PATH_ARM = "DayuImage_Euler-aarch64.zip";
    private static final String CHARACTERS_MATCH_8_TO_64_DIGITS = "^.{8,64}$";
    private static final String PASSWORD_NUM_LETTER = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)[\\s\\S]{8,64}$";
    private static final String USER_PASSWORD_SPECIAL_CHAR_REG = "[~@#\\^\\*\\-_\\+\\[\\{\\}\\]:\\.\\/\\?%=!]+";
    private static final String CONTINUITY_SAME_CHARACTER = "^(.)*(.)\\2{2}(.)*$";
    private static final String MATCH_START = "^(?!!|\uff01).*";
    private static final String HDFS = "NdpHDFS";
    private static final String YARN = "NdpYarn";
    private static final String HBASE = "NdpHBase";
    private static final String FTP = "NdpFTP";
    private static final String FLUME = "NdpFlume";
    private static final String SPARK = "NdpSpark";
    private static final String HIVE = "NdpHive";
    private static final String FLINK = "NdpFlink";
    private static final String KAFKA = "Kafka";
    private static final String ZOOKEEPER = "NdpZooKeeper";
    private static final String RANGER = "NdpRanger";
    private static final String REDIS = "NdpRedis";
    private static final String NDP_KAFKA = "NdpKafka";
    private static final String CLICK_HOUSE = "NdpClickHouse";
    private static final String NDP_ES = "NdpES";
    private static final String NDP_STAR_ROCKS = "NdpStarRocks";
    private static final String CUSTOM = "custom";
    private static final String CLICKHOUSE = "clickhouse";
    private static final String HADOOP = "hadoop";
    private static final String SACS = "SACS";
    private static final List<String> CLICKHOUSE_COMPONENT_LIST = Arrays.asList("NdpZooKeeper", "NdpHDFS", "NdpFlume", "NdpClickHouse");
    private static final List<String> HADOOP_COMPONENT_LIST = Arrays.asList("NdpZooKeeper", "NdpRanger", "NdpFlink", "NdpYarn", "NdpSpark", "NdpHive", "NdpHDFS", "NdpHBase", "NdpFlume");
    private static final List<String> VALIDATE_COMPONENT_LIST = Arrays.asList("NdpZooKeeper", "NdpRanger", "NdpRedis", "NdpKafka", "NdpFlume", "NdpHDFS", "NdpYarn", "NdpHive", "NdpHBase", "NdpSpark", "NdpFlink", "NdpFTP", "NdpClickHouse", "NdpES", "NdpStarRocks");
    private static final List<String> NDP_LIST = Arrays.asList("ndp1", "ndp2");
    private static final int CLOUD_SOP_NUMBER = 3;
    private static final Map<String, String> NDP_CONFIG_MAP = ToolConfigUtils.get("eDataInsight");
    private static final String MANUAL_DEPLOY = "manual";
    private static ArrayListMultimap<String, String> ndpMultimap;

    public static Optional<String> validateDayuParams(DayuParamsVo dayuParamsVo) {
        List<String> invalidTips = dayuParamsVo.validate(0, new Class[0]);
        DayuParamsValidateUtils.valideParams(dayuParamsVo, invalidTips);
        return CollectionUtils.isEmpty(invalidTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidTips));
    }

    private static List<String> valideParams(DayuParamsVo dayuParamsVo, List<String> invalidTips) {
        List<String> eDataInsightIpRepeatabilityTips;
        List<String> validateVmParams;
        List<String> validatePacificList;
        eDataInsightIpMap.clear();
        ndpMultimap = ArrayListMultimap.create();
        List<String> validateComponents = DayuParamsValidateUtils.validateComponents(dayuParamsVo);
        List<String> validateVmsList = DayuParamsValidateUtils.validateVmList(dayuParamsVo);
        if (CollectionUtils.isNotEmpty(validateComponents)) {
            invalidTips.addAll(validateComponents);
        }
        if (CollectionUtils.isNotEmpty(validateVmsList)) {
            invalidTips.addAll(validateVmsList);
        }
        if (CollectionUtils.isNotEmpty(validatePacificList = DayuParamsValidateUtils.validatePacific(dayuParamsVo))) {
            invalidTips.addAll(validatePacificList);
        }
        DayuParamsValidateUtils.validateNetworkRang(dayuParamsVo, invalidTips);
        List<String> ndpComponentTips = DayuParamsValidateUtils.validateNdpComponentList(dayuParamsVo);
        if (CollectionUtils.isNotEmpty(ndpComponentTips)) {
            invalidTips.addAll(ndpComponentTips);
        }
        if (CollectionUtils.isNotEmpty(validateVmParams = DayuParamsValidateUtils.validateVmParams(dayuParamsVo))) {
            invalidTips.addAll(validateVmParams);
        }
        if (CollectionUtils.isNotEmpty(eDataInsightIpRepeatabilityTips = DayuParamsValidateUtils.validateEDataInsightIpRepeatability(dayuParamsVo))) {
            invalidTips.addAll(eDataInsightIpRepeatabilityTips);
        }
        return invalidTips;
    }

    private static List<String> validateNdpComponentList(DayuParamsVo dayuParamsVo) {
        ArrayList<String> tips = new ArrayList<String>();
        List<String> filledComponentLists = DayuParamsValidateUtils.buildFilledComponentList(dayuParamsVo);
        if (CollectionUtils.isEmpty(filledComponentLists)) {
            tips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.component.list.null"));
            return tips;
        }
        for (DeployDayuVmsParamsEntity entity : dayuParamsVo.getDeployDayuVmsParamsEntities()) {
            if (StringUtils.isEmpty((CharSequence)entity.getNdpComponentList())) continue;
            if (entity.getNdpComponentList().contains("\uff0c")) {
                tips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.component.list.spilt.valid", entity.getHostName()));
                continue;
            }
            Arrays.stream(entity.getNdpComponentList().replace(" ", "").toLowerCase(Locale.ROOT).split(",")).distinct().forEach(component -> DayuParamsValidateUtils.buildNdpMultimap(filledComponentLists, component, entity, tips));
        }
        int totalNdpNumber = dayuParamsVo.getDeployDayuVmsParamsEntities().size() - 3;
        DayuParamsValidateUtils.validateSpecificComponents(tips, totalNdpNumber);
        return tips;
    }

    private static List<String> buildFilledComponentList(DayuParamsVo dayuParamsVo) {
        String componentType = dayuParamsVo.getDayuBaseParams().getComponentType();
        if (CUSTOM.equalsIgnoreCase(componentType)) {
            return Arrays.asList(dayuParamsVo.getDayuBaseParams().getComponentLists().replace(" ", "").split(","));
        }
        if (HADOOP.equalsIgnoreCase(componentType)) {
            return HADOOP_COMPONENT_LIST;
        }
        if (CLICKHOUSE.equalsIgnoreCase(componentType)) {
            return CLICKHOUSE_COMPONENT_LIST;
        }
        return Collections.emptyList();
    }

    private static void buildNdpMultimap(List<String> filledComponentLists, String component, DeployDayuVmsParamsEntity entity, List<String> tips) {
        if (CollectionUtils.isEmpty(filledComponentLists)) {
            return;
        }
        if (filledComponentLists.stream().noneMatch(filledComponent -> filledComponent.equalsIgnoreCase(component))) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.un.exist.component.valid"), (Object[])new Object[]{entity.getHostName(), component, filledComponentLists}));
        } else {
            ndpMultimap.put((Object)component, (Object)entity.getHostName());
        }
    }

    private static void validateSpecificComponents(List<String> tips, int totalNdpNumber) {
        for (String component : VALIDATE_COMPONENT_LIST) {
            DayuParamsValidateUtils.validateNdpComponents(tips, component, totalNdpNumber);
        }
    }

    private static void validateNdpComponents(List<String> tips, String component, int totalNdpNumber) {
        List componentList = ndpMultimap.get((Object)component.toLowerCase(Locale.ROOT));
        int size = componentList.size();
        if (size == 0) {
            return;
        }
        DayuParamsValidateUtils.validateZooKeeper(tips, component, size, totalNdpNumber);
        DayuParamsValidateUtils.validateRanger(tips, component, size, totalNdpNumber);
        DayuParamsValidateUtils.validateRedis(tips, component, size, totalNdpNumber);
        DayuParamsValidateUtils.validateKafka(tips, component, size);
        DayuParamsValidateUtils.validateFlume(tips, component, size, totalNdpNumber);
        DayuParamsValidateUtils.validateHdfs(tips, component, size);
        DayuParamsValidateUtils.validateYarn(tips, component, size);
        DayuParamsValidateUtils.validateHive(tips, component, size);
        DayuParamsValidateUtils.validateHbase(tips, component, size);
        DayuParamsValidateUtils.validateSpark(tips, component, size, totalNdpNumber);
        DayuParamsValidateUtils.validateFlink(tips, component, size);
        DayuParamsValidateUtils.validateFtp(tips, component, size, totalNdpNumber);
        DayuParamsValidateUtils.validateClickHouse(tips, component, size);
        DayuParamsValidateUtils.validateNdpEs(tips, component, size);
        DayuParamsValidateUtils.validateStarRocks(tips, component, size);
    }

    static void validateStarRocks(List<String> tips, String component, int size) {
        if (!NDP_STAR_ROCKS.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.star.minvalue", 3);
        if (size < minNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.star.valid"), (Object[])new Object[]{minNumber}));
        }
    }

    static void validateNdpEs(List<String> tips, String component, int size) {
        if (!NDP_ES.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.es.minvalue", 3);
        int maxNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.es.maxvalue", 100);
        if (size < minNumber || size > maxNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.es.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    private static void validateClickHouse(List<String> tips, String component, int size) {
        int maxNumber;
        if (!CLICK_HOUSE.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.clickhouse.minvalue", 2);
        if (!DayuParamsValidateUtils.validateComponentSize(size, minNumber, maxNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.clickhouse.maxvalue", 100), true)) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.click.house.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    private static void validateFtp(List<String> tips, String component, int size, int totalNdpNumber) {
        int maxNumber;
        if (!FTP.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.ftp.minvalue", 1);
        int n = maxNumber = totalNdpNumber > DayuParamsValidateUtils.getNdpConfigNumber("ndp.two.hundred.number", 200) ? DayuParamsValidateUtils.getNdpConfigNumber("ndp.ftp.more.two.hundred.maxvalue", 10) : DayuParamsValidateUtils.getNdpConfigNumber("ndp.ftp.less.two.hundred.maxvalue", 5);
        if (size < minNumber || size > maxNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.ftp.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    static void validateFlink(List<String> tips, String component, int size) {
        if (!FLINK.equals(component)) {
            return;
        }
        int number = DayuParamsValidateUtils.getNdpConfigNumber("ndp.flink.value", 2);
        if (size != number) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.flink.valid"), (Object[])new Object[]{number}));
        }
    }

    private static void validateSpark(List<String> tips, String component, int size, int totalNdpNumber) {
        int maxNumber;
        if (!SPARK.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.spark.value", 2);
        if (totalNdpNumber <= 10 && size != minNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.ten.spark.valid"), (Object[])new Object[]{minNumber}));
            return;
        }
        int n = maxNumber = totalNdpNumber > DayuParamsValidateUtils.getNdpConfigNumber("ndp.default.number", 100) ? DayuParamsValidateUtils.getNdpConfigNumber("ndp.spark.more.hundred.maxvalue", 10) : DayuParamsValidateUtils.getNdpConfigNumber("ndp.spark.less.hundred.maxvalue", 6);
        if (size < minNumber || size > maxNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.hundred.spark.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    private static void validateHbase(List<String> tips, String component, int size) {
        if (!HBASE.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.hbase.minvalue", 2);
        if (size < minNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.hbase.valid"), (Object[])new Object[]{minNumber}));
        }
    }

    static void validateHive(List<String> tips, String component, int size) {
        int maxNumber;
        if (!HIVE.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.hive.minvalue", 2);
        if (!DayuParamsValidateUtils.validateComponentSize(size, minNumber, maxNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.hive.maxvalue", 10))) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.hive.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    private static void validateYarn(List<String> tips, String component, int size) {
        if (!YARN.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.yarn.minvalue", 2);
        if (size < minNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.yarn.valid"), (Object[])new Object[]{minNumber}));
        }
    }

    private static void validateHdfs(List<String> tips, String component, int size) {
        if (!HDFS.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.hdfs.minvalue", 3);
        if (size < minNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.hdfs.valid"), (Object[])new Object[]{minNumber}));
        }
    }

    static void validateFlume(List<String> tips, String component, int size, int totalNdpNumber) {
        int maxNumber;
        if (!FLUME.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.flume.minvalue", 2);
        int n = maxNumber = totalNdpNumber > DayuParamsValidateUtils.getNdpConfigNumber("ndp.two.hundred.number", 200) ? DayuParamsValidateUtils.getNdpConfigNumber("ndp.flume.more.two.hundred.maxvalue", 128) : DayuParamsValidateUtils.getNdpConfigNumber("ndp.flume.less.two.hundred.maxvalue", 16);
        if (!DayuParamsValidateUtils.validateComponentSize(size, minNumber, maxNumber)) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.flume.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    private static void validateKafka(List<String> tips, String component, int size) {
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.kafka.minvalue", 2);
        int maxNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.kafka.maxvalue", 20);
        if (NDP_KAFKA.equals(component) && !DayuParamsValidateUtils.validateComponentSize(size, minNumber, maxNumber)) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.kafka.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    static void validateRedis(List<String> tips, String component, int size, int totalNdpNumber) {
        int maxNumber;
        if (!REDIS.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.redis.minvalue", 3);
        int n = maxNumber = totalNdpNumber > DayuParamsValidateUtils.getNdpConfigNumber("ndp.two.hundred.number", 200) ? DayuParamsValidateUtils.getNdpConfigNumber("ndp.redis.more.two.hundred.maxvalue", 256) : DayuParamsValidateUtils.getNdpConfigNumber("ndp.redis.less.two.hundred.maxvalue", 20);
        if (!DayuParamsValidateUtils.validateComponentSize(size, minNumber, maxNumber)) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.redis.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    static void validateRanger(List<String> tips, String component, int size, int totalNdpNumber) {
        if (!RANGER.equals(component)) {
            return;
        }
        int minNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.ranger.less.two.hundred.value", 2);
        if (totalNdpNumber <= DayuParamsValidateUtils.getNdpConfigNumber("ndp.two.hundred.number", 200) && size != minNumber) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.ranger.less.two.hundred.valid"), (Object[])new Object[]{minNumber}));
            return;
        }
        int maxNumber = DayuParamsValidateUtils.getNdpConfigNumber("ndp.ranger.more.two.hundred.value", 10);
        if (!DayuParamsValidateUtils.validateComponentSize(size, minNumber, maxNumber)) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.ranger.more.two.hundred.valid"), (Object[])new Object[]{minNumber, maxNumber}));
        }
    }

    static void validateZooKeeper(List<String> tips, String component, int size, int totalNdpNumber) {
        int number;
        if (!ZOOKEEPER.equals(component)) {
            return;
        }
        int n = number = totalNdpNumber > DayuParamsValidateUtils.getNdpConfigNumber("ndp.default.number", 100) ? DayuParamsValidateUtils.getNdpConfigNumber("ndp.zookeeper.more.hundred.value", 5) : DayuParamsValidateUtils.getNdpConfigNumber("ndp.zookeeper.less.hundred.value", 3);
        if (size != number) {
            tips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.zoo.keeper.valid"), (Object[])new Object[]{number}));
        }
    }

    private static int getNdpConfigNumber(String key, int defaultValue) {
        return Integer.parseInt(NDP_CONFIG_MAP.getOrDefault(key, String.valueOf(defaultValue)));
    }

    private static float getNdpConfigNumber(String key, float defaultValue) {
        return Float.parseFloat(NDP_CONFIG_MAP.getOrDefault(key, String.valueOf(defaultValue)));
    }

    private static int computeNdpMaxNumber(int totalNapNumber, String maxKey, int defaultNumber, float ratios) {
        return totalNapNumber > DayuParamsValidateUtils.getNdpConfigNumber("ndp.default.number", 100) ? new BigDecimal(totalNapNumber).multiply(new BigDecimal(ratios)).intValue() : DayuParamsValidateUtils.getNdpConfigNumber(maxKey, defaultNumber);
    }

    private static boolean validateComponentSize(int size, int minNumber, int maxNumber) {
        return size >= minNumber && size <= maxNumber;
    }

    private static boolean validateComponentSize(int size, int minNumber, int maxNumber, boolean even) {
        return size >= minNumber && size <= maxNumber && even == (size % 2 == 0);
    }

    private static boolean validateComponentSize(int size, int minNumber, boolean even) {
        return size >= minNumber && even == (size % 2 == 0);
    }

    private static List<String> validateEDataInsightIpRepeatability(DayuParamsVo dayuParamsVo) {
        String fcIP = Optional.of(dayuParamsVo).map(DayuParamsVo::getFcLoginInfo).map(FcLoginInfo::getUrl).orElse("");
        if (StringUtils.isNotEmpty((CharSequence)fcIP)) {
            eDataInsightIpMap.put(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.common.fc.ip"), fcIP);
        }
        return CommonParamsValidateUtils.validateIpRepeatability(eDataInsightIpMap);
    }

    private static void validateNetworkRang(DayuParamsVo dayuParamsVo, List<String> invalidTips) {
        String floatingNetwork;
        if (Objects.isNull(dayuParamsVo) || Objects.isNull(dayuParamsVo.getDayuBaseParams()) || CollectionUtils.isEmpty(dayuParamsVo.getDeployDayuVmsParamsEntities())) {
            return;
        }
        DayuBaseParams dayuBaseParams = dayuParamsVo.getDayuBaseParams();
        if (StringUtils.isNotEmpty((CharSequence)dayuBaseParams.getFloatingIp())) {
            eDataInsightIpMap.put(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.dayu.flot.ip"), dayuBaseParams.getFloatingIp());
        }
        if (IpUtils.isReachable((String)dayuBaseParams.getFloatingIp())) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.float.reach.valid"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(floatingNetwork = dayuBaseParams.getFloatingNetwork())) && !IpUtils.isReachable((String)floatingNetwork)) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.float.gateway.reach.valid"));
        }
        if (!IpUtils.checkNetworkRangeValid((String)dayuBaseParams.getFloatingIp(), (String)dayuBaseParams.getFloatingMask(), (String)dayuBaseParams.getGateway())) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.float.range.valid"));
        }
    }

    private static List<String> validatePacific(DayuParamsVo dayuParamsVo) {
        if (Objects.isNull(dayuParamsVo) || Objects.isNull(dayuParamsVo.getPacificParams())) {
            return Collections.emptyList();
        }
        PacificParams pacificParams = dayuParamsVo.getPacificParams();
        if (SACS.equals(pacificParams.getPacificFlag())) {
            return DayuParamsValidateUtils.validPacificParamsNotEmpty(pacificParams);
        }
        return Collections.emptyList();
    }

    static List<String> validPacificParamsNotEmpty(PacificParams pacificParams) {
        ArrayList<String> tips = new ArrayList<String>();
        Field[] declaredFields = pacificParams.getClass().getDeclaredFields();
        if (!Stream.of(declaredFields).allMatch(field -> DayuParamsValidateUtils.getPacificFiledResult(field, pacificParams))) {
            tips.add(DayuParamsValidateUtils.getErrorMessage("param.pacific.empty.valid"));
        }
        if (!IpUtils.isValidIpV4((String)pacificParams.getPacificDnsIp())) {
            tips.add(DayuParamsValidateUtils.getErrorMessage("param.pacific.ip.valid", ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.pacific.dns.ip")));
        } else {
            eDataInsightIpMap.put(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.pacific.dns.ip"), pacificParams.getPacificDnsIp());
        }
        if (!IpUtils.isValidIpV4((String)pacificParams.getPacificHdfsIp())) {
            tips.add(DayuParamsValidateUtils.getErrorMessage("param.pacific.ip.valid", ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.pacific.hdfs.ip")));
        } else {
            eDataInsightIpMap.put(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.pacific.hdfs.ip"), pacificParams.getPacificHdfsIp());
        }
        if (!IpUtils.isValidIpV4((String)pacificParams.getPacificFloatIp())) {
            tips.add(DayuParamsValidateUtils.getErrorMessage("param.pacific.ip.valid", ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.pacific.float.ip")));
        } else {
            eDataInsightIpMap.put(ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.pacific.float.ip"), pacificParams.getPacificFloatIp());
        }
        if (!IpUtils.isReachable((String)pacificParams.getPacificFloatIp())) {
            tips.add(DayuParamsValidateUtils.getErrorMessage("param.pacific.float.ip.valid"));
        }
        if (!IpUtils.isReachable((String)pacificParams.getPacificHdfsIp())) {
            tips.add(DayuParamsValidateUtils.getErrorMessage("param.pacific.hdfs.ip.valid"));
        }
        return tips;
    }

    private static boolean getPacificFiledResult(Field field, PacificParams pacificParams) {
        field.setAccessible(true);
        try {
            if (StringUtils.isEmpty((CharSequence)field.get(pacificParams).toString())) {
                return false;
            }
        }
        catch (IllegalAccessException e) {
            log.error("Get password filed value error", (Throwable)e);
        }
        return true;
    }

    private static List<String> validateVmList(DayuParamsVo dayuParamsVo) {
        ArrayList<String> validateVmsList = new ArrayList<String>();
        if (Objects.isNull(dayuParamsVo.getDeployDayuVmsParamsEntities())) {
            return validateVmsList;
        }
        if (CollectionUtils.isEmpty(dayuParamsVo.getDeployDayuVmsParamsEntities())) {
            validateVmsList.add(DayuParamsValidateUtils.getErrorMessage("param.vms.list.valid"));
        }
        return validateVmsList;
    }

    private static List<String> validateComponents(DayuParamsVo dayuParamsVo) {
        ArrayList<String> invalidTips = new ArrayList<String>();
        String componentType = Optional.ofNullable(dayuParamsVo).map(DayuParamsVo::getDayuBaseParams).map(DayuBaseParams::getComponentType).orElse("");
        if (CUSTOM.equals(componentType)) {
            String pacificFlag;
            String componentLists = Optional.ofNullable(dayuParamsVo).map(DayuParamsVo::getDayuBaseParams).map(DayuBaseParams::getComponentLists).orElse("");
            List<String> list = DayuParamsValidateUtils.validComponentsDependency(componentLists);
            if (CollectionUtils.isNotEmpty(list)) {
                invalidTips.addAll(list);
            }
            if (SACS.equals(pacificFlag = Optional.ofNullable(dayuParamsVo).map(DayuParamsVo::getPacificParams).map(PacificParams::getPacificFlag).orElse("")) && !componentLists.contains(HDFS)) {
                invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.components.sacs.hdfs.valid"));
            }
        }
        return invalidTips;
    }

    private static List<String> validComponentsDependency(String componentLists) {
        ArrayList<String> vmParamsInvalidTips = new ArrayList<String>();
        HashSet<String> stringSet = new HashSet<String>(){
            {
                this.add(DayuParamsValidateUtils.YARN);
                this.add(DayuParamsValidateUtils.SPARK);
                this.add(DayuParamsValidateUtils.HBASE);
                this.add(DayuParamsValidateUtils.FTP);
                this.add(DayuParamsValidateUtils.FLUME);
            }
        };
        if (stringSet.stream().anyMatch(vlaue -> componentLists.contains((CharSequence)vlaue) && !componentLists.contains(HDFS))) {
            vmParamsInvalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.components.hdfs.valid"));
        }
        if ((componentLists.contains(HIVE) || componentLists.contains(FLINK)) && !componentLists.contains(YARN)) {
            vmParamsInvalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.components.yarn.valid"));
        }
        if (componentLists.contains(SPARK) && !componentLists.contains(HIVE)) {
            vmParamsInvalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.components.hive.valid"));
        }
        if (componentLists.contains(HIVE) && !componentLists.contains(SPARK)) {
            vmParamsInvalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.components.spark.valid"));
        }
        return vmParamsInvalidTips;
    }

    private static List<String> validateVmParams(DayuParamsVo dayuParamsVo) {
        ArrayList<String> vmParamsInvalidTips = new ArrayList<String>();
        List<DeployDayuVmsParamsEntity> deployDayuVmsParamsEntities = dayuParamsVo.getDeployDayuVmsParamsEntities();
        if (deployDayuVmsParamsEntities.size() < 6) {
            vmParamsInvalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.valid"));
            return vmParamsInvalidTips;
        }
        if (!("cloudsop1".equals(deployDayuVmsParamsEntities.get(0).getHostName()) && "cloudsop2".equals(deployDayuVmsParamsEntities.get(1).getHostName()) && "cloudsop3".equals(deployDayuVmsParamsEntities.get(2).getHostName()))) {
            vmParamsInvalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.cloudsop.hostname.valid"));
        }
        if (!("ndp1".equals(deployDayuVmsParamsEntities.get(3).getHostName()) && "ndp2".equals(deployDayuVmsParamsEntities.get(4).getHostName()) && "ndp3".equals(deployDayuVmsParamsEntities.get(5).getHostName()))) {
            vmParamsInvalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.hostname.valid"));
        }
        for (int i = 6; i < deployDayuVmsParamsEntities.size(); ++i) {
            if (deployDayuVmsParamsEntities.get(i).getHostName().startsWith("ndp") && deployDayuVmsParamsEntities.get(i).getHostName().endsWith(String.valueOf(i - 2))) continue;
            vmParamsInvalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.extend.hostname.valid"));
        }
        deployDayuVmsParamsEntities.stream().forEach(deployDayuVmsParamsEntity -> DayuParamsValidateUtils.validVmParams(vmParamsInvalidTips, deployDayuVmsParamsEntity, dayuParamsVo));
        return vmParamsInvalidTips;
    }

    private static void validVmParams(List<String> vmParamsInvalidTips, DeployDayuVmsParamsEntity deployDayuVmsParamsEntity, DayuParamsVo dayuParamsVo) {
        List<String> ndpTips;
        List<String> cloudSopTips;
        if (deployDayuVmsParamsEntity.getVmTypeEnum() == VmTypeEnum.DAYU_CLOUD_SOP && CollectionUtils.isNotEmpty(cloudSopTips = DayuParamsValidateUtils.checkCloudSopParams(deployDayuVmsParamsEntity, dayuParamsVo))) {
            vmParamsInvalidTips.addAll(cloudSopTips);
        }
        if (deployDayuVmsParamsEntity.getVmTypeEnum() == VmTypeEnum.DAYU_COMPUTE_NODE && CollectionUtils.isNotEmpty(ndpTips = DayuParamsValidateUtils.checkNdpParams(DayuParamsValidateUtils.getNdpMinDataDisk(deployDayuVmsParamsEntity, dayuParamsVo), deployDayuVmsParamsEntity))) {
            vmParamsInvalidTips.addAll(ndpTips);
        }
    }

    private static int getNdpMinDataDisk(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity, DayuParamsVo dayuParamsVo) {
        List<String> dependencyList;
        int ndpDefaultDataDisk = DayuParamsValidateUtils.getNdpConfigNumber("ndp.data.disk.click.value", 500);
        List<String> componentLists = DayuParamsValidateUtils.buildFilledComponentList(dayuParamsVo);
        List<String> list = dependencyList = "ISAC".equals(dayuParamsVo.getPacificParams().getPacificFlag()) ? Arrays.asList(CLICK_HOUSE, HDFS, NDP_ES, NDP_STAR_ROCKS) : Arrays.asList(CLICK_HOUSE, NDP_ES, NDP_STAR_ROCKS);
        if (dependencyList.stream().anyMatch(component -> componentLists.contains(component) && !ndpMultimap.containsKey((Object)component.toLowerCase(Locale.ROOT)))) {
            return ndpDefaultDataDisk;
        }
        if (dependencyList.stream().anyMatch(component -> ndpMultimap.get((Object)component.toLowerCase(Locale.ROOT)).contains(deployDayuVmsParamsEntity.getHostName()))) {
            return ndpDefaultDataDisk;
        }
        return DayuParamsValidateUtils.getNdpConfigNumber("ndp.data.disk.default.value", 100);
    }

    private static List<String> checkNdpParams(int ndpMinDataDisk, DeployDayuVmsParamsEntity deployDayuVmsParamsEntity) {
        ArrayList<String> ndpTips = new ArrayList<String>();
        if (deployDayuVmsParamsEntity.getCpuCores() < 16) {
            ndpTips.add(DayuParamsValidateUtils.getErrorMessage("param.vm.ndp.cpu.valid", deployDayuVmsParamsEntity.getHostName()));
        }
        if (deployDayuVmsParamsEntity.getMemorySizeGb() < 64) {
            ndpTips.add(DayuParamsValidateUtils.getErrorMessage("param.vm.ndp.memory.valid", deployDayuVmsParamsEntity.getHostName()));
        }
        if (Objects.nonNull(deployDayuVmsParamsEntity.getDiskCmds()) && CollectionUtils.isNotEmpty(deployDayuVmsParamsEntity.getDiskCmds()) && deployDayuVmsParamsEntity.getDiskCmds().get(0).getQuantityGB() < 200) {
            ndpTips.add(DayuParamsValidateUtils.getErrorMessage("param.vm.ndp.service.disk.valid", deployDayuVmsParamsEntity.getHostName()));
        }
        if (Objects.nonNull(deployDayuVmsParamsEntity.getDiskCmds()) && CollectionUtils.isNotEmpty(deployDayuVmsParamsEntity.getDiskCmds()) && (deployDayuVmsParamsEntity.getDiskCmds().size() < 2 || deployDayuVmsParamsEntity.getDiskCmds().get(1).getQuantityGB() < ndpMinDataDisk)) {
            ndpTips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.vm.ndp.data.disk.valid"), (Object[])new Object[]{deployDayuVmsParamsEntity.getHostName(), ndpMinDataDisk}));
        }
        DayuParamsValidateUtils.checkNdpIp(deployDayuVmsParamsEntity, ndpTips);
        return ndpTips;
    }

    private static void checkNdpIp(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity, List<String> ndpTips) {
        if (Objects.isNull(deployDayuVmsParamsEntity.getNicConfigs())) {
            log.info("eDataInsight ndp network adapter information is null.");
            return;
        }
        if (deployDayuVmsParamsEntity.getNicConfigs().size() < 1) {
            ndpTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.nics.valid", deployDayuVmsParamsEntity.getHostName()));
        } else {
            String opIp = deployDayuVmsParamsEntity.getNicConfigs().get(0).getIp();
            if (StringUtils.isEmpty((CharSequence)opIp) || !IpUtils.isValidIpV4((String)opIp)) {
                ndpTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.ndp.nics.op.valid", deployDayuVmsParamsEntity.getHostName()));
            } else {
                eDataInsightIpMap.put(deployDayuVmsParamsEntity.getHostName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.dayu.vm.op.ip"), opIp);
            }
        }
    }

    private static List<String> checkCloudSopParams(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity, DayuParamsVo dayuParamsVo) {
        int minMemory;
        int minCpu;
        ArrayList<String> cloudSopTips = new ArrayList<String>();
        int n = minCpu = dayuParamsVo.getDeployDayuVmsParamsEntities().size() - 3 > DayuParamsValidateUtils.getNdpConfigNumber("cloud.ndp.default.number", 100) ? DayuParamsValidateUtils.getNdpConfigNumber("cloud.vm.cpu", 16) : DayuParamsValidateUtils.getNdpConfigNumber("cloud.vm.default.cpu", 8);
        if (deployDayuVmsParamsEntity.getCpuCores() < minCpu) {
            cloudSopTips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.vm.cloudSop.cpu.valid"), (Object[])new Object[]{deployDayuVmsParamsEntity.getHostName(), minCpu}));
        }
        int n2 = minMemory = dayuParamsVo.getDeployDayuVmsParamsEntities().size() - 3 > DayuParamsValidateUtils.getNdpConfigNumber("cloud.ndp.default.number", 100) ? DayuParamsValidateUtils.getNdpConfigNumber("cloud.vm.memory", 64) : DayuParamsValidateUtils.getNdpConfigNumber("cloud.vm.default.memory", 32);
        if (deployDayuVmsParamsEntity.getMemorySizeGb() < minMemory) {
            cloudSopTips.add(StringUtils.formatTxt((String)DayuParamsValidateUtils.getErrorMessage("param.vm.cloudSop.memory.valid"), (Object[])new Object[]{deployDayuVmsParamsEntity.getHostName(), minMemory}));
        }
        if (Objects.nonNull(deployDayuVmsParamsEntity.getDiskCmds()) && CollectionUtils.isNotEmpty(deployDayuVmsParamsEntity.getDiskCmds()) && deployDayuVmsParamsEntity.getDiskCmds().get(0).getQuantityGB() < 200) {
            cloudSopTips.add(DayuParamsValidateUtils.getErrorMessage("param.vm.cloudSop.service.disk.valid", deployDayuVmsParamsEntity.getHostName()));
        }
        DayuParamsValidateUtils.checkCloudSopIp(deployDayuVmsParamsEntity, dayuParamsVo, cloudSopTips);
        return cloudSopTips;
    }

    private static void checkCloudSopIp(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity, DayuParamsVo dayuParamsVo, List<String> cloudSopTips) {
        if (Objects.isNull(deployDayuVmsParamsEntity.getNicConfigs())) {
            log.info("eDataInsight cloudSop network adapter information is null.");
            return;
        }
        if (deployDayuVmsParamsEntity.getNicConfigs().size() < 2) {
            cloudSopTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.cloudsop.nics.valid", deployDayuVmsParamsEntity.getHostName()));
            return;
        }
        String opIp = deployDayuVmsParamsEntity.getNicConfigs().get(0).getIp();
        if (StringUtils.isEmpty((CharSequence)opIp) || !IpUtils.isValidIpV4((String)opIp) || IpUtils.isReachable((String)opIp)) {
            cloudSopTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.cloudsop.nics.op.valid", deployDayuVmsParamsEntity.getHostName()));
        } else {
            eDataInsightIpMap.put(deployDayuVmsParamsEntity.getHostName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.dayu.vm.op.ip"), opIp);
        }
        DayuParamsValidateUtils.checkOmIp(deployDayuVmsParamsEntity, dayuParamsVo, cloudSopTips);
    }

    private static void checkOmIp(DeployDayuVmsParamsEntity deployDayuVmsParamsEntity, DayuParamsVo dayuParamsVo, List<String> cloudSopTips) {
        String omIp = deployDayuVmsParamsEntity.getNicConfigs().get(1).getIp();
        if (MANUAL_DEPLOY.equals(dayuParamsVo.getDayuBaseParams().getVmDeployType())) {
            if (StringUtils.isEmpty((CharSequence)omIp) || !IpUtils.isValidIpV4((String)omIp) || !IpUtils.isReachable((String)omIp)) {
                cloudSopTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.cloudsop.nics.manual.om.valid", deployDayuVmsParamsEntity.getHostName()));
            }
            return;
        }
        if (StringUtils.isEmpty((CharSequence)omIp) || !IpUtils.isValidIpV4((String)omIp) || IpUtils.isReachable((String)omIp)) {
            cloudSopTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.cloudsop.nics.om.valid", deployDayuVmsParamsEntity.getHostName()));
        } else {
            eDataInsightIpMap.put(deployDayuVmsParamsEntity.getHostName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("deploy.template.header.dayu.vm.mp.ip"), omIp);
        }
        if (!DayuParamsValidateUtils.checkCloudIpInNetworkRange(omIp, dayuParamsVo)) {
            cloudSopTips.add(DayuParamsValidateUtils.getErrorMessage("param.dayu.vm.cloud.range.valid", deployDayuVmsParamsEntity.getHostName()));
        }
    }

    private static boolean checkCloudIpInNetworkRange(String omIp, DayuParamsVo dayuParamsVo) {
        if (Objects.nonNull(dayuParamsVo.getDayuBaseParams()) || StringUtils.isNotEmpty((CharSequence)dayuParamsVo.getDayuBaseParams().getFloatingMask()) || StringUtils.isNotEmpty((CharSequence)dayuParamsVo.getDayuBaseParams().getFloatingNetwork())) {
            return IpUtils.checkNetworkRangeValid((String)omIp, (String)dayuParamsVo.getDayuBaseParams().getFloatingMask(), (String)dayuParamsVo.getDayuBaseParams().getGateway());
        }
        return true;
    }

    private static Optional<String> validateSoftpackageFileExist(DayuParamsVo dayuParamsVo) {
        if (Objects.isNull(dayuParamsVo) || Objects.isNull(dayuParamsVo.getDayuBaseParams()) || StringUtils.isEmpty((CharSequence)dayuParamsVo.getDayuBaseParams().getSoftPackagePath())) {
            return Optional.empty();
        }
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{dayuParamsVo.getDayuBaseParams().getSoftPackagePath()})) {
            return Optional.of(DayuParamsValidateUtils.getErrorMessage("param.file.software.package.valid"));
        }
        if (!dayuParamsVo.getDayuBaseParams().getSoftPackagePath().endsWith(PACAKE_PATH_X86) && !dayuParamsVo.getDayuBaseParams().getSoftPackagePath().endsWith(PACAKE_PATH_ARM)) {
            return Optional.of(DayuParamsValidateUtils.getErrorMessage("param.file.software.package.valid"));
        }
        if (!ConsistencyCheckUtils.consistencyCheck((String)dayuParamsVo.getDayuBaseParams().getSoftPackagePath())) {
            return Optional.of(DayuParamsValidateUtils.getErrorMessage("param.file.software.consistency.valid"));
        }
        return Optional.empty();
    }

    private static Optional<String> validateTemplateFileExist(DayuParamsVo dayuParamsVo) {
        if (Objects.isNull(dayuParamsVo) || Objects.isNull(dayuParamsVo.getDayuTemplateInfo()) || StringUtils.isEmpty((CharSequence)dayuParamsVo.getDayuTemplateInfo().getFilepath())) {
            return Optional.empty();
        }
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{dayuParamsVo.getDayuTemplateInfo().getFilepath()})) {
            return Optional.of(DayuParamsValidateUtils.getErrorMessage("param.file.template.package.valid"));
        }
        if (!dayuParamsVo.getDayuTemplateInfo().getFilepath().endsWith(TEMPLATE_PATH_X86) && !dayuParamsVo.getDayuTemplateInfo().getFilepath().endsWith(TEMPLATE_PATH_ARM)) {
            return Optional.of(DayuParamsValidateUtils.getErrorMessage("param.file.template.package.valid"));
        }
        if (!ConsistencyCheckUtils.consistencyCheck((String)dayuParamsVo.getDayuTemplateInfo().getFilepath())) {
            return Optional.of(DayuParamsValidateUtils.getErrorMessage("param.file.template.consistency.valid"));
        }
        return Optional.empty();
    }

    private static List<String> validatePassword(DayuPassword dayuPassword) {
        ArrayList<String> passwordInvalidTips = new ArrayList<String>();
        Field[] declaredFields = dayuPassword.getClass().getDeclaredFields();
        Stream.of(declaredFields).forEach(field -> DayuParamsValidateUtils.getFiledValidResult(field, passwordInvalidTips, dayuPassword));
        return passwordInvalidTips;
    }

    private static void getFiledValidResult(Field field, List<String> passwordInvalidTips, DayuPassword dayuPassword) {
        field.setAccessible(true);
        try {
            String value = field.get(dayuPassword).toString();
            List<String> invalidTips = DayuParamsValidateUtils.commonPasswordCheck(value, field.getName());
            if (CollectionUtils.isNotEmpty(invalidTips)) {
                passwordInvalidTips.addAll(invalidTips);
            }
        }
        catch (IllegalAccessException e) {
            log.error("Get password filed value error", (Throwable)e);
        }
    }

    private static List<String> commonPasswordCheck(String pwd, String pwdName) {
        ArrayList<String> invalidTips = new ArrayList<String>();
        if (!Pattern.matches(CHARACTERS_MATCH_8_TO_64_DIGITS, pwd)) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.password.length.valid", pwdName));
        }
        if (!Pattern.matches(PASSWORD_NUM_LETTER, pwd)) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.password.type.valid", pwdName));
        }
        if (Pattern.matches(USER_PASSWORD_SPECIAL_CHAR_REG, pwd)) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.password.special.valid", pwdName));
        }
        if (Pattern.matches(CONTINUITY_SAME_CHARACTER, pwd)) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.password.Consecutive.same.valid", pwdName));
        }
        if (!Pattern.matches(MATCH_START, pwd)) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.password.exclamation.valid", pwdName));
        }
        if (DayuParamsValidateUtils.sameCharOverThreeTimes(pwd)) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.password.same.valid", pwdName));
        }
        if (DayuParamsValidateUtils.checkPassWordReverse(pwd)) {
            invalidTips.add(DayuParamsValidateUtils.getErrorMessage("param.password.revert.valid", pwdName));
        }
        return invalidTips;
    }

    private static boolean checkPassWordReverse(String passWord) {
        String passWordUpperCase = passWord.toUpperCase(Locale.ENGLISH);
        String passWordUpperCaseReverse = new StringBuffer(passWordUpperCase).reverse().toString();
        return Objects.equals(passWordUpperCase, passWordUpperCaseReverse);
    }

    private static boolean sameCharOverThreeTimes(String pwd) {
        HashMap charMap = new HashMap();
        return IntStream.range(0, pwd.length()).anyMatch(i -> DayuParamsValidateUtils.isSameCharOverThreeTimes(i, pwd, charMap));
    }

    private static boolean isSameCharOverThreeTimes(int i, String pwd, Map<Character, Integer> charMap) {
        char perChar = pwd.charAt(i);
        if (charMap.containsKey(Character.valueOf(perChar))) {
            if (charMap.get(Character.valueOf(perChar)) >= 3) {
                return true;
            }
            charMap.put(Character.valueOf(perChar), charMap.get(Character.valueOf(perChar)) + 1);
        } else {
            charMap.put(Character.valueOf(perChar), 1);
        }
        return false;
    }

    private static String getErrorMessage(String key, String param) {
        return String.format(Locale.ROOT, ResourceConfigLoader.getErrorMessage(key), param);
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private DayuParamsValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

