/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.validate;

import com.google.common.collect.ImmutableMap;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudConstant;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPasswordVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudServiceParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudVmVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HicloudParamsValidateUtils {
    private static final Logger log = LoggerFactory.getLogger(HicloudParamsValidateUtils.class);
    private static final int GKIT_MIN_CPU = 4;
    private static final int GKIT_MIN_MEMORY = 8;
    private static final int NO_GKIT_MIN_CPU = 8;
    private static final int NO_GKIT_MIN_MEMORY = 24;
    private static final int SYSTEM_DISK = 40;
    private static final Map<String, List<Integer>> vmsDataDisks = ImmutableMap.builder().put((Object)"paas-core", Arrays.asList(100, 1060, 50, 0)).put((Object)"platform-node1", Arrays.asList(100, 765, 200, 310)).put((Object)"platform-node2", Arrays.asList(100, 565, 100, 300)).put((Object)"platform-node3", Arrays.asList(100, 765, 200, 310)).put((Object)"gkit", Arrays.asList(200, 0, 0, 0)).build();

    public static Optional<String> validateHicloudParams(HiCloudParamVo hiCloudParamVo) {
        List<String> invalidTips = hiCloudParamVo.validate(0, new Class[0]);
        return CollectionUtils.isEmpty(invalidTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidTips));
    }

    public static List<String> valideParams(HiCloudParamVo hiCloudParamVo) {
        ArrayList<String> invalidTips = new ArrayList<String>();
        HicloudParamsValidateUtils.validateSoftwareFileExist(hiCloudParamVo).ifPresent(invalidTips::add);
        HicloudParamsValidateUtils.validateSamePassword(hiCloudParamVo).ifPresent(invalidTips::add);
        List<String> vmParamsInvalidTips = HicloudParamsValidateUtils.validateVmParams(hiCloudParamVo.getVmParams());
        List<String> ipInvalidTips = HicloudParamsValidateUtils.validateIP(hiCloudParamVo);
        List<String> validateOptionalIPTips = HicloudParamsValidateUtils.validateOptionalIP(hiCloudParamVo);
        if (CollectionUtils.isNotEmpty(vmParamsInvalidTips)) {
            invalidTips.addAll(vmParamsInvalidTips);
        }
        if (CollectionUtils.isNotEmpty(ipInvalidTips)) {
            invalidTips.addAll(ipInvalidTips);
        }
        if (CollectionUtils.isNotEmpty(validateOptionalIPTips)) {
            invalidTips.addAll(validateOptionalIPTips);
        }
        return invalidTips;
    }

    private static Optional<String> validateSamePassword(HiCloudParamVo hiCloudParamVo) {
        String tenantPassword;
        String opSvcCfePassword = Optional.of(hiCloudParamVo).map(HiCloudParamVo::getPassword).map(HiCloudPasswordVo::getSvcCfePwd).orElse("");
        if (!opSvcCfePassword.equals(tenantPassword = Optional.of(hiCloudParamVo).map(HiCloudParamVo::getPassword).map(HiCloudPasswordVo::getTenantPwd).orElse(""))) {
            return Optional.of(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.ip.not.same.valid"));
        }
        return Optional.empty();
    }

    static List<String> validateOptionalIP(HiCloudParamVo hiCloudParamVo) {
        ArrayList<String> validateOptionalIPTips = new ArrayList<String>();
        String paasManageNtpIp = Optional.of(hiCloudParamVo).map(HiCloudParamVo::getGeneral).map(HiCloudGeneralVo::getPaasManageNtpIp).orElse("");
        String dmeScIp = Optional.of(hiCloudParamVo).map(HiCloudParamVo::getService).map(HiCloudServiceParamVo::getDmeScIp).orElse("");
        String dmeOcIp = Optional.of(hiCloudParamVo).map(HiCloudParamVo::getService).map(HiCloudServiceParamVo::getDmeOcIp).orElse("");
        if (StringUtils.isNotEmpty((CharSequence)paasManageNtpIp)) {
            String[] paasNtpIps = paasManageNtpIp.split(",");
            HicloudParamsValidateUtils.validatePaasNtpIps(paasNtpIps, validateOptionalIPTips);
        }
        if (StringUtils.isNotEmpty((CharSequence)dmeScIp) && !IpUtils.isValidIpV4((String)dmeScIp)) {
            validateOptionalIPTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.paas.dme.scip.valid"));
        }
        if (StringUtils.isNotEmpty((CharSequence)dmeOcIp) && !IpUtils.isValidIpV4((String)dmeOcIp)) {
            validateOptionalIPTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.paas.dme.ocip.valid"));
        }
        return validateOptionalIPTips;
    }

    private static void validatePaasNtpIps(String[] paasNtpIps, List<String> validateOptionalIPTips) {
        boolean allIpIsValidIpV4 = Arrays.stream(paasNtpIps).allMatch(IpUtils::isValidIpV4);
        boolean anyIpIsReachable = Arrays.stream(paasNtpIps).anyMatch(IpUtils::isReachable);
        if (!allIpIsValidIpV4) {
            validateOptionalIPTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.paas.ntpip.format"));
        }
        if (!anyIpIsReachable) {
            validateOptionalIPTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.paas.ntpip.valid"));
        }
    }

    private static List<String> validateIP(HiCloudParamVo hiCloudParamVo) {
        ArrayList<String> ipInvalidTips = new ArrayList<String>();
        Map<String, String> ipMap = HicloudParamsValidateUtils.buildIpMap(hiCloudParamVo, ipInvalidTips);
        HicloudParamsValidateUtils.validateIpReachable(ipMap, ipInvalidTips);
        List<String> hiCloudIpRepeatabilityTips = CommonParamsValidateUtils.validateIpRepeatability(ipMap);
        if (CollectionUtils.isNotEmpty(hiCloudIpRepeatabilityTips)) {
            ipInvalidTips.addAll(hiCloudIpRepeatabilityTips);
        }
        String gateway = Optional.of(hiCloudParamVo).map(HiCloudParamVo::getPlan).map(HiCloudPlanVo::getGateway).orElse("");
        String mask = Optional.of(hiCloudParamVo).map(HiCloudParamVo::getPlan).map(HiCloudPlanVo::getMask).orElse("");
        HicloudParamsValidateUtils.validateIpSegment(ipMap, ipInvalidTips, gateway, mask);
        return ipInvalidTips;
    }

    private static void validateIpSegment(Map<String, String> ipMap, List<String> ipInvalidTips, String gateway, String mask) {
        if (StringUtils.isEmpty((CharSequence)gateway) || StringUtils.isEmpty((CharSequence)mask)) {
            ipInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.gateway.mask.valid"));
            return;
        }
        if (!IpUtils.isReachable((String)gateway)) {
            ipInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.gateway.ip.reachable.valid"));
        }
        for (Map.Entry<String, String> entry : ipMap.entrySet()) {
            if (IpUtils.checkNetworkRangeValid((String)entry.getValue(), (String)mask, (String)gateway)) continue;
            ipInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.ip.range.valid", entry.getKey()));
        }
    }

    private static boolean isGdeReservation(String ipAddress) {
        return HiCloudConfigUtils.getGdeReservationIpAddress().stream().anyMatch(reservedIp -> IpUtils.checkNetworkRangeValid((String)ipAddress, (String)HiCloudConfigUtils.getGdeReservationNetworkMask(), (String)reservedIp));
    }

    static void validateIpReachable(Map<String, String> ipMap, List<String> ipInvalidTips) {
        for (Map.Entry<String, String> entry : ipMap.entrySet()) {
            if (!IpUtils.isValidIpV4((String)entry.getValue())) {
                ipInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.ip.ipv4.valid", entry.getKey()));
            }
            if (HicloudParamsValidateUtils.isGdeReservation(entry.getValue())) {
                ipInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.ip.gde.reservation.valid", entry.getKey()));
            }
            if (HiCloudConstant.HICLOUD_NO_REACHABLE_IP.contains(entry.getKey()) || !IpUtils.isValidIpV4((String)entry.getValue()) || !IpUtils.isReachable((String)entry.getValue())) continue;
            ipInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.ip.reachable.valid", entry.getKey()));
        }
    }

    static Map<String, String> buildIpMap(HiCloudParamVo hiCloudParamVo, List<String> ipInvalidTips) {
        HashMap<String, String> ipMap = new HashMap<String, String>();
        Optional.of(hiCloudParamVo).filter(paramVo -> Objects.nonNull(paramVo.getGeneral())).map(HiCloudParamVo::getGeneral).ifPresent(generalVo -> ipMap.put("FusionCompute IP", generalVo.getFcIp()));
        Optional.of(hiCloudParamVo).filter(paramVo -> Objects.nonNull(paramVo.getPlan())).map(HiCloudParamVo::getPlan).ifPresent(planVo -> HicloudParamsValidateUtils.addPlanIP(planVo, ipMap));
        Optional.of(hiCloudParamVo).filter(paramVo -> Objects.nonNull(paramVo.getVmParams())).map(HiCloudParamVo::getVmParams).ifPresent(vmVoList -> HicloudParamsValidateUtils.addManageIp(vmVoList, ipMap, ipInvalidTips));
        return ipMap;
    }

    static void addManageIp(List<HiCloudVmVo> vmVoList, Map<String, String> ipMap, List<String> ipInvalidTips) {
        if (vmVoList.size() < 5) {
            ipInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.vm.number.valid"));
            return;
        }
        ipMap.put("HiCloud paas-core IP", vmVoList.get(0).getOmIp());
        ipMap.put("HiCloud platform-node1 IP", vmVoList.get(1).getOmIp());
        ipMap.put("HiCloud platform-node2 IP", vmVoList.get(2).getOmIp());
        ipMap.put("HiCloud platform-node3 IP", vmVoList.get(3).getOmIp());
        ipMap.put("HiCloud gkit IP", vmVoList.get(4).getOmIp());
    }

    private static void addPlanIP(HiCloudPlanVo planVo, Map<String, String> ipMap) {
        ipMap.put("HiCloud float IP", planVo.getFloatIp());
        ipMap.put("HiCloud keepalived VIP(1)", planVo.getKeepalivedVip1());
        ipMap.put("HiCloud keepalived VIP(2)", planVo.getKeepalivedVip2());
        ipMap.put("HiCloud keepalived VIP(3)", planVo.getKeepalivedVip3());
        ipMap.put("HiCloud gaussdb VIP", planVo.getGaussdbVip());
    }

    static List<String> validateVmParams(List<HiCloudVmVo> vmParams) {
        ArrayList<String> vmParamsInvalidTips = new ArrayList<String>();
        vmParams.forEach(hiCloudVmVo -> HicloudParamsValidateUtils.validateData(hiCloudVmVo, vmParamsInvalidTips));
        return vmParamsInvalidTips;
    }

    private static void validateData(HiCloudVmVo hiCloudVmVo, List<String> vmParamsInvalidTips) {
        List<String> vmList = Arrays.asList("paas-core", "platform-node1", "platform-node2", "platform-node3", "gkit");
        if (!vmList.contains(hiCloudVmVo.getHostName())) {
            vmParamsInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.vm.hostname.valid"));
            log.error("The VM hostname must be paas-core,platform-node1,platform-node2,platform-node3 or gkit");
            return;
        }
        if (hiCloudVmVo.getSysDisk() < 40) {
            vmParamsInvalidTips.add(StringUtils.formatTxt((String)HicloudParamsValidateUtils.getErrorMessage("param.hicloud.vm.system.disk.valid"), (Object[])new Object[]{hiCloudVmVo.getHostName(), 40}));
        }
        for (int i = 0; i < hiCloudVmVo.getDataDisks().size(); ++i) {
            int targetNumber = vmsDataDisks.get(hiCloudVmVo.getHostName()).get(i);
            if (hiCloudVmVo.getDataDisks().get(i) >= targetNumber) continue;
            vmParamsInvalidTips.add(StringUtils.formatTxt((String)HicloudParamsValidateUtils.getErrorMessage("param.hicloud.vm.data.disk.valid"), (Object[])new Object[]{hiCloudVmVo.getHostName(), i + 1, targetNumber}));
        }
        if (hiCloudVmVo.isGkit()) {
            if (!HicloudParamsValidateUtils.validateCPU(hiCloudVmVo.getCpu(), 4)) {
                vmParamsInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.gkit.cpu.valid", hiCloudVmVo.getHostName()));
            }
            if (!HicloudParamsValidateUtils.validateMemory(hiCloudVmVo.getMemory(), 8)) {
                vmParamsInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.gkit.memory.valid", hiCloudVmVo.getHostName()));
            }
        } else {
            if (!HicloudParamsValidateUtils.validateCPU(hiCloudVmVo.getCpu(), 8)) {
                vmParamsInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.nogkit.cpu.valid", hiCloudVmVo.getHostName()));
            }
            if (!HicloudParamsValidateUtils.validateMemory(hiCloudVmVo.getMemory(), 24)) {
                vmParamsInvalidTips.add(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.nogkit.memory.valid", hiCloudVmVo.getHostName()));
            }
        }
    }

    private static boolean validateCPU(int cpu, int minCpu) {
        return cpu >= minCpu;
    }

    private static boolean validateMemory(int memory, int minMemory) {
        return memory >= minMemory;
    }

    private static Optional<String> validateSoftwareFileExist(HiCloudParamVo hiCloudParamVo) {
        if (Objects.isNull(hiCloudParamVo) || Objects.isNull(hiCloudParamVo.getGeneral()) || StringUtils.isEmpty((CharSequence)hiCloudParamVo.getGeneral().getPackagePath())) {
            return Optional.empty();
        }
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{hiCloudParamVo.getGeneral().getPackagePath()})) {
            return Optional.of(HicloudParamsValidateUtils.getErrorMessage("param.hicloud.file.software.package.valid"));
        }
        return Optional.empty();
    }

    private static String getErrorMessage(String key, String pwdName) {
        return String.format(Locale.ROOT, ResourceConfigLoader.getErrorMessage(key), pwdName);
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private static String getExportHeader(String key) {
        return ResourceConfigLoader.getStringFromExportHeaderTemplate(key);
    }

    private HicloudParamsValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

