/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.validate;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnConstant;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnVmVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public class SdnParamsValidateUtils {
    private static final List<String> SDN_NO_REACHABLE_IP = Collections.singletonList(SdnParamsValidateUtils.getExportHeader("deploy.template.header.common.fc.ip"));

    public static Optional<String> validateSdnParams(SdnParamVo sdnParamVo) {
        List<String> invalidateTips = sdnParamVo.validate(0, new Class[0]);
        SdnParamsValidateUtils.validateParams(sdnParamVo, invalidateTips);
        return CollectionUtils.isEmpty(invalidateTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidateTips));
    }

    public static List<String> validateParams(SdnParamVo sdnParamVo, List<String> invalidateTips) {
        SdnParamsValidateUtils.validateSdnIp(sdnParamVo, invalidateTips);
        SdnParamsValidateUtils.validateTemplateExist(sdnParamVo, invalidateTips);
        SdnParamsValidateUtils.validateSdnVm(sdnParamVo, invalidateTips);
        return invalidateTips;
    }

    private static void validateSdnVm(SdnParamVo sdnParamVo, List<String> invalidateTips) {
        List<SdnVmVo> sdnVmVoList = Optional.of(sdnParamVo).map(SdnParamVo::getSdnVmVos).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(sdnVmVoList) || sdnVmVoList.size() != 3) {
            invalidateTips.add(SdnParamsValidateUtils.getErrorMessage("param.sdn.vm.number.valid"));
            return;
        }
        for (int i = 0; i < sdnVmVoList.size(); ++i) {
            if (SdnConstant.SDN_VM_HOSTNAME.get(i).equals(((SdnVmVo)sdnVmVoList.get(i)).getHostName())) continue;
            invalidateTips.add(StringUtils.formatTxt((String)SdnParamsValidateUtils.getErrorMessage("param.sdn.vm.hostname.valid"), (Object[])new Object[]{i + 1, SdnConstant.SDN_VM_HOSTNAME.get(i)}));
        }
        sdnVmVoList.forEach(sdnVmVo -> SdnParamsValidateUtils.validateVmSpecification(SdnParamsValidateUtils.chargeWhetherX86(sdnParamVo) ? 20 : 24, sdnVmVo, invalidateTips));
    }

    private static void validateVmSpecification(int cpu, SdnVmVo sdnVmVo, List<String> invalidateTips) {
        if (sdnVmVo.getCpu() < cpu) {
            invalidateTips.add(StringUtils.formatTxt((String)SdnParamsValidateUtils.getErrorMessage("param.sdn.vm.cpu.valid"), (Object[])new Object[]{sdnVmVo.getHostName(), cpu}));
        }
        if (sdnVmVo.getMemory() < 118) {
            invalidateTips.add(StringUtils.formatTxt((String)SdnParamsValidateUtils.getErrorMessage("param.sdn.vm.memory.valid"), (Object[])new Object[]{sdnVmVo.getHostName(), 118}));
        }
        if (sdnVmVo.getSysDisk() < 92) {
            invalidateTips.add(StringUtils.formatTxt((String)SdnParamsValidateUtils.getErrorMessage("param.sdn.vm.system.disk.valid"), (Object[])new Object[]{sdnVmVo.getHostName(), 92}));
        }
        if (sdnVmVo.getDataDisk() < 1108) {
            invalidateTips.add(StringUtils.formatTxt((String)SdnParamsValidateUtils.getErrorMessage("param.sdn.vm.data.disk.valid"), (Object[])new Object[]{sdnVmVo.getHostName(), 1108}));
        }
    }

    private static boolean chargeWhetherX86(SdnParamVo sdnParamVo) {
        String templatePath = Optional.of(sdnParamVo).map(SdnParamVo::getSdnGeneralVo).map(SdnGeneralVo::getPackagePath).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{templatePath})) {
            return true;
        }
        Optional<String> templateFile = Arrays.stream((Object[])Objects.requireNonNull(new File(templatePath).listFiles())).filter(file -> file.getName().matches("^iMasterNCEServerInstall_.*?_EulerOS2\\.10-vhd-(aarch64|x86-64)\\.zip$")).map(String::valueOf).findFirst();
        return templateFile.map(file -> file.contains("x86")).orElse(true);
    }

    private static void validateTemplateExist(SdnParamVo sdnParamVo, List<String> invalidateTips) {
        String templatePath = Optional.of(sdnParamVo).map(SdnParamVo::getSdnGeneralVo).map(SdnGeneralVo::getPackagePath).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{templatePath})) {
            invalidateTips.add(SdnParamsValidateUtils.getErrorMessage("param.sdn.template.file.valid"));
        }
    }

    private static void validateSdnIp(SdnParamVo sdnParamVo, List<String> invalidateTips) {
        Map<String, String> sdnIpMap = SdnParamsValidateUtils.buildSdnIpMap(sdnParamVo, invalidateTips);
        SdnParamsValidateUtils.validateSdnIpReachable(sdnIpMap, invalidateTips);
        List<String> sdnIpRepeatabilityTips = CommonParamsValidateUtils.validateIpRepeatability(sdnIpMap);
        if (CollectionUtils.isNotEmpty(sdnIpRepeatabilityTips)) {
            invalidateTips.addAll(sdnIpRepeatabilityTips);
        }
        SdnParamsValidateUtils.validateSdnIpSegment(sdnIpMap, sdnParamVo, invalidateTips);
    }

    private static void validateSdnIpSegment(Map<String, String> sdnIpMap, SdnParamVo sdnParamVo, List<String> invalidateTips) {
        String manageGateway = Optional.of(sdnParamVo).map(SdnParamVo::getSdnPlanVo).map(SdnPlanVo::getManageGateway).orElse("");
        String manageMask = Optional.of(sdnParamVo).map(SdnParamVo::getSdnPlanVo).map(SdnPlanVo::getManageMask).orElse("");
        if (StringUtils.isEmpty((CharSequence)manageGateway) || StringUtils.isEmpty((CharSequence)manageMask)) {
            invalidateTips.add(SdnParamsValidateUtils.getErrorMessage("param.sdn.gateway.mask.valid"));
            return;
        }
        if (!IpUtils.isReachable((String)manageGateway)) {
            invalidateTips.add(SdnParamsValidateUtils.getErrorMessage("param.sdn.gateway.reachable.valid"));
        }
        for (Map.Entry<String, String> entry : sdnIpMap.entrySet()) {
            if (entry.getKey().contains(SdnParamsValidateUtils.getExportHeader("deploy.template.header.sdn.service.ip")) || IpUtils.checkNetworkRangeValid((String)entry.getValue(), (String)manageMask, (String)manageGateway)) continue;
            invalidateTips.add(SdnParamsValidateUtils.getErrorMessage("param.sdn.ip.range.valid", entry.getKey()));
        }
    }

    private static void validateSdnIpReachable(Map<String, String> sdnIpMap, List<String> invalidateTips) {
        for (Map.Entry<String, String> entry : sdnIpMap.entrySet()) {
            if (!IpUtils.isValidIpV4((String)entry.getValue())) {
                invalidateTips.add(SdnParamsValidateUtils.getErrorMessage("param.sdn.ip.format.valid", entry.getKey()));
            }
            if (!IpUtils.isValidIpV4((String)entry.getValue()) || SDN_NO_REACHABLE_IP.contains(entry.getKey()) || !IpUtils.isReachable((String)entry.getValue())) continue;
            invalidateTips.add(SdnParamsValidateUtils.getErrorMessage("param.sdn.ip.reachable.valid", entry.getKey()));
        }
    }

    private static Map<String, String> buildSdnIpMap(SdnParamVo sdnParamVo, List<String> invalidateTips) {
        HashMap<String, String> sdnIpMap = new HashMap<String, String>();
        Optional.of(sdnParamVo).map(SdnParamVo::getSdnGeneralVo).ifPresent(sdnGeneralVo -> sdnIpMap.put(SdnParamsValidateUtils.getExportHeader("deploy.template.header.common.fc.ip"), sdnGeneralVo.getFcIp()));
        Optional.of(sdnParamVo).map(SdnParamVo::getSdnVmVos).ifPresent(sdnVmVos -> SdnParamsValidateUtils.addSfsVmIp(sdnVmVos, sdnIpMap));
        return sdnIpMap;
    }

    private static void addSfsVmIp(List<SdnVmVo> sdnVmVos, Map<String, String> sdnIpMap) {
        for (SdnVmVo sdnVmVo : sdnVmVos) {
            sdnIpMap.put(sdnVmVo.getHostName() + SdnParamsValidateUtils.getExportHeader("deploy.template.header.sdn.manage.ip"), sdnVmVo.getOmIp());
            sdnIpMap.put(sdnVmVo.getHostName() + SdnParamsValidateUtils.getExportHeader("deploy.template.header.sdn.service.ip"), sdnVmVo.getServiceIp());
        }
    }

    private static String getErrorMessage(String key, String name) {
        return String.format(Locale.ROOT, ResourceConfigLoader.getErrorMessage(key), name);
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private static String getExportHeader(String key) {
        return ResourceConfigLoader.getStringFromExportHeaderTemplate(key);
    }
}

