/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.validate;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsConstant;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsVmVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CommonParamsValidateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public class SfsParamsValidateUtils {
    private static final List<String> SFS_NO_REACHABLE_IP = Arrays.asList(SfsParamsValidateUtils.getExportHeader("deploy.template.header.common.fc.ip"), SfsParamsValidateUtils.getExportHeader("deploy.template.header.sfs.edme.ip"));
    private static final List<String> SFS_NO_SEGMENT_IP = Collections.singletonList(SfsParamsValidateUtils.getExportHeader("deploy.template.header.sfs.edme.ip"));

    public static Optional<String> validateSfsParams(SfsParamVo sfsParamVo) {
        List<String> invalidateTips = sfsParamVo.validate(0, new Class[0]);
        SfsParamsValidateUtils.validateParams(sfsParamVo, invalidateTips);
        return CollectionUtils.isEmpty(invalidateTips) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", invalidateTips));
    }

    public static List<String> validateParams(SfsParamVo sfsParamVo, List<String> invalidateTips) {
        SfsParamsValidateUtils.validateSfsIp(sfsParamVo, invalidateTips);
        SfsParamsValidateUtils.validateTemplateExist(sfsParamVo).ifPresent(invalidateTips::add);
        SfsParamsValidateUtils.validateSfsVm(sfsParamVo, invalidateTips);
        return invalidateTips;
    }

    private static void validateSfsVm(SfsParamVo sfsParamVo, List<String> invalidateTips) {
        List<SfsVmVo> sfsVmVoList = Optional.of(sfsParamVo).map(SfsParamVo::getSfsVmVo).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(sfsVmVoList) || sfsVmVoList.size() != 2) {
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.vm.number.valid"));
            return;
        }
        if (!sfsVmVoList.stream().allMatch(sfsVmVo -> SfsConstant.SFS_VM_HOSTNAME.contains(sfsVmVo.getHostName()))) {
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.vm.hostname.valid"));
        }
        sfsVmVoList.forEach(sfsVmVo -> SfsParamsValidateUtils.validateVmSpecification(sfsVmVo, invalidateTips));
    }

    private static void validateVmSpecification(SfsVmVo sfsVmVo, List<String> invalidateTips) {
        if (sfsVmVo.getCpu() < 8) {
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.vm.cpu.valid", sfsVmVo.getHostName()));
        }
        if (sfsVmVo.getMemory() < 8) {
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.vm.memory.valid", sfsVmVo.getHostName()));
        }
        if (sfsVmVo.getSysDisk() < 240) {
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.vm.system.disk.valid", sfsVmVo.getHostName()));
        }
    }

    private static Optional<String> validateTemplateExist(SfsParamVo sfsParamVo) {
        String templatePath = Optional.of(sfsParamVo).map(SfsParamVo::getSfsGeneralVo).map(SfsGeneralVo::getTemplatePath).orElse("");
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{templatePath})) {
            return Optional.of(SfsParamsValidateUtils.getErrorMessage("param.sfs.template.file.valid"));
        }
        return Optional.empty();
    }

    private static void validateSfsIp(SfsParamVo sfsParamVo, List<String> invalidateTips) {
        Map<String, String> sfsIpMap = SfsParamsValidateUtils.buildSfsIpMap(sfsParamVo, invalidateTips);
        SfsParamsValidateUtils.validateSfsIpReachable(sfsIpMap, invalidateTips);
        SfsParamsValidateUtils.validateSfsIpContinuity(sfsIpMap, invalidateTips);
        List<String> sfsIpRepeatabilityTips = CommonParamsValidateUtils.validateIpRepeatability(sfsIpMap);
        if (CollectionUtils.isNotEmpty(sfsIpRepeatabilityTips)) {
            invalidateTips.addAll(sfsIpRepeatabilityTips);
        }
        String gateway = Optional.of(sfsParamVo).map(SfsParamVo::getSfsPlanVo).map(SfsPlanVo::getGateway).orElse("");
        String netmask = Optional.of(sfsParamVo).map(SfsParamVo::getSfsPlanVo).map(SfsPlanVo::getNetmask).orElse("");
        SfsParamsValidateUtils.validateSfsIpSegment(sfsIpMap, invalidateTips, gateway, netmask);
    }

    private static void validateSfsIpContinuity(Map<String, String> sfsIpMap, List<String> invalidateTips) {
        String sfsDj01Ip = sfsIpMap.getOrDefault("SFS_DJ01" + SfsParamsValidateUtils.getExportHeader("deploy.template.header.sfs.vm.om.ip"), "");
        String sfsDj02Ip = sfsIpMap.getOrDefault("SFS_DJ02" + SfsParamsValidateUtils.getExportHeader("deploy.template.header.sfs.vm.om.ip"), "");
        if (!IpUtils.isValidIpV4((String)sfsDj01Ip) || !IpUtils.isValidIpV4((String)sfsDj02Ip)) {
            return;
        }
        if (SfsParamsValidateUtils.getIpLastNumber(sfsDj01Ip) != SfsParamsValidateUtils.getIpLastNumber(sfsDj02Ip) - 1) {
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.ip.continuity.valid"));
        }
    }

    private static int getIpLastNumber(String ip) {
        String[] ipParts = ip.split("\\.");
        return Integer.parseInt(ipParts[ipParts.length - 1]);
    }

    private static void validateSfsIpSegment(Map<String, String> sfsIpMap, List<String> invalidateTips, String gateway, String netmask) {
        if (StringUtils.isEmpty((CharSequence)gateway) || StringUtils.isEmpty((CharSequence)netmask)) {
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.gateway.mask.valid"));
            return;
        }
        if (!IpUtils.isReachable((String)gateway)) {
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.gateway.reachable.valid"));
        }
        for (Map.Entry<String, String> entry : sfsIpMap.entrySet()) {
            if (SFS_NO_SEGMENT_IP.contains(entry.getKey()) || IpUtils.checkNetworkRangeValid((String)entry.getValue(), (String)netmask, (String)gateway)) continue;
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.ip.range.valid", entry.getKey()));
        }
    }

    private static void validateSfsIpReachable(Map<String, String> sfsIpMap, List<String> invalidateTips) {
        for (Map.Entry<String, String> entry : sfsIpMap.entrySet()) {
            if (!IpUtils.isValidIpV4((String)entry.getValue())) {
                invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.ip.format.valid", entry.getKey()));
            }
            if (!IpUtils.isValidIpV4((String)entry.getValue()) || SFS_NO_REACHABLE_IP.contains(entry.getKey()) || !IpUtils.isReachable((String)entry.getValue())) continue;
            invalidateTips.add(SfsParamsValidateUtils.getErrorMessage("param.sfs.ip.reachable.valid", entry.getKey()));
        }
    }

    private static Map<String, String> buildSfsIpMap(SfsParamVo sfsParamVo, List<String> invalidateTips) {
        HashMap<String, String> sfsIpMap = new HashMap<String, String>();
        Optional.of(sfsParamVo).filter(paramVo -> Objects.nonNull(paramVo.getSfsGeneralVo())).map(SfsParamVo::getSfsGeneralVo).ifPresent(sfsGeneralVo -> sfsIpMap.put(SfsParamsValidateUtils.getExportHeader("deploy.template.header.common.fc.ip"), sfsGeneralVo.getFcIp()));
        Optional.of(sfsParamVo).filter(paramVo -> Objects.nonNull(paramVo.getSfsPlanVo())).map(SfsParamVo::getSfsPlanVo).ifPresent(sfsPlanVo -> SfsParamsValidateUtils.addSfsPlanIp(sfsPlanVo, sfsIpMap));
        Optional.of(sfsParamVo).filter(paramVo -> Objects.nonNull(paramVo.getSfsVmVo())).map(SfsParamVo::getSfsVmVo).ifPresent(sfsVmVos -> SfsParamsValidateUtils.addSfsVmManageIp(sfsVmVos, sfsIpMap));
        return sfsIpMap;
    }

    private static void addSfsVmManageIp(List<SfsVmVo> sfsVmVos, Map<String, String> sfsIpMap) {
        sfsVmVos.forEach(sfsVmVo -> sfsIpMap.put(sfsVmVo.getHostName() + SfsParamsValidateUtils.getExportHeader("deploy.template.header.sfs.vm.om.ip"), sfsVmVo.getOmIp()));
    }

    private static void addSfsPlanIp(SfsPlanVo sfsPlanVo, Map<String, String> sfsIpMap) {
        sfsIpMap.put(SfsParamsValidateUtils.getExportHeader("deploy.template.header.sfs.float.ip"), sfsPlanVo.getFloatIp());
        sfsIpMap.put(SfsParamsValidateUtils.getExportHeader("deploy.template.header.sfs.gauss.ip"), sfsPlanVo.getGaussDbIp());
        sfsIpMap.put(SfsParamsValidateUtils.getExportHeader("deploy.template.header.sfs.edme.ip"), sfsPlanVo.getEDmeIp());
    }

    private static String getErrorMessage(String key, String name) {
        return String.format(Locale.ROOT, ResourceConfigLoader.getErrorMessage(key), name);
    }

    private static String getErrorMessage(String key) {
        return ResourceConfigLoader.getErrorMessage(key);
    }

    private static String getExportHeader(String key) {
        return ResourceConfigLoader.getStringFromExportHeaderTemplate(key);
    }
}

