/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.utils.validate.fusioncubemigration;

import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamError;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.exception.DmeExceptionResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.utils.valid.DmeValidUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82Params;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82VmParams;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCubeBaseParams;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCubeNetworkParams;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCubePasswordParams;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public final class FusionCubeMigrationValidateUtils {
    public static Optional<String> validateParams(FusionCube82Params fusionCube82Params) {
        ArrayList<String> messages = new ArrayList<String>();
        FusionCubeMigrationValidateUtils.validateFcInfos(fusionCube82Params.getFusionCubeBaseParams()).ifPresent(messages::add);
        FusionCubeMigrationValidateUtils.validateManageMentPortGroup(fusionCube82Params.getFusionCubeBaseParams()).ifPresent(messages::add);
        FusionCubeMigrationValidateUtils.validatePassword(fusionCube82Params.getFusionCubePasswordParams(), messages);
        FusionCubeMigrationValidateUtils.validSegment(fusionCube82Params.getFusionCubeNetworkParams(), messages);
        FusionCubeMigrationValidateUtils.validIpReachable(fusionCube82Params, messages);
        FusionCubeMigrationValidateUtils.validEbackupAparams(fusionCube82Params, messages);
        return CollectionUtils.isEmpty(messages) ? Optional.empty() : Optional.of(String.join((CharSequence)"\uff1b", messages));
    }

    private static void validEbackupAparams(FusionCube82Params fusionCube82Params, List<String> messages) {
        if (CollectionUtils.isEmpty((Collection)fusionCube82Params.getFusionCube82VmParamsList()) || fusionCube82Params.getFusionCube82VmParamsList().size() != 4) {
            messages.add("fusioncube.migration.vm.empty");
            return;
        }
        fusionCube82Params.getFusionCube82VmParamsList().forEach(vmParam -> FusionCubeMigrationValidateUtils.validVmParams(vmParam, fusionCube82Params.getFusionCubeBaseParams(), messages));
    }

    private static void validVmParams(FusionCube82VmParams vmParam, FusionCubeBaseParams fusionCubeBaseParams, List<String> messages) {
        FusionCubeMigrationValidateUtils.validVmName(vmParam, messages);
        FusionCubeMigrationValidateUtils.validVmManagementIp(vmParam, fusionCubeBaseParams, messages);
        FusionCubeMigrationValidateUtils.validProductStoragePlaneIp(vmParam, messages);
        FusionCubeMigrationValidateUtils.validBackupStoragePlaneIp(vmParam, messages);
        FusionCubeMigrationValidateUtils.validProductStoragePlanePortGroup(vmParam, messages);
        FusionCubeMigrationValidateUtils.validBackupStoragePlanePortGroup(vmParam, messages);
        FusionCubeMigrationValidateUtils.validProductStoragePlaneMask(vmParam, messages);
        FusionCubeMigrationValidateUtils.validBackupStoragePlaneMask(vmParam, messages);
        FusionCubeMigrationValidateUtils.validCnaName(vmParam, messages);
        FusionCubeMigrationValidateUtils.validStorageName(vmParam, messages);
        FusionCubeMigrationValidateUtils.validCpuSize(vmParam, messages);
        FusionCubeMigrationValidateUtils.validMemorySize(vmParam, messages);
        FusionCubeMigrationValidateUtils.validSystemDiskSize(vmParam, messages);
        FusionCubeMigrationValidateUtils.validDataSystem(vmParam, messages);
    }

    private static void validDataSystem(FusionCube82VmParams vmParam, List<String> messages) {
        if (FusionCubeMigrationValidateUtils.isEbackupa(vmParam.getVmName()) || FusionCubeMigrationValidateUtils.isEbackupb(vmParam.getVmName())) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)vmParam.getDataDisk())) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.data.disk");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("param.not.empty"), lip));
        }
    }

    private static void validSystemDiskSize(FusionCube82VmParams vmParam, List<String> messages) {
        if (StringUtils.isEmpty((CharSequence)vmParam.getSystemDisk()) || Integer.parseInt(vmParam.getSystemDisk()) < 120) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.system.disk");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("fusioncube.migration.vm.system.disk.error"), lip));
        }
    }

    private static void validMemorySize(FusionCube82VmParams vmParam, List<String> messages) {
        if (StringUtils.isEmpty((CharSequence)vmParam.getMemory()) || Integer.parseInt(vmParam.getMemory()) < 16) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.memory");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("fusioncube.migration.vm.memory.error"), lip));
        }
    }

    private static void validCpuSize(FusionCube82VmParams vmParam, List<String> messages) {
        if (StringUtils.isEmpty((CharSequence)vmParam.getCpu()) || Integer.parseInt(vmParam.getCpu()) < 8) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.cpu");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("fusioncube.migration.vm.cpu.error"), lip));
        }
    }

    private static void validStorageName(FusionCube82VmParams vmParam, List<String> messages) {
        if (StringUtils.isEmpty((CharSequence)vmParam.getStorageName())) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.storage.name");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("param.not.empty"), lip));
        }
    }

    private static void validCnaName(FusionCube82VmParams vmParam, List<String> messages) {
        if (StringUtils.isEmpty((CharSequence)vmParam.getCna())) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.cna.name");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("param.not.empty"), lip));
        }
    }

    private static void validBackupStoragePlaneMask(FusionCube82VmParams vmParam, List<String> messages) {
        if (StringUtils.isEmpty((CharSequence)vmParam.getBackupStoragePortMask())) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.vm.backup.storage.mask");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("param.not.empty"), lip));
        }
    }

    private static void validProductStoragePlaneMask(FusionCube82VmParams vmParam, List<String> messages) {
        if (FusionCubeMigrationValidateUtils.isNfsa(vmParam.getVmName()) || FusionCubeMigrationValidateUtils.isNfsb(vmParam.getVmName())) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)vmParam.getProductionStorageMask())) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.vm.production.storage.mask");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("param.not.empty"), lip));
        }
    }

    private static void validBackupStoragePlanePortGroup(FusionCube82VmParams vmParam, List<String> messages) {
        if (StringUtils.isEmpty((CharSequence)vmParam.getBackupStoragePortGroup())) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.vm.backup.storage.port.group");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("param.not.empty"), lip));
        }
    }

    private static void validProductStoragePlanePortGroup(FusionCube82VmParams vmParam, List<String> messages) {
        if (FusionCubeMigrationValidateUtils.isNfsa(vmParam.getVmName()) || FusionCubeMigrationValidateUtils.isNfsb(vmParam.getVmName())) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)vmParam.getProductionStoragePortGroup())) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.vm.production.storage.port.group");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("param.not.empty"), lip));
        }
    }

    private static void validBackupStoragePlaneIp(FusionCube82VmParams vmParam, List<String> messages) {
        if (!IpUtils.isValidIpV4((String)vmParam.getBackupStorageIp())) {
            String lip = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.vm.backup.storage.ip");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("segment.format.error"), lip));
        }
    }

    private static void validProductStoragePlaneIp(FusionCube82VmParams vmParams, List<String> messages) {
        if (FusionCubeMigrationValidateUtils.isNfsa(vmParams.getVmName()) || FusionCubeMigrationValidateUtils.isNfsb(vmParams.getVmName())) {
            return;
        }
        if (!IpUtils.isValidIpV4((String)vmParams.getProductionStorageIp())) {
            String lip = vmParams.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.vm.production.storage.ip");
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("segment.format.error"), lip));
        }
    }

    private static void validVmManagementIp(FusionCube82VmParams vmParam, FusionCubeBaseParams fusionCubeBaseParams, List<String> messages) {
        String managementIpMessages = vmParam.getVmName() + ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.management.ip");
        if (IpUtils.isReachable((String)vmParam.getManagementIp())) {
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("ip.should.not.reachable"), managementIpMessages));
        }
        if (!IpUtils.checkNetworkRangeValid((String)vmParam.getManagementIp(), (String)fusionCubeBaseParams.getMask(), (String)fusionCubeBaseParams.getGateway())) {
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("ip.mask.gateway.in.same.segment"), managementIpMessages));
        }
    }

    private static void validVmName(FusionCube82VmParams vmParam, List<String> messages) {
        if (FusionCubeMigrationValidateUtils.isEbackupa(vmParam.getVmName())) {
            messages.add(String.format(ResourceConfigLoader.getStringFromExportHeaderTemplate("fusioncube.migration.vm.name.error"), vmParam.getVmName()));
        }
    }

    private static boolean isEbackupa(String vmName) {
        return "eBackup-A".equals(vmName);
    }

    private static boolean isEbackupb(String vmName) {
        return "eBackup-B".equals(vmName);
    }

    private static boolean isNfsa(String vmName) {
        return "nfs-A".equals(vmName);
    }

    private static boolean isNfsb(String vmName) {
        return "nfs-B".equals(vmName);
    }

    private static void validIpReachable(FusionCube82Params fusionCube82Params, List<String> messages) {
        if (IpUtils.isReachable((String)fusionCube82Params.getFusionCubeNetworkParams().getEbackupFloatIpA())) {
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("ip.should.not.reachable"), ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.ebackup.a.float.ip")));
        }
        if (IpUtils.isReachable((String)fusionCube82Params.getFusionCubeNetworkParams().getEbackupFloatIpB())) {
            messages.add(String.format(ResourceConfigLoader.getErrorMessage("ip.should.not.reachable"), ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.ebackup.b.float.ip")));
        }
    }

    private static void validSegment(FusionCubeNetworkParams fusionCubeNetworkParams, List<String> messages) {
        if (!IpUtils.checkSegment((String)fusionCubeNetworkParams.getManagementSegment())) {
            messages.add(FusionCubeMigrationValidateUtils.validateSegmentFormat(ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.management.segment")));
        }
        if (!IpUtils.checkSegment((String)fusionCubeNetworkParams.getStorageSegment())) {
            messages.add(FusionCubeMigrationValidateUtils.validateSegmentFormat(ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.storage.segment")));
        }
        if (!IpUtils.checkSegment((String)fusionCubeNetworkParams.getEbackupManagementSegment())) {
            messages.add(FusionCubeMigrationValidateUtils.validateSegmentFormat(ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.ebackup.management.segment")));
        }
        if (!IpUtils.checkSegment((String)fusionCubeNetworkParams.getEbackupStorageSegment())) {
            messages.add(FusionCubeMigrationValidateUtils.validateSegmentFormat(ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.ebackup.storage.segment")));
        }
    }

    private static String validateSegmentFormat(String paramKey) {
        return String.format(ResourceConfigLoader.getErrorMessage("segment.format.error"), paramKey);
    }

    private static void validatePassword(FusionCubePasswordParams fusionCubePasswordParams, List<String> messages) {
        FusionCubeMigrationValidateUtils.checkRootPassword(fusionCubePasswordParams.getRoot(), messages, ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.root.password"));
        FusionCubeMigrationValidateUtils.checkRootPassword(fusionCubePasswordParams.getHcp(), messages, ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.hcp.password"));
        FusionCubeMigrationValidateUtils.checkRootPassword(fusionCubePasswordParams.getMsuser(), messages, ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.msuser.password"));
    }

    private static void checkRootPassword(String password, List<String> messages, String header) {
        if (!DmeValidUtils.checkEDmePassword((String)password)) {
            messages.add(header + ":" + DmeExceptionResourceUtils.getErrorMessage((String)ParamError.PASSWORD_CHECK.getKey()));
        }
    }

    private static Optional<String> validateManageMentPortGroup(FusionCubeBaseParams fusionCubeBaseParams) {
        if (StringUtils.isEmpty((CharSequence)fusionCubeBaseParams.getPortGroup())) {
            return Optional.of(String.format(ResourceConfigLoader.getErrorMessage("param.not.empty"), ResourceConfigLoader.getStringFromExportHeaderTemplate("integrate.template.header.fusion.cube.8.2.x.port.group")));
        }
        return Optional.empty();
    }

    private static Optional<String> validateFcInfos(FusionCubeBaseParams fusionCubeBaseParams) {
        if (StringUtils.isEmpty((CharSequence)fusionCubeBaseParams.getFcIp()) || StringUtils.isEmpty((CharSequence)fusionCubeBaseParams.getFcUser()) || StringUtils.isEmpty((CharSequence)fusionCubeBaseParams.getFcPwd())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.fc.is.empty"));
        }
        return Optional.empty();
    }

    private FusionCubeMigrationValidateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

