/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cdrommount;

import com.huawei.ism.cdrommount.common.UmateException;
import com.huawei.ism.cdrommount.hwdiscover.model.HwDiscoverModel;
import com.huawei.ism.cdrommount.manage.MountThread;
import com.huawei.ism.cdrommount.manage.ParameterCheckManage;
import com.huawei.ism.cdrommount.model.ConnectModel;
import com.huawei.ism.cdrommount.model.MountModel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdRomMount {
    private static final Logger log = LoggerFactory.getLogger(CdRomMount.class);
    Iterator<String> iterator;
    private HwDiscoverModel snmpModel = null;
    private LinkedHashMap<String, ConnectModel> connModels;
    private LinkedHashMap<String, MountThread> threads;
    private LinkedHashMap<Integer, String> mountErrMsg;
    private LinkedHashMap<Integer, String> uMountErrMsg;

    public CdRomMount(MountModel model) {
        String[] args = new String[]{model.getIp(), model.getPath(), model.getUser(), model.getPwd(), model.getVmmPort(), model.getIpmiPort()};
        this.mountErrMsg = new LinkedHashMap();
        this.uMountErrMsg = new LinkedHashMap();
        ParameterCheckManage checkManage = new ParameterCheckManage();
        this.connModels = checkManage.check(args);
        if (this.connModels != null && !this.connModels.isEmpty()) {
            this.snmpModel = new HwDiscoverModel();
            try {
                this.snmpModel.setIPAddress(model.getIp());
                this.snmpModel.setUserName(model.getUser());
                this.snmpModel.setUserPassword(model.getPwd());
                this.snmpModel.setIPMIPort(model.getIpmiPort());
            }
            catch (UmateException e) {
                log.error("the HwDiscoverModel init error", (Throwable)e);
            }
        } else {
            log.error("{}:Check parameter failed.", (Object)model.getIp());
            this.mountErrMsg.put(0, "601");
        }
    }

    public boolean mount() throws InterruptedException {
        boolean ret = true;
        this.threads = new LinkedHashMap();
        this.iterator = this.connModels.keySet().iterator();
        while (this.iterator.hasNext()) {
            ConnectModel get = this.connModels.get(this.iterator.next());
            MountThread thread = new MountThread(get, this.snmpModel);
            thread.start();
            this.threads.put(Integer.toString(get.getBladeNO()), thread);
        }
        this.iterator = this.threads.keySet().iterator();
        int count = 0;
        while (this.iterator.hasNext()) {
            String next = this.iterator.next();
            MountThread th = this.threads.get(next);
            while (!th.isComplete()) {
                Thread.sleep(6000L);
                log.info("{}-{}:Mount thread is still running,sleep 5s.", (Object)this.snmpModel.getIpAddress(), (Object)th.getBladeNo());
                if (++count < 50) continue;
                log.error("{}-{}:Mount thread execute time out.", (Object)this.snmpModel.getIpAddress(), (Object)th.getBladeNo());
                th.join(1000L);
                this.mountErrMsg.put(th.getBladeNo(), "Mount time out.");
                ret = false;
                break;
            }
            if (!th.isMountRet()) {
                this.mountErrMsg.put(th.getBladeNo(), th.getMountErrMsg());
                log.error("{}-{}:Mount thread execute failed.", (Object)this.snmpModel.getIpAddress(), (Object)th.getBladeNo());
                ret = false;
            }
            log.info("{}-{}:Mount thread execute finish,return:{}", new Object[]{this.snmpModel.getIpAddress(), th.getBladeNo(), ret});
        }
        return ret;
    }

    public boolean uMount() {
        boolean ret = true;
        for (String next : this.threads.keySet()) {
            MountThread th = this.threads.get(next);
            th.setStop(true);
            try {
                th.join();
                if (th.isUmountRet()) continue;
                this.uMountErrMsg.put(th.getBladeNo(), th.getUmountErrMsg());
                ret = false;
            }
            catch (Exception var5) {
                ret = false;
            }
        }
        return ret;
    }
}

