/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cdrommount;

import com.huawei.vm.console.management.ConsoleControllers;
import com.huawei.vm.virtualconnection.VirtualConnect;
import java.awt.event.ActionEvent;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualConnectImg
extends VirtualConnect {
    private static final Logger log = LoggerFactory.getLogger(VirtualConnectImg.class);
    private static final int IMG = 1;
    private static final int PORT_VALID_START = 1;
    private static final int PORT_VALID_END = 65535;
    private static final int ERR_VIRCONN_OK = 0;
    private static final int ERR_VIRCONN_CONN_ALREADY_EXIST = 501;
    private static final int ERR_VIRCONN_PARA_TYPE_ERROR = 502;
    private static final int ERR_VIRCONN_PARA_IP_ERROR = 503;
    private static final int ERR_VIRCONN_PARA_PORT_ERROR = 504;
    private static final int ERR_VIRCONN_PARA_ISO_PATH_NULL = 505;
    private static final int ERR_VIRCONN_PARA_ISO_PATH_INVALID = 506;
    private static final int ERR_VIRCONN_CONN_NOT_EXIST = 507;
    private static final int ERR_VIRCONN_CREATE_FAILED_CONSOLE_NOT_ACTIVE = 508;
    private static final int ERR_VIRCONN_CREATE_FAILED_CONSOLE_STILL_IDLE = 509;
    private ConsoleControllers vmApplet = new ConsoleControllers();
    private javax.swing.Timer imgVMlink = null;
    private boolean vmmconnected = false;

    public VirtualConnectImg() {
        this.vmApplet.setLanguage("en");
    }

    public String getErrMsg(int errCode) {
        return this.vmApplet.getStatement(errCode);
    }

    public int connect(int type, String serverIp, int serverPort, long verifyID, String imgPath) {
        if (this.vmmconnected) {
            return 501;
        }
        return type != 1 ? 502 : this.createVMLink(1, serverIp, serverPort, verifyID, imgPath);
    }

    public int connect(int type, String serverIp, int serverPort, byte[] certifyID, byte[] salt, boolean bCodeKeyNego, boolean bSecret, String imagePath) {
        try {
            if (this.vmmconnected) {
                return 501;
            }
            if (type != 1) {
                return 502;
            }
            if (serverPort >= 1 && serverPort <= 65535) {
                try {
                    this.vmApplet.creatVMLink(1, imagePath, serverIp, serverPort, certifyID, false, bCodeKeyNego, salt, null, null, null, 1);
                }
                catch (Exception var12) {
                    Exception ex = var12;
                    log.error("{}:VMLink:", (Object)serverIp, (Object)ex);
                }
                try {
                    Thread.sleep(7000L);
                }
                catch (InterruptedException var11) {
                    InterruptedException e = var11;
                    log.error("thread sleep error", (Throwable)e);
                }
                return this.checkCdromVMConsole();
            }
            return 504;
        }
        catch (Exception var13) {
            return -1;
        }
    }

    public int disconnect() {
        if (!this.vmmconnected) {
            log.warn("[vmm] vmm connection not exists.");
            return 507;
        }
        this.disconnectVMLink(1);
        return 0;
    }

    private int createVMLink(int deviceType, String serverIP, int serverPort, long certifyID, String imagePath) {
        byte[] codeKey = new byte[]{(byte)(certifyID >> 24 & 0xFFL), (byte)(certifyID >> 16 & 0xFFL), (byte)(certifyID >> 8 & 0xFFL), (byte)(certifyID & 0xFFL)};
        try {
            if (this.vmApplet != null) {
                this.vmApplet.creatVMLink(deviceType, imagePath, serverIP, serverPort, codeKey, false, false, null, null, null, null, 1);
            }
        }
        catch (Exception var10) {
            log.error("{}:VMLink:", (Object)serverIP, (Object)var10);
        }
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException var9) {
            log.error("thread sleep error", (Throwable)var9);
        }
        return this.checkCdromVMConsole();
    }

    private void disconnectVMLink(int deviceType) {
        if (deviceType == 1) {
            this.vmApplet.destroyVMLink(deviceType);
            Timer timer = new Timer("cdrom disconnectVMLink");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    VirtualConnectImg.this.vmmconnected = false;
                }
            };
            timer.schedule(task, 2000L);
        }
    }

    private int checkCdromVMConsole() {
        int stateCode;
        if (!this.vmApplet.isConsoleOK(1)) {
            if (this.vmApplet.isVMLinkCrt(1)) {
                stateCode = this.getStateCode();
            } else {
                this.vmmconnected = false;
                this.vmApplet.destroyVMLink(1);
                stateCode = this.vmApplet.getConsoleState(1);
                if (stateCode == 0) {
                    stateCode = 508;
                    log.error("[vmm] Create vmm failed,console leaves idle state but still not active.");
                }
            }
        } else {
            this.vmmconnected = false;
            stateCode = this.vmApplet.getConsoleState(1);
            if (stateCode == 0) {
                stateCode = 509;
                log.error("[vmm] Create vmm failed,console initialization failed,still in idle state.");
            }
        }
        return stateCode;
    }

    private int getStateCode() {
        Timer date = new Timer("cdrom checkVMConsole");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (Objects.isNull(VirtualConnectImg.this.imgVMlink)) {
                    VirtualConnectImg.this.imgVMlink = new javax.swing.Timer(1000, VirtualConnectImg.this.doImgVMlink());
                }
                VirtualConnectImg.this.imgVMlink.start();
            }
        };
        date.schedule(task, 800L);
        this.vmmconnected = true;
        return 0;
    }

    private Action doImgVMlink() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!VirtualConnectImg.this.vmApplet.isVMLinkCrt(1)) {
                    VirtualConnectImg.this.imgVMlink.stop();
                    VirtualConnectImg.this.imgVMlink = null;
                    VirtualConnectImg.this.disconnectVMLink(1);
                }
            }
        };
    }

    public void setVmApplet(ConsoleControllers vmApplet) {
        this.vmApplet = vmApplet;
    }

    public ConsoleControllers getVmApplet() {
        return this.vmApplet;
    }
}

