/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cdrommount.manage;

import com.huawei.ism.cdrommount.GetVmmFlagByIpmi;
import com.huawei.ism.cdrommount.VirtualConnectImg;
import com.huawei.ism.cdrommount.hwdiscover.model.HwDiscoverModel;
import com.huawei.ism.cdrommount.model.ConnectModel;
import com.huawei.ism.cdrommount.model.SetVmmKeyByIpmi;
import com.huawei.vm.console.management.ConsoleControllers;
import com.huawei.vm.virtualconnection.VirtualConnect;
import com.huawei.vm.virtualconnection.impl.VirtualConnectISO;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(MountThread.class);
    private ConnectModel conn = null;
    private boolean isStop = false;
    private boolean isComplete = false;
    private boolean mountRet = false;
    private boolean umountRet = false;
    private HwDiscoverModel snmpModel = null;
    private String mErrMsg;
    private String umErrMsg;

    public MountThread(ConnectModel conn, HwDiscoverModel snmpModel) {
        super.setName("sdk_cdrom_mount_thread");
        this.conn = conn;
        this.snmpModel = snmpModel;
    }

    @Override
    public void run() {
        this.connectByIPMI(false);
        if (!this.mountRet) {
            this.connectByIPMI(true);
        }
    }

    private void connectByIPMI(Boolean isRetry) {
        try {
            Object ex = null;
            Object newVmmKey = null;
            VirtualConnectImg virtualConn = this.conn.getType() == 1 ? new VirtualConnectImg() : new VirtualConnectISO();
            if (isRetry.booleanValue()) {
                ConsoleControllers vmApplet = virtualConn.getVmApplet();
                vmApplet.setPbkdf2Params("PBKDF2WithHmacSHA1", 5000);
                virtualConn.setVmApplet(vmApplet);
            }
            String serverIp = this.conn.getServerIP();
            String imagePath = this.conn.getImagePath();
            GetVmmFlagByIpmi vmmFlagByIPMI = new GetVmmFlagByIpmi(this.snmpModel);
            int flag = vmmFlagByIPMI.getVmmFlag();
            log.info("{}:Vmm flag:{}", (Object)serverIp, (Object)flag);
            int serverPort = Integer.parseInt(this.conn.getVmmPort());
            log.info("{}:Server vmm port:{}", (Object)serverIp, (Object)serverPort);
            int retCode1 = flag != 1 && flag != 2 ? this.handleUnencryptVmmDevice(virtualConn, serverIp, imagePath, serverPort) : this.handleEncryptVmmDevice(virtualConn, serverIp, imagePath, flag, serverPort);
            if (this.handleVmmResult(isRetry, virtualConn, retCode1)) {
                return;
            }
            while (!this.isStop()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception var12) {
                    log.error("thread sleep error", (Throwable)var12);
                }
            }
            this.disconnectVmmDevice(virtualConn);
        }
        catch (Exception var13) {
            Exception ex = var13;
            if (isRetry.booleanValue()) {
                this.isComplete = true;
            }
            this.umErrMsg = "Mount failed:unknown error";
            log.error("{}:Connect vmm error.Errmsg:{}", (Object)this.conn.getServerIP(), (Object)ex.getMessage());
        }
    }

    private void disconnectVmmDevice(VirtualConnect virtualConn) {
        int retCode = virtualConn.disconnect();
        if (retCode != 0) {
            log.error("{}:Disconnect error,errcode:{} ,message:{}", new Object[]{this.conn.getServerIP(), retCode, virtualConn.getErrMsg(retCode)});
            this.umErrMsg = virtualConn.getErrMsg(retCode);
        } else {
            this.umountRet = true;
            log.info("{}:Disconnect vmm success.", (Object)this.conn.getServerIP());
        }
    }

    private boolean handleVmmResult(Boolean isRetry, VirtualConnect virtualConn, int retCode1) {
        if (retCode1 != 0) {
            if (isRetry.booleanValue()) {
                this.isComplete = true;
            }
            log.error("{}:Connect error,errcode1:{}, message:{}", new Object[]{this.conn.getServerIP(), retCode1, virtualConn.getErrMsg(retCode1)});
            this.mErrMsg = virtualConn.getErrMsg(retCode1);
            return true;
        }
        this.isComplete = true;
        this.mountRet = true;
        log.info("{}:Create vmm success encrypted.", (Object)this.conn.getServerIP());
        return false;
    }

    private int handleUnencryptVmmDevice(VirtualConnect virtualConn, String serverIp, String imagePath, int serverPort) {
        log.info("{}:Can not get vmm flag,connect in unencrypted mode", (Object)serverIp);
        long id = this.getVerifyId();
        SetVmmKeyByIpmi newVmmKey = new SetVmmKeyByIpmi(this.snmpModel, id);
        boolean ret = newVmmKey.execSNMPCommand();
        if (!ret) {
            log.warn("{}:Set vmm key failed.", (Object)serverIp);
        }
        return virtualConn.connect(this.conn.getType(), serverIp, serverPort, id, imagePath);
    }

    private int handleEncryptVmmDevice(VirtualConnect virtualConn, String serverIp, String imagePath, int flag, int serverPort) {
        int retCode1;
        SetVmmKeyByIpmi newVmmKey = new SetVmmKeyByIpmi(this.snmpModel, null);
        log.info("{}:Set vmm key by ipmi.", (Object)serverIp);
        boolean ret = newVmmKey.execSNMPCommand();
        if (!ret) {
            log.info("{}:Set vmm key failed,connect in unencrypted mode.", (Object)serverIp);
            long id = this.getVerifyId();
            retCode1 = virtualConn.connect(this.conn.getType(), serverIp, serverPort, id, imagePath);
        } else {
            log.info("{}:Set vmm key success,connect in encrypted mode.", (Object)serverIp);
            String vmmKeyStr = newVmmKey.getVmmKey().replaceAll(" ", "").replaceAll("0x", "");
            String hex20 = vmmKeyStr.substring(0, 40);
            String hex16 = vmmKeyStr.substring(40);
            byte[] hex16bytes = SetVmmKeyByIpmi.convertSecretKeyToBytes(hex16, 16);
            byte[] hex20bytes = SetVmmKeyByIpmi.convertSecretKeyToBytes(hex20, 20);
            boolean bSecret = flag != 1;
            retCode1 = virtualConn.connect(this.conn.getType(), serverIp, serverPort, hex20bytes, hex16bytes, true, bSecret, imagePath);
        }
        return retCode1;
    }

    public String getMountErrMsg() {
        return this.mErrMsg;
    }

    public String getUmountErrMsg() {
        return this.umErrMsg;
    }

    public int getBladeNo() {
        return this.conn.getBladeNO();
    }

    private long getVerifyId() {
        SecureRandom random = new SecureRandom();
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < 7; ++i) {
            stringBuffer.append(random.nextInt(10));
        }
        return Long.parseLong(stringBuffer.toString());
    }

    public ConnectModel getConn() {
        return this.conn;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isMountRet() {
        return this.mountRet;
    }

    public boolean isUmountRet() {
        return this.umountRet;
    }

    public HwDiscoverModel getSnmpModel() {
        return this.snmpModel;
    }

    public String getMErrMsg() {
        return this.mErrMsg;
    }

    public String getUmErrMsg() {
        return this.umErrMsg;
    }

    public void setStop(boolean isStop) {
        this.isStop = isStop;
    }
}

