/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cdrommount.manage;

import com.huawei.ism.cdrommount.model.ConnectModel;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterCheckManage {
    private static final Logger log = LoggerFactory.getLogger(ParameterCheckManage.class);
    private String serverIP;
    private String imagePath;
    private String hmmPwd;
    private String bladeNO = "";
    private String fileType = "2";

    public LinkedHashMap<String, ConnectModel> check(String[] args) {
        if (args.length != 9 && args.length != 6 && args.length != 7 && args.length != 10) {
            log.error("{}:Parameter error.", (Object)args[0]);
            return new LinkedHashMap<String, ConnectModel>();
        }
        String authProtocol = "";
        String privacyProtocol = "";
        this.bladeNO = "";
        String snmpVer = "";
        String vmmPort = "";
        this.fileType = "2";
        this.serverIP = args[0];
        this.imagePath = args[1];
        this.hmmPwd = args[3];
        vmmPort = args[4];
        if (this.validIp(this.serverIP)) {
            return new LinkedHashMap<String, ConnectModel>();
        }
        if (this.validProtocol(args, this.serverIP, authProtocol, privacyProtocol, snmpVer)) {
            return new LinkedHashMap<String, ConnectModel>();
        }
        LinkedHashMap<String, ConnectModel> connModels = new LinkedHashMap<String, ConnectModel>();
        if (args.length >= 9) {
            this.bladeNO = this.bladeNO.replaceAll("\uff0c", ",");
            LinkedHashMap<String, ConnectModel> connModels1 = this.handleAllBladeDevice(connModels);
            if (connModels1 != null) {
                return connModels1;
            }
            if (this.handleEachBladeDevice(connModels)) {
                return new LinkedHashMap<String, ConnectModel>();
            }
        } else {
            this.handleDeviceArgs(vmmPort, connModels);
        }
        return connModels;
    }

    private void handleDeviceArgs(String vmmPort, LinkedHashMap<String, ConnectModel> connModels) {
        ConnectModel conn = new ConnectModel();
        conn.setServerIP(this.serverIP);
        conn.setImagePath(this.imagePath);
        conn.setPwd(this.hmmPwd);
        conn.setConnType(1);
        conn.setVmmPort(vmmPort);
        if ("1".equals(this.fileType)) {
            conn.setType(1);
        } else {
            conn.setType(2);
        }
        connModels.put(Integer.toString(0), conn);
    }

    private boolean handleEachBladeDevice(LinkedHashMap<String, ConnectModel> connModels) {
        String[] split;
        String[] var9 = split = this.bladeNO.split(",");
        int var10 = split.length;
        for (int var11 = 0; var11 < var10; ++var11) {
            String sub = var9[var11];
            try {
                int parseInt = Integer.parseInt(sub);
                if (parseInt > 32) {
                    log.info("{}:bladeNO > {}", (Object)this.serverIP, (Object)32);
                    return true;
                }
                ConnectModel conn = new ConnectModel();
                conn.setServerIP(this.serverIP);
                conn.setImagePath(this.imagePath);
                conn.setBladeNO(parseInt);
                conn.setBladeIndex(parseInt);
                conn.setPwd(this.hmmPwd);
                conn.setConnType(0);
                if ("1".equals(this.fileType)) {
                    conn.setType(1);
                } else {
                    conn.setType(2);
                }
                connModels.put(Integer.toString(parseInt), conn);
                continue;
            }
            catch (Exception var14) {
                log.error("{}:Blade{} contain non-numeric characters.", (Object)this.serverIP, (Object)this.bladeNO);
                return true;
            }
        }
        return false;
    }

    private LinkedHashMap<String, ConnectModel> handleAllBladeDevice(LinkedHashMap<String, ConnectModel> connModels) {
        if ("all".equalsIgnoreCase(this.bladeNO)) {
            for (int index = 0; index < 32; ++index) {
                ConnectModel conn = new ConnectModel();
                conn.setServerIP(this.serverIP);
                conn.setImagePath(this.imagePath);
                conn.setBladeNO(index + 1);
                conn.setBladeIndex(index + 1);
                conn.setPwd(this.hmmPwd);
                conn.setConnType(0);
                if ("1".equals(this.fileType)) {
                    conn.setType(1);
                } else {
                    conn.setType(2);
                }
                connModels.put(Integer.toString(index), conn);
            }
            return connModels;
        }
        return new LinkedHashMap<String, ConnectModel>();
    }

    private boolean validProtocol(String[] args, String serverIP, String authProtocol, String privacyProtocol, String snmpVer) {
        if (args.length == 9) {
            if (!"MD5".equals(authProtocol) && !authProtocol.contains("SHA")) {
                log.error("{}:Authentication protocol must be MD5 or SHA.", (Object)serverIP);
                return true;
            }
            if (!"DES".equals(privacyProtocol) && !privacyProtocol.contains("AES")) {
                log.error("{}:Privacy protocol must be DES or AES.", (Object)serverIP);
                return true;
            }
            if (!("V1".equals(snmpVer) || "V2".equals(snmpVer) || "V3".equals(snmpVer))) {
                log.info("{}:Snmp version must be V1,V2 or V3.", (Object)serverIP);
                return true;
            }
        }
        return false;
    }

    private boolean validIp(String serverIP) {
        if (!StringUtils.allIsVaildIpv4((String[])new String[]{serverIP}) && !StringUtils.allIsVaildIpv6((String[])new String[]{serverIP})) {
            log.error("{}:ServerIP does not meet specifications.", (Object)serverIP);
            return true;
        }
        return false;
    }
}

