/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.python.google.common.annotations.GwtCompatible;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableMultiset;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.Maps;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.Multisets;
import org.python.google.common.primitives.Ints;

@GwtCompatible
final class JdkBackedImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    private transient ImmutableSet<E> elementSet;

    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> entries) {
        Object[] entriesArray = entries.toArray(new Multiset.Entry[0]);
        HashMap delegateMap = Maps.newHashMapWithExpectedSize(entriesArray.length);
        long size = 0L;
        for (int i = 0; i < entriesArray.length; ++i) {
            Multiset.Entry entry = entriesArray[i];
            int count2 = entry.getCount();
            size += (long)count2;
            Object element = Preconditions.checkNotNull(entry.getElement());
            delegateMap.put(element, count2);
            if (entry instanceof Multisets.ImmutableEntry) continue;
            entriesArray[i] = Multisets.immutableEntry(element, count2);
        }
        return new JdkBackedImmutableMultiset(delegateMap, ImmutableList.asImmutableList(entriesArray), size);
    }

    private JdkBackedImmutableMultiset(Map<E, Integer> delegateMap, ImmutableList<Multiset.Entry<E>> entries, long size) {
        this.delegateMap = delegateMap;
        this.entries = entries;
        this.size = size;
    }

    @Override
    public int count(@Nullable Object element) {
        return this.delegateMap.getOrDefault(element, 0);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> result2 = this.elementSet;
        return result2 == null ? (this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this)) : result2;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return (Multiset.Entry)this.entries.get(index);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }
}

