/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SoftCache;
import org.python.icu.impl.TextTrieMap;
import org.python.icu.impl.ZoneMeta;
import org.python.icu.text.LocaleDisplayNames;
import org.python.icu.text.TimeZoneFormat;
import org.python.icu.text.TimeZoneNames;
import org.python.icu.util.BasicTimeZone;
import org.python.icu.util.Freezable;
import org.python.icu.util.Output;
import org.python.icu.util.TimeZone;
import org.python.icu.util.TimeZoneTransition;
import org.python.icu.util.ULocale;

public class TimeZoneGenericNames
implements Serializable,
Freezable<TimeZoneGenericNames> {
    private static final long serialVersionUID = 2729910342063468417L;
    private final ULocale _locale;
    private TimeZoneNames _tznames;
    private volatile transient boolean _frozen;
    private transient String _region;
    private transient WeakReference<LocaleDisplayNames> _localeDisplayNamesRef;
    private transient MessageFormat[] _patternFormatters;
    private transient ConcurrentHashMap<String, String> _genericLocationNamesMap;
    private transient ConcurrentHashMap<String, String> _genericPartialLocationNamesMap;
    private transient TextTrieMap<NameInfo> _gnamesTrie;
    private transient boolean _gnamesTrieFullyLoaded;
    private static Cache GENERIC_NAMES_CACHE = new Cache();
    private static final long DST_CHECK_RANGE = 15897600000L;
    private static final TimeZoneNames.NameType[] GENERIC_NON_LOCATION_TYPES = new TimeZoneNames.NameType[]{TimeZoneNames.NameType.LONG_GENERIC, TimeZoneNames.NameType.SHORT_GENERIC};

    public TimeZoneGenericNames(ULocale locale2, TimeZoneNames tznames) {
        this._locale = locale2;
        this._tznames = tznames;
        this.init();
    }

    private void init() {
        if (this._tznames == null) {
            this._tznames = TimeZoneNames.getInstance(this._locale);
        }
        this._genericLocationNamesMap = new ConcurrentHashMap();
        this._genericPartialLocationNamesMap = new ConcurrentHashMap();
        this._gnamesTrie = new TextTrieMap(true);
        this._gnamesTrieFullyLoaded = false;
        TimeZone tz = TimeZone.getDefault();
        String tzCanonicalID = ZoneMeta.getCanonicalCLDRID(tz);
        if (tzCanonicalID != null) {
            this.loadStrings(tzCanonicalID);
        }
    }

    private TimeZoneGenericNames(ULocale locale2) {
        this(locale2, (TimeZoneNames)null);
    }

    public static TimeZoneGenericNames getInstance(ULocale locale2) {
        String key = locale2.getBaseName();
        return (TimeZoneGenericNames)GENERIC_NAMES_CACHE.getInstance(key, locale2);
    }

    public String getDisplayName(TimeZone tz, GenericNameType type, long date) {
        String name = null;
        String tzCanonicalID = null;
        switch (type) {
            case LOCATION: {
                tzCanonicalID = ZoneMeta.getCanonicalCLDRID(tz);
                if (tzCanonicalID == null) break;
                name = this.getGenericLocationName(tzCanonicalID);
                break;
            }
            case LONG: 
            case SHORT: {
                name = this.formatGenericNonLocationName(tz, type, date);
                if (name != null || (tzCanonicalID = ZoneMeta.getCanonicalCLDRID(tz)) == null) break;
                name = this.getGenericLocationName(tzCanonicalID);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGenericLocationName(String canonicalTzID) {
        if (canonicalTzID == null || canonicalTzID.length() == 0) {
            return null;
        }
        String name = this._genericLocationNamesMap.get(canonicalTzID);
        if (name != null) {
            if (name.length() == 0) {
                return null;
            }
            return name;
        }
        Output<Boolean> isPrimary = new Output<Boolean>();
        String countryCode = ZoneMeta.getCanonicalCountry(canonicalTzID, isPrimary);
        if (countryCode != null) {
            if (((Boolean)isPrimary.value).booleanValue()) {
                String country = this.getLocaleDisplayNames().regionDisplayName(countryCode);
                name = this.formatPattern(Pattern.REGION_FORMAT, country);
            } else {
                String city = this._tznames.getExemplarLocationName(canonicalTzID);
                name = this.formatPattern(Pattern.REGION_FORMAT, city);
            }
        }
        if (name == null) {
            this._genericLocationNamesMap.putIfAbsent(canonicalTzID.intern(), "");
        } else {
            TimeZoneGenericNames timeZoneGenericNames = this;
            synchronized (timeZoneGenericNames) {
                canonicalTzID = canonicalTzID.intern();
                String tmp = this._genericLocationNamesMap.putIfAbsent(canonicalTzID, name.intern());
                if (tmp == null) {
                    NameInfo info = new NameInfo(canonicalTzID, GenericNameType.LOCATION);
                    this._gnamesTrie.put(name, info);
                } else {
                    name = tmp;
                }
            }
        }
        return name;
    }

    public TimeZoneGenericNames setFormatPattern(Pattern patType, String patStr) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (!this._genericLocationNamesMap.isEmpty()) {
            this._genericLocationNamesMap = new ConcurrentHashMap();
        }
        if (!this._genericPartialLocationNamesMap.isEmpty()) {
            this._genericPartialLocationNamesMap = new ConcurrentHashMap();
        }
        this._gnamesTrie = null;
        this._gnamesTrieFullyLoaded = false;
        if (this._patternFormatters == null) {
            this._patternFormatters = new MessageFormat[Pattern.values().length];
        }
        this._patternFormatters[patType.ordinal()] = new MessageFormat(patStr);
        return this;
    }

    private String formatGenericNonLocationName(TimeZone tz, GenericNameType type, long date) {
        assert (type == GenericNameType.LONG || type == GenericNameType.SHORT);
        String tzID = ZoneMeta.getCanonicalCLDRID(tz);
        if (tzID == null) {
            return null;
        }
        TimeZoneNames.NameType nameType = type == GenericNameType.LONG ? TimeZoneNames.NameType.LONG_GENERIC : TimeZoneNames.NameType.SHORT_GENERIC;
        String name = this._tznames.getTimeZoneDisplayName(tzID, nameType);
        if (name != null) {
            return name;
        }
        String mzID = this._tznames.getMetaZoneID(tzID, date);
        if (mzID != null) {
            String mzName;
            TimeZoneNames.NameType stdNameType;
            String stdName;
            boolean useStandard = false;
            int[] offsets = new int[]{0, 0};
            tz.getOffset(date, false, offsets);
            if (offsets[1] == 0) {
                useStandard = true;
                if (tz instanceof BasicTimeZone) {
                    BasicTimeZone btz = (BasicTimeZone)tz;
                    TimeZoneTransition before = btz.getPreviousTransition(date, true);
                    if (before != null && date - before.getTime() < 15897600000L && before.getFrom().getDSTSavings() != 0) {
                        useStandard = false;
                    } else {
                        TimeZoneTransition after = btz.getNextTransition(date, false);
                        if (after != null && after.getTime() - date < 15897600000L && after.getTo().getDSTSavings() != 0) {
                            useStandard = false;
                        }
                    }
                } else {
                    int[] tmpOffsets = new int[2];
                    tz.getOffset(date - 15897600000L, false, tmpOffsets);
                    if (tmpOffsets[1] != 0) {
                        useStandard = false;
                    } else {
                        tz.getOffset(date + 15897600000L, false, tmpOffsets);
                        if (tmpOffsets[1] != 0) {
                            useStandard = false;
                        }
                    }
                }
            }
            if (useStandard && (stdName = this._tznames.getDisplayName(tzID, stdNameType = nameType == TimeZoneNames.NameType.LONG_GENERIC ? TimeZoneNames.NameType.LONG_STANDARD : TimeZoneNames.NameType.SHORT_STANDARD, date)) != null) {
                name = stdName;
                String mzGenericName = this._tznames.getMetaZoneDisplayName(mzID, nameType);
                if (stdName.equalsIgnoreCase(mzGenericName)) {
                    name = null;
                }
            }
            if (name == null && (mzName = this._tznames.getMetaZoneDisplayName(mzID, nameType)) != null) {
                String goldenID = this._tznames.getReferenceZoneID(mzID, this.getTargetRegion());
                if (goldenID != null && !goldenID.equals(tzID)) {
                    TimeZone goldenZone = TimeZone.getFrozenTimeZone(goldenID);
                    int[] offsets1 = new int[]{0, 0};
                    goldenZone.getOffset(date + (long)offsets[0] + (long)offsets[1], true, offsets1);
                    name = offsets[0] != offsets1[0] || offsets[1] != offsets1[1] ? this.getPartialLocationName(tzID, mzID, nameType == TimeZoneNames.NameType.LONG_GENERIC, mzName) : mzName;
                } else {
                    name = mzName;
                }
            }
        }
        return name;
    }

    private synchronized String formatPattern(Pattern pat, String ... args) {
        int idx;
        if (this._patternFormatters == null) {
            this._patternFormatters = new MessageFormat[Pattern.values().length];
        }
        if (this._patternFormatters[idx = pat.ordinal()] == null) {
            String patText;
            try {
                ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt62b/zone", this._locale);
                patText = bundle.getStringWithFallback("zoneStrings/" + pat.key());
            }
            catch (MissingResourceException e) {
                patText = pat.defaultValue();
            }
            this._patternFormatters[idx] = new MessageFormat(patText);
        }
        return this._patternFormatters[idx].format(args);
    }

    private synchronized LocaleDisplayNames getLocaleDisplayNames() {
        LocaleDisplayNames locNames = null;
        if (this._localeDisplayNamesRef != null) {
            locNames = (LocaleDisplayNames)this._localeDisplayNamesRef.get();
        }
        if (locNames == null) {
            locNames = LocaleDisplayNames.getInstance(this._locale);
            this._localeDisplayNamesRef = new WeakReference<LocaleDisplayNames>(locNames);
        }
        return locNames;
    }

    private synchronized void loadStrings(String tzCanonicalID) {
        if (tzCanonicalID == null || tzCanonicalID.length() == 0) {
            return;
        }
        this.getGenericLocationName(tzCanonicalID);
        Set<String> mzIDs = this._tznames.getAvailableMetaZoneIDs(tzCanonicalID);
        for (String mzID : mzIDs) {
            String goldenID = this._tznames.getReferenceZoneID(mzID, this.getTargetRegion());
            if (tzCanonicalID.equals(goldenID)) continue;
            for (TimeZoneNames.NameType genNonLocType : GENERIC_NON_LOCATION_TYPES) {
                String mzGenName = this._tznames.getMetaZoneDisplayName(mzID, genNonLocType);
                if (mzGenName == null) continue;
                this.getPartialLocationName(tzCanonicalID, mzID, genNonLocType == TimeZoneNames.NameType.LONG_GENERIC, mzGenName);
            }
        }
    }

    private synchronized String getTargetRegion() {
        if (this._region == null) {
            this._region = this._locale.getCountry();
            if (this._region.length() == 0) {
                ULocale tmp = ULocale.addLikelySubtags(this._locale);
                this._region = tmp.getCountry();
                if (this._region.length() == 0) {
                    this._region = "001";
                }
            }
        }
        return this._region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPartialLocationName(String tzID, String mzID, boolean isLong, String mzDisplayName) {
        String letter = isLong ? "L" : "S";
        String key = tzID + "&" + mzID + "#" + letter;
        String name = this._genericPartialLocationNamesMap.get(key);
        if (name != null) {
            return name;
        }
        String location = null;
        String countryCode = ZoneMeta.getCanonicalCountry(tzID);
        if (countryCode != null) {
            String regionalGolden = this._tznames.getReferenceZoneID(mzID, countryCode);
            location = tzID.equals(regionalGolden) ? this.getLocaleDisplayNames().regionDisplayName(countryCode) : this._tznames.getExemplarLocationName(tzID);
        } else {
            location = this._tznames.getExemplarLocationName(tzID);
            if (location == null) {
                location = tzID;
            }
        }
        name = this.formatPattern(Pattern.FALLBACK_FORMAT, location, mzDisplayName);
        TimeZoneGenericNames timeZoneGenericNames = this;
        synchronized (timeZoneGenericNames) {
            String tmp = this._genericPartialLocationNamesMap.putIfAbsent(key.intern(), name.intern());
            if (tmp == null) {
                NameInfo info = new NameInfo(tzID.intern(), isLong ? GenericNameType.LONG : GenericNameType.SHORT);
                this._gnamesTrie.put(name, info);
            } else {
                name = tmp;
            }
        }
        return name;
    }

    public GenericMatchInfo findBestMatch(String text2, int start, EnumSet<GenericNameType> genericTypes) {
        Collection<GenericMatchInfo> localMatches;
        if (text2 == null || text2.length() == 0 || start < 0 || start >= text2.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        GenericMatchInfo bestMatch = null;
        Collection<TimeZoneNames.MatchInfo> tznamesMatches = this.findTimeZoneNames(text2, start, genericTypes);
        if (tznamesMatches != null) {
            TimeZoneNames.MatchInfo longestMatch = null;
            for (TimeZoneNames.MatchInfo matchInfo : tznamesMatches) {
                if (longestMatch != null && matchInfo.matchLength() <= longestMatch.matchLength()) continue;
                longestMatch = matchInfo;
            }
            if (longestMatch != null && (bestMatch = this.createGenericMatchInfo(longestMatch)).matchLength() == text2.length() - start && bestMatch.timeType != TimeZoneFormat.TimeType.STANDARD) {
                return bestMatch;
            }
        }
        if ((localMatches = this.findLocal(text2, start, genericTypes)) != null) {
            for (GenericMatchInfo genericMatchInfo : localMatches) {
                if (bestMatch != null && genericMatchInfo.matchLength() < bestMatch.matchLength()) continue;
                bestMatch = genericMatchInfo;
            }
        }
        return bestMatch;
    }

    public Collection<GenericMatchInfo> find(String text2, int start, EnumSet<GenericNameType> genericTypes) {
        if (text2 == null || text2.length() == 0 || start < 0 || start >= text2.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        Collection<GenericMatchInfo> results = this.findLocal(text2, start, genericTypes);
        Collection<TimeZoneNames.MatchInfo> tznamesMatches = this.findTimeZoneNames(text2, start, genericTypes);
        if (tznamesMatches != null) {
            for (TimeZoneNames.MatchInfo match : tznamesMatches) {
                if (results == null) {
                    results = new LinkedList<GenericMatchInfo>();
                }
                results.add(this.createGenericMatchInfo(match));
            }
        }
        return results;
    }

    private GenericMatchInfo createGenericMatchInfo(TimeZoneNames.MatchInfo matchInfo) {
        GenericNameType nameType = null;
        TimeZoneFormat.TimeType timeType = TimeZoneFormat.TimeType.UNKNOWN;
        switch (matchInfo.nameType()) {
            case LONG_STANDARD: {
                nameType = GenericNameType.LONG;
                timeType = TimeZoneFormat.TimeType.STANDARD;
                break;
            }
            case LONG_GENERIC: {
                nameType = GenericNameType.LONG;
                break;
            }
            case SHORT_STANDARD: {
                nameType = GenericNameType.SHORT;
                timeType = TimeZoneFormat.TimeType.STANDARD;
                break;
            }
            case SHORT_GENERIC: {
                nameType = GenericNameType.SHORT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected MatchInfo name type - " + (Object)((Object)matchInfo.nameType()));
            }
        }
        String tzID = matchInfo.tzID();
        if (tzID == null) {
            String mzID = matchInfo.mzID();
            assert (mzID != null);
            tzID = this._tznames.getReferenceZoneID(mzID, this.getTargetRegion());
        }
        assert (tzID != null);
        GenericMatchInfo gmatch = new GenericMatchInfo(nameType, tzID, matchInfo.matchLength(), timeType);
        return gmatch;
    }

    private Collection<TimeZoneNames.MatchInfo> findTimeZoneNames(String text2, int start, EnumSet<GenericNameType> types2) {
        Collection<TimeZoneNames.MatchInfo> tznamesMatches = null;
        EnumSet<TimeZoneNames.NameType> nameTypes = EnumSet.noneOf(TimeZoneNames.NameType.class);
        if (types2.contains((Object)GenericNameType.LONG)) {
            nameTypes.add(TimeZoneNames.NameType.LONG_GENERIC);
            nameTypes.add(TimeZoneNames.NameType.LONG_STANDARD);
        }
        if (types2.contains((Object)GenericNameType.SHORT)) {
            nameTypes.add(TimeZoneNames.NameType.SHORT_GENERIC);
            nameTypes.add(TimeZoneNames.NameType.SHORT_STANDARD);
        }
        if (!nameTypes.isEmpty()) {
            tznamesMatches = this._tznames.find(text2, start, nameTypes);
        }
        return tznamesMatches;
    }

    private synchronized Collection<GenericMatchInfo> findLocal(String text2, int start, EnumSet<GenericNameType> types2) {
        GenericNameSearchHandler handler2 = new GenericNameSearchHandler(types2);
        this._gnamesTrie.find(text2, start, handler2);
        if (handler2.getMaxMatchLen() == text2.length() - start || this._gnamesTrieFullyLoaded) {
            return handler2.getMatches();
        }
        Set<String> tzIDs = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, null, null);
        for (String tzID : tzIDs) {
            this.loadStrings(tzID);
        }
        this._gnamesTrieFullyLoaded = true;
        handler2.resetResults();
        this._gnamesTrie.find(text2, start, handler2);
        return handler2.getMatches();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    @Override
    public boolean isFrozen() {
        return this._frozen;
    }

    @Override
    public TimeZoneGenericNames freeze() {
        this._frozen = true;
        return this;
    }

    @Override
    public TimeZoneGenericNames cloneAsThawed() {
        TimeZoneGenericNames copy2 = null;
        try {
            copy2 = (TimeZoneGenericNames)super.clone();
            copy2._frozen = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return copy2;
    }

    private static class Cache
    extends SoftCache<String, TimeZoneGenericNames, ULocale> {
        private Cache() {
        }

        @Override
        protected TimeZoneGenericNames createInstance(String key, ULocale data) {
            return new TimeZoneGenericNames(data).freeze();
        }
    }

    private static class GenericNameSearchHandler
    implements TextTrieMap.ResultHandler<NameInfo> {
        private EnumSet<GenericNameType> _types;
        private Collection<GenericMatchInfo> _matches;
        private int _maxMatchLen;

        GenericNameSearchHandler(EnumSet<GenericNameType> types2) {
            this._types = types2;
        }

        @Override
        public boolean handlePrefixMatch(int matchLength, Iterator<NameInfo> values) {
            while (values.hasNext()) {
                NameInfo info = values.next();
                if (this._types != null && !this._types.contains((Object)info.type)) continue;
                GenericMatchInfo matchInfo = new GenericMatchInfo(info.type, info.tzID, matchLength);
                if (this._matches == null) {
                    this._matches = new LinkedList<GenericMatchInfo>();
                }
                this._matches.add(matchInfo);
                if (matchLength <= this._maxMatchLen) continue;
                this._maxMatchLen = matchLength;
            }
            return true;
        }

        public Collection<GenericMatchInfo> getMatches() {
            return this._matches;
        }

        public int getMaxMatchLen() {
            return this._maxMatchLen;
        }

        public void resetResults() {
            this._matches = null;
            this._maxMatchLen = 0;
        }
    }

    public static class GenericMatchInfo {
        final GenericNameType nameType;
        final String tzID;
        final int matchLength;
        final TimeZoneFormat.TimeType timeType;

        private GenericMatchInfo(GenericNameType nameType, String tzID, int matchLength) {
            this(nameType, tzID, matchLength, TimeZoneFormat.TimeType.UNKNOWN);
        }

        private GenericMatchInfo(GenericNameType nameType, String tzID, int matchLength, TimeZoneFormat.TimeType timeType) {
            this.nameType = nameType;
            this.tzID = tzID;
            this.matchLength = matchLength;
            this.timeType = timeType;
        }

        public GenericNameType nameType() {
            return this.nameType;
        }

        public String tzID() {
            return this.tzID;
        }

        public TimeZoneFormat.TimeType timeType() {
            return this.timeType;
        }

        public int matchLength() {
            return this.matchLength;
        }
    }

    private static class NameInfo {
        final String tzID;
        final GenericNameType type;

        NameInfo(String tzID, GenericNameType type) {
            this.tzID = tzID;
            this.type = type;
        }
    }

    public static enum Pattern {
        REGION_FORMAT("regionFormat", "({0})"),
        FALLBACK_FORMAT("fallbackFormat", "{1} ({0})");

        String _key;
        String _defaultVal;

        private Pattern(String key, String defaultVal) {
            this._key = key;
            this._defaultVal = defaultVal;
        }

        String key() {
            return this._key;
        }

        String defaultValue() {
            return this._defaultVal;
        }
    }

    public static enum GenericNameType {
        LOCATION("LONG", "SHORT"),
        LONG(new String[0]),
        SHORT(new String[0]);

        String[] _fallbackTypeOf;

        private GenericNameType(String ... fallbackTypeOf) {
            this._fallbackTypeOf = fallbackTypeOf;
        }

        public boolean isFallbackTypeOf(GenericNameType type) {
            String typeStr = type.toString();
            for (String t : this._fallbackTypeOf) {
                if (!t.equals(typeStr)) continue;
                return true;
            }
            return false;
        }
    }
}

