/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.util.EnumMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.python.icu.impl.CurrencyData;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SimpleFormatterImpl;
import org.python.icu.impl.StandardPlural;
import org.python.icu.impl.UResource;
import org.python.icu.impl.number.DecimalQuantity;
import org.python.icu.impl.number.MicroProps;
import org.python.icu.impl.number.MicroPropsGenerator;
import org.python.icu.impl.number.SimpleModifier;
import org.python.icu.number.NumberFormatter;
import org.python.icu.text.NumberFormat;
import org.python.icu.text.PluralRules;
import org.python.icu.util.Currency;
import org.python.icu.util.ICUException;
import org.python.icu.util.MeasureUnit;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class LongNameHandler
implements MicroPropsGenerator {
    private static final int DNAM_INDEX = StandardPlural.COUNT;
    private static final int PER_INDEX = StandardPlural.COUNT + 1;
    private static final int ARRAY_LENGTH = StandardPlural.COUNT + 2;
    private final Map<StandardPlural, SimpleModifier> modifiers;
    private final PluralRules rules;
    private final MicroPropsGenerator parent;

    private static int getIndex(String pluralKeyword) {
        if (pluralKeyword.equals("dnam")) {
            return DNAM_INDEX;
        }
        if (pluralKeyword.equals("per")) {
            return PER_INDEX;
        }
        return StandardPlural.fromString(pluralKeyword).ordinal();
    }

    private static String getWithPlural(String[] strings, StandardPlural plural) {
        String result2 = strings[plural.ordinal()];
        if (result2 == null) {
            result2 = strings[StandardPlural.OTHER.ordinal()];
        }
        if (result2 == null) {
            throw new ICUException("Could not find data in 'other' plural variant");
        }
        return result2;
    }

    private static void getMeasureData(ULocale locale2, MeasureUnit unit, NumberFormatter.UnitWidth width, String[] outArray) {
        PluralTableSink sink = new PluralTableSink(outArray);
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt62b/unit", locale2);
        StringBuilder key = new StringBuilder();
        key.append("units");
        if (width == NumberFormatter.UnitWidth.NARROW) {
            key.append("Narrow");
        } else if (width == NumberFormatter.UnitWidth.SHORT) {
            key.append("Short");
        }
        key.append("/");
        key.append(unit.getType());
        key.append("/");
        key.append(unit.getSubtype());
        try {
            resource.getAllItemsWithFallback(key.toString(), sink);
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("No data for unit " + unit + ", width " + (Object)((Object)width), e);
        }
    }

    private static void getCurrencyLongNameData(ULocale locale2, Currency currency, String[] outArray) {
        Map<String, String> data = CurrencyData.provider.getInstance(locale2, true).getUnitPatterns();
        for (Map.Entry<String, String> e : data.entrySet()) {
            String pluralKeyword = e.getKey();
            int index = LongNameHandler.getIndex(pluralKeyword);
            String longName = currency.getName(locale2, 2, pluralKeyword, null);
            String simpleFormat = e.getValue();
            outArray[index] = simpleFormat = simpleFormat.replace("{1}", longName);
        }
    }

    private static String getPerUnitFormat(ULocale locale2, NumberFormatter.UnitWidth width) {
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt62b/unit", locale2);
        StringBuilder key = new StringBuilder();
        key.append("units");
        if (width == NumberFormatter.UnitWidth.NARROW) {
            key.append("Narrow");
        } else if (width == NumberFormatter.UnitWidth.SHORT) {
            key.append("Short");
        }
        key.append("/compound/per");
        try {
            return resource.getStringWithFallback(key.toString());
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Could not find x-per-y format for " + locale2 + ", width " + (Object)((Object)width));
        }
    }

    private LongNameHandler(Map<StandardPlural, SimpleModifier> modifiers, PluralRules rules, MicroPropsGenerator parent) {
        this.modifiers = modifiers;
        this.rules = rules;
        this.parent = parent;
    }

    public static String getUnitDisplayName(ULocale locale2, MeasureUnit unit, NumberFormatter.UnitWidth width) {
        String[] measureData = new String[ARRAY_LENGTH];
        LongNameHandler.getMeasureData(locale2, unit, width, measureData);
        return measureData[DNAM_INDEX];
    }

    public static LongNameHandler forCurrencyLongNames(ULocale locale2, Currency currency, PluralRules rules, MicroPropsGenerator parent) {
        String[] simpleFormats = new String[ARRAY_LENGTH];
        LongNameHandler.getCurrencyLongNameData(locale2, currency, simpleFormats);
        EnumMap<StandardPlural, SimpleModifier> modifiers = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
        LongNameHandler.simpleFormatsToModifiers(simpleFormats, null, modifiers);
        return new LongNameHandler(modifiers, rules, parent);
    }

    public static LongNameHandler forMeasureUnit(ULocale locale2, MeasureUnit unit, MeasureUnit perUnit, NumberFormatter.UnitWidth width, PluralRules rules, MicroPropsGenerator parent) {
        if (perUnit != null) {
            MeasureUnit simplified = MeasureUnit.resolveUnitPerUnit(unit, perUnit);
            if (simplified != null) {
                unit = simplified;
            } else {
                return LongNameHandler.forCompoundUnit(locale2, unit, perUnit, width, rules, parent);
            }
        }
        String[] simpleFormats = new String[ARRAY_LENGTH];
        LongNameHandler.getMeasureData(locale2, unit, width, simpleFormats);
        EnumMap<StandardPlural, SimpleModifier> modifiers = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
        LongNameHandler.simpleFormatsToModifiers(simpleFormats, null, modifiers);
        return new LongNameHandler(modifiers, rules, parent);
    }

    private static LongNameHandler forCompoundUnit(ULocale locale2, MeasureUnit unit, MeasureUnit perUnit, NumberFormatter.UnitWidth width, PluralRules rules, MicroPropsGenerator parent) {
        String perUnitFormat;
        String[] primaryData = new String[ARRAY_LENGTH];
        LongNameHandler.getMeasureData(locale2, unit, width, primaryData);
        String[] secondaryData = new String[ARRAY_LENGTH];
        LongNameHandler.getMeasureData(locale2, perUnit, width, secondaryData);
        if (secondaryData[PER_INDEX] != null) {
            perUnitFormat = secondaryData[PER_INDEX];
        } else {
            String rawPerUnitFormat = LongNameHandler.getPerUnitFormat(locale2, width);
            StringBuilder sb = new StringBuilder();
            String compiled = SimpleFormatterImpl.compileToStringMinMaxArguments(rawPerUnitFormat, sb, 2, 2);
            String secondaryFormat = LongNameHandler.getWithPlural(secondaryData, StandardPlural.ONE);
            String secondaryCompiled = SimpleFormatterImpl.compileToStringMinMaxArguments(secondaryFormat, sb, 1, 1);
            String secondaryString = SimpleFormatterImpl.getTextWithNoArguments(secondaryCompiled).trim();
            perUnitFormat = SimpleFormatterImpl.formatCompiledPattern(compiled, "{0}", secondaryString);
        }
        EnumMap<StandardPlural, SimpleModifier> modifiers = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
        LongNameHandler.multiSimpleFormatsToModifiers(primaryData, perUnitFormat, null, modifiers);
        return new LongNameHandler(modifiers, rules, parent);
    }

    private static void simpleFormatsToModifiers(String[] simpleFormats, NumberFormat.Field field, Map<StandardPlural, SimpleModifier> output) {
        StringBuilder sb = new StringBuilder();
        for (StandardPlural plural : StandardPlural.VALUES) {
            String simpleFormat = LongNameHandler.getWithPlural(simpleFormats, plural);
            String compiled = SimpleFormatterImpl.compileToStringMinMaxArguments(simpleFormat, sb, 0, 1);
            output.put(plural, new SimpleModifier(compiled, field, false));
        }
    }

    private static void multiSimpleFormatsToModifiers(String[] leadFormats, String trailFormat, NumberFormat.Field field, Map<StandardPlural, SimpleModifier> output) {
        StringBuilder sb = new StringBuilder();
        String trailCompiled = SimpleFormatterImpl.compileToStringMinMaxArguments(trailFormat, sb, 1, 1);
        for (StandardPlural plural : StandardPlural.VALUES) {
            String leadFormat = LongNameHandler.getWithPlural(leadFormats, plural);
            String compoundFormat = SimpleFormatterImpl.formatCompiledPattern(trailCompiled, leadFormat);
            String compoundCompiled = SimpleFormatterImpl.compileToStringMinMaxArguments(compoundFormat, sb, 0, 1);
            output.put(plural, new SimpleModifier(compoundCompiled, field, false));
        }
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.parent.processQuantity(quantity);
        DecimalQuantity copy2 = quantity.createCopy();
        micros.rounder.apply(copy2);
        micros.modOuter = this.modifiers.get((Object)copy2.getStandardPlural(this.rules));
        return micros;
    }

    private static final class PluralTableSink
    extends UResource.Sink {
        String[] outArray;

        public PluralTableSink(String[] outArray) {
            this.outArray = outArray;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table pluralsTable = value.getTable();
            int i = 0;
            while (pluralsTable.getKeyAndValue(i, key, value)) {
                int index = LongNameHandler.getIndex(key.toString());
                if (this.outArray[index] == null) {
                    String formatString;
                    this.outArray[index] = formatString = value.getString();
                }
                ++i;
            }
        }
    }
}

