/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number.parse;

import org.python.icu.impl.StaticUnicodeSets;
import org.python.icu.impl.StringSegment;
import org.python.icu.impl.number.parse.ParsedNumber;
import org.python.icu.impl.number.parse.ParsingUtils;
import org.python.icu.impl.number.parse.SymbolMatcher;
import org.python.icu.text.DecimalFormatSymbols;

public class MinusSignMatcher
extends SymbolMatcher {
    private static final MinusSignMatcher DEFAULT = new MinusSignMatcher(false);
    private static final MinusSignMatcher DEFAULT_ALLOW_TRAILING = new MinusSignMatcher(true);
    private final boolean allowTrailing;

    public static MinusSignMatcher getInstance(DecimalFormatSymbols symbols2, boolean allowTrailing) {
        String symbolString = symbols2.getMinusSignString();
        if (ParsingUtils.safeContains(MinusSignMatcher.DEFAULT.uniSet, symbolString)) {
            return allowTrailing ? DEFAULT_ALLOW_TRAILING : DEFAULT;
        }
        return new MinusSignMatcher(symbolString, allowTrailing);
    }

    private MinusSignMatcher(String symbolString, boolean allowTrailing) {
        super(symbolString, MinusSignMatcher.DEFAULT.uniSet);
        this.allowTrailing = allowTrailing;
    }

    private MinusSignMatcher(boolean allowTrailing) {
        super(StaticUnicodeSets.Key.MINUS_SIGN);
        this.allowTrailing = allowTrailing;
    }

    @Override
    protected boolean isDisabled(ParsedNumber result2) {
        return !this.allowTrailing && result2.seenNumber();
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result2) {
        result2.flags |= 1;
        result2.setCharsConsumed(segment);
    }

    public String toString() {
        return "<MinusSignMatcher>";
    }
}

